/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyRep
implements Serializable {
    private static final long serialVersionUID = -4757683898830641853L;
    private static final String PKCS8 = "PKCS#8";
    private static final String X509 = "X.509";
    private static final String RAW = "RAW";
    private Type type;
    private String algorithm;
    private String format;
    private byte[] encoded;

    public KeyRep(Type type, String string, String string2, byte[] byArray) {
        if (type == null || string == null || string2 == null || byArray == null) {
            throw new NullPointerException("invalid null input(s)");
        }
        this.type = type;
        this.algorithm = string;
        this.format = string2.toUpperCase();
        this.encoded = (byte[])byArray.clone();
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            if (this.type == Type.SECRET && RAW.equals(this.format)) {
                return new SecretKeySpec(this.encoded, this.algorithm);
            }
            if (this.type == Type.PUBLIC && X509.equals(this.format)) {
                KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
                return keyFactory.generatePublic(new X509EncodedKeySpec(this.encoded));
            }
            if (this.type == Type.PRIVATE && PKCS8.equals(this.format)) {
                KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.encoded));
            }
            throw new NotSerializableException("unrecognized type/format combination: " + (Object)((Object)this.type) + "/" + this.format);
        }
        catch (NotSerializableException notSerializableException) {
            throw notSerializableException;
        }
        catch (Exception exception) {
            NotSerializableException notSerializableException = new NotSerializableException("java.security.Key: [" + (Object)((Object)this.type) + "] " + "[" + this.algorithm + "] " + "[" + this.format + "]");
            notSerializableException.initCause(exception);
            throw notSerializableException;
        }
    }

    public static enum Type {
        SECRET,
        PUBLIC,
        PRIVATE;

    }
}

