/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.external.amx;

import com.sun.org.glassfish.external.amx.AMXUtil;
import com.sun.org.glassfish.external.amx.MBeanListener;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class AMXGlassfish {
    public static final String DEFAULT_JMX_DOMAIN = "amx";
    public static final AMXGlassfish DEFAULT = new AMXGlassfish("amx");
    private final String mJMXDomain;
    private final ObjectName mDomainRoot;

    public AMXGlassfish(String string) {
        this.mJMXDomain = string;
        this.mDomainRoot = this.newObjectName("", "domain-root", null);
    }

    public static String getGlassfishVersion() {
        String string = System.getProperty("glassfish.version");
        return string;
    }

    public String amxJMXDomain() {
        return this.mJMXDomain;
    }

    public String amxSupportDomain() {
        return this.amxJMXDomain() + "-support";
    }

    public String dasName() {
        return "server";
    }

    public String dasConfig() {
        return this.dasName() + "-config";
    }

    public ObjectName domainRoot() {
        return this.mDomainRoot;
    }

    public ObjectName monitoringRoot() {
        return this.newObjectName("/", "mon", null);
    }

    public ObjectName serverMon(String string) {
        return this.newObjectName("/mon", "server-mon", string);
    }

    public ObjectName serverMonForDAS() {
        return this.serverMon("server");
    }

    public ObjectName newObjectName(String string, String string2, String string3) {
        String string4 = AMXGlassfish.prop("pp", string) + "," + AMXGlassfish.prop("type", string2);
        if (string3 != null) {
            string4 = string4 + "," + AMXGlassfish.prop("name", string3);
        }
        return this.newObjectName(string4);
    }

    public ObjectName newObjectName(String string) {
        String string2 = string;
        if (!string2.startsWith(this.amxJMXDomain())) {
            string2 = this.amxJMXDomain() + ":" + string2;
        }
        return AMXUtil.newObjectName(string2);
    }

    private static String prop(String string, String string2) {
        return string + "=" + string2;
    }

    public ObjectName getBootAMXMBeanObjectName() {
        return AMXUtil.newObjectName(this.amxSupportDomain() + ":type=boot-amx");
    }

    public void invokeBootAMX(MBeanServerConnection mBeanServerConnection) {
        try {
            mBeanServerConnection.invoke(this.getBootAMXMBeanObjectName(), "bootAMX", null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private static void invokeWaitAMXReady(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        try {
            mBeanServerConnection.invoke(objectName, "waitAMXReady", null, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public <T extends MBeanListener.Callback> MBeanListener<T> listenForDomainRoot(MBeanServerConnection mBeanServerConnection, T t) {
        MBeanListener<T> mBeanListener = new MBeanListener<T>(mBeanServerConnection, this.domainRoot(), t);
        mBeanListener.startListening();
        return mBeanListener;
    }

    public ObjectName waitAMXReady(MBeanServerConnection mBeanServerConnection) {
        WaitForDomainRootListenerCallback waitForDomainRootListenerCallback = new WaitForDomainRootListenerCallback(mBeanServerConnection);
        this.listenForDomainRoot(mBeanServerConnection, waitForDomainRootListenerCallback);
        waitForDomainRootListenerCallback.await();
        return waitForDomainRootListenerCallback.getRegistered();
    }

    public <T extends MBeanListener.Callback> MBeanListener<T> listenForBootAMX(MBeanServerConnection mBeanServerConnection, T t) {
        MBeanListener<T> mBeanListener = new MBeanListener<T>(mBeanServerConnection, this.getBootAMXMBeanObjectName(), t);
        mBeanListener.startListening();
        return mBeanListener;
    }

    public ObjectName bootAMX(MBeanServerConnection mBeanServerConnection) throws IOException {
        ObjectName objectName = this.domainRoot();
        if (!mBeanServerConnection.isRegistered(objectName)) {
            BootAMXCallback bootAMXCallback = new BootAMXCallback(mBeanServerConnection);
            this.listenForBootAMX(mBeanServerConnection, bootAMXCallback);
            bootAMXCallback.await();
            this.invokeBootAMX(mBeanServerConnection);
            WaitForDomainRootListenerCallback waitForDomainRootListenerCallback = new WaitForDomainRootListenerCallback(mBeanServerConnection);
            this.listenForDomainRoot(mBeanServerConnection, waitForDomainRootListenerCallback);
            waitForDomainRootListenerCallback.await();
            AMXGlassfish.invokeWaitAMXReady(mBeanServerConnection, objectName);
        } else {
            AMXGlassfish.invokeWaitAMXReady(mBeanServerConnection, objectName);
        }
        return objectName;
    }

    public ObjectName bootAMX(MBeanServer mBeanServer) {
        try {
            return this.bootAMX((MBeanServerConnection)mBeanServer);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static class BootAMXCallback
    extends MBeanListener.CallbackImpl {
        private final MBeanServerConnection mConn;

        public BootAMXCallback(MBeanServerConnection mBeanServerConnection) {
            this.mConn = mBeanServerConnection;
        }

        @Override
        public void mbeanRegistered(ObjectName objectName, MBeanListener mBeanListener) {
            super.mbeanRegistered(objectName, mBeanListener);
            this.mLatch.countDown();
        }
    }

    private static final class WaitForDomainRootListenerCallback
    extends MBeanListener.CallbackImpl {
        private final MBeanServerConnection mConn;

        public WaitForDomainRootListenerCallback(MBeanServerConnection mBeanServerConnection) {
            this.mConn = mBeanServerConnection;
        }

        @Override
        public void mbeanRegistered(ObjectName objectName, MBeanListener mBeanListener) {
            super.mbeanRegistered(objectName, mBeanListener);
            AMXGlassfish.invokeWaitAMXReady(this.mConn, objectName);
            this.mLatch.countDown();
        }
    }
}

