/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.ObjectFactory;
import com.sun.org.apache.xml.internal.serializer.utils.SystemIDResolver;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;

final class CharInfo {
    private HashMap m_charToString = new HashMap();
    public static final String HTML_ENTITIES_RESOURCE = "com.sun.org.apache.xml.internal.serializer.HTMLEntities";
    public static final String XML_ENTITIES_RESOURCE = "com.sun.org.apache.xml.internal.serializer.XMLEntities";
    public static final char S_HORIZONAL_TAB = '\t';
    public static final char S_LINEFEED = '\n';
    public static final char S_CARRIAGERETURN = '\r';
    final boolean onlyQuotAmpLtGt;
    private static final int ASCII_MAX = 128;
    private boolean[] isSpecialAttrASCII = new boolean[128];
    private boolean[] isSpecialTextASCII = new boolean[128];
    private boolean[] isCleanTextASCII = new boolean[128];
    private int[] array_of_bits = this.createEmptySetOfIntegers(65535);
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed;
    private static HashMap m_getCharInfoCache = new HashMap();

    private CharInfo(String string, String string2) {
        this(string, string2, false);
    }

    private CharInfo(String string, String string2, boolean bl) {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        ResourceBundle resourceBundle = null;
        boolean bl2 = true;
        if (bl) {
            try {
                resourceBundle = PropertyResourceBundle.getBundle(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle != null) {
            object3 = resourceBundle.getKeys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = resourceBundle.getString((String)object2);
                n2 = Integer.parseInt((String)object);
                this.defineEntity((String)object2, (char)n2);
                if (!this.extraEntity(n2)) continue;
                bl2 = false;
            }
            this.set(10);
            this.set(13);
        } else {
            object3 = null;
            try {
                if (bl) {
                    object3 = CharInfo.class.getResourceAsStream(string);
                } else {
                    object2 = ObjectFactory.findClassLoader();
                    object3 = object2 == null ? ClassLoader.getSystemResourceAsStream(string) : ((ClassLoader)object2).getResourceAsStream(string);
                    if (object3 == null) {
                        try {
                            object = new URL(string);
                            object3 = ((URL)object).openStream();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (object3 == null) {
                    throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{string, string}));
                }
                try {
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object3, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                }
                object = ((BufferedReader)object2).readLine();
                while (object != null) {
                    if (((String)object).length() == 0 || ((String)object).charAt(0) == '#') {
                        object = ((BufferedReader)object2).readLine();
                        continue;
                    }
                    n2 = ((String)object).indexOf(32);
                    if (n2 > 1) {
                        String string3 = ((String)object).substring(0, n2);
                        if (++n2 < ((String)object).length()) {
                            String string4 = ((String)object).substring(n2);
                            if ((n2 = string4.indexOf(32)) > 0) {
                                string4 = string4.substring(0, n2);
                            }
                            int n3 = Integer.parseInt(string4);
                            this.defineEntity(string3, (char)n3);
                            if (this.extraEntity(n3)) {
                                bl2 = false;
                            }
                        }
                    }
                    object = ((BufferedReader)object2).readLine();
                }
                ((InputStream)object3).close();
                this.set(10);
                this.set(13);
            }
            catch (Exception exception) {
                throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{string, exception.toString(), string, exception.toString()}));
            }
            finally {
                if (object3 != null) {
                    try {
                        ((InputStream)object3).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (n = 0; n < 128; ++n) {
            if ((32 <= n || 10 == n || 13 == n || 9 == n) && !this.get(n) || 34 == n) {
                this.isCleanTextASCII[n] = true;
                this.isSpecialTextASCII[n] = false;
                continue;
            }
            this.isCleanTextASCII[n] = false;
            this.isSpecialTextASCII[n] = true;
        }
        this.onlyQuotAmpLtGt = bl2;
        for (n = 0; n < 128; ++n) {
            this.isSpecialAttrASCII[n] = this.get(n);
        }
        if ("xml".equals(string2)) {
            this.isSpecialAttrASCII[9] = true;
        }
    }

    private void defineEntity(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder("&");
        stringBuilder.append(string);
        stringBuilder.append(';');
        String string2 = stringBuilder.toString();
        this.defineChar2StringMapping(string2, c);
    }

    String getOutputStringForChar(char c) {
        CharKey charKey = new CharKey();
        charKey.setChar(c);
        return (String)this.m_charToString.get(charKey);
    }

    final boolean isSpecialAttrChar(int n) {
        if (n < 128) {
            return this.isSpecialAttrASCII[n];
        }
        return this.get(n);
    }

    final boolean isSpecialTextChar(int n) {
        if (n < 128) {
            return this.isSpecialTextASCII[n];
        }
        return this.get(n);
    }

    final boolean isTextASCIIClean(int n) {
        return this.isCleanTextASCII[n];
    }

    private static CharInfo getCharInfoBasedOnPrivilege(final String string, final String string2, final boolean bl) {
        return (CharInfo)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new CharInfo(string, string2, bl);
            }
        });
    }

    static CharInfo getCharInfo(String string, String string2) {
        CharInfo charInfo = (CharInfo)m_getCharInfoCache.get(string);
        if (charInfo != null) {
            return charInfo;
        }
        try {
            charInfo = CharInfo.getCharInfoBasedOnPrivilege(string, string2, true);
            m_getCharInfoCache.put(string, charInfo);
            return charInfo;
        }
        catch (Exception exception) {
            try {
                return CharInfo.getCharInfoBasedOnPrivilege(string, string2, false);
            }
            catch (Exception exception2) {
                if (string.indexOf(58) < 0) {
                    String string3 = SystemIDResolver.getAbsoluteURIFromRelative(string);
                } else {
                    try {
                        String string4 = SystemIDResolver.getAbsoluteURI(string, null);
                    }
                    catch (TransformerException transformerException) {
                        throw new WrappedRuntimeException(transformerException);
                    }
                }
                return CharInfo.getCharInfoBasedOnPrivilege(string, string2, false);
            }
        }
    }

    private static int arrayIndex(int n) {
        return n >> 5;
    }

    private static int bit(int n) {
        int n2 = 1 << (n & 0x1F);
        return n2;
    }

    private int[] createEmptySetOfIntegers(int n) {
        this.firstWordNotUsed = 0;
        int[] nArray = new int[CharInfo.arrayIndex(n - 1) + 1];
        return nArray;
    }

    private final void set(int n) {
        this.setASCIIdirty(n);
        int n2 = n >> 5;
        int n3 = n2 + 1;
        if (this.firstWordNotUsed < n3) {
            this.firstWordNotUsed = n3;
        }
        int n4 = n2;
        this.array_of_bits[n4] = this.array_of_bits[n4] | 1 << (n & 0x1F);
    }

    private final boolean get(int n) {
        boolean bl = false;
        int n2 = n >> 5;
        if (n2 < this.firstWordNotUsed) {
            bl = (this.array_of_bits[n2] & 1 << (n & 0x1F)) != 0;
        }
        return bl;
    }

    private boolean extraEntity(int n) {
        boolean bl = false;
        if (n < 128) {
            switch (n) {
                case 34: 
                case 38: 
                case 60: 
                case 62: {
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void setASCIIdirty(int n) {
        if (0 <= n && n < 128) {
            this.isCleanTextASCII[n] = false;
            this.isSpecialTextASCII[n] = true;
        }
    }

    private void setASCIIclean(int n) {
        if (0 <= n && n < 128) {
            this.isCleanTextASCII[n] = true;
            this.isSpecialTextASCII[n] = false;
        }
    }

    private void defineChar2StringMapping(String string, char c) {
        CharKey charKey = new CharKey(c);
        this.m_charToString.put(charKey, string);
        this.set(c);
    }

    private static class CharKey {
        private char m_char;

        public CharKey(char c) {
            this.m_char = c;
        }

        public CharKey() {
        }

        public final void setChar(char c) {
            this.m_char = c;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object object) {
            return ((CharKey)object).m_char == this.m_char;
        }
    }
}

