/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.attr.Target;
import iaik.x509.attr.TargetException;
import java.util.Enumeration;
import java.util.Vector;

public class Targets
implements ASN1Type {
    private Vector a = new Vector();

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isEmpty()) {
            stringBuffer.append("Empty Target list.");
        } else if (bl) {
            int n2 = 1;
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                if (n2 > 1) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("Target " + n2++ + ":\n");
                Util.printIndented(enumeration.nextElement().toString(), true, stringBuffer);
            }
        } else {
            stringBuffer.append("Target list contains " + this.a.size() + " element(s).");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            sEQUENCE.addComponent(((Target)enumeration.nextElement()).toASN1Object());
        }
        return sEQUENCE;
    }

    public int size() {
        return this.a.size();
    }

    public void setTargets(Target[] targetArray) {
        this.a.removeAllElements();
        if (targetArray != null) {
            int n2 = 0;
            while (n2 < targetArray.length) {
                this.a.addElement(targetArray[n2]);
                ++n2;
            }
        }
    }

    public boolean removeTarget(Target target) {
        return this.a.removeElement(target);
    }

    public void removeAllTargets() {
        this.a.removeAllElements();
    }

    public boolean isTargetFor(Object object) throws TargetException {
        boolean bl = false;
        if (this.a.size() == 0) {
            bl = true;
        } else {
            Enumeration enumeration = this.a.elements();
            TargetException targetException = null;
            while (enumeration.hasMoreElements()) {
                Target target = (Target)enumeration.nextElement();
                try {
                    if (!target.isTargetFor(object)) continue;
                    bl = true;
                    break;
                }
                catch (TargetException targetException2) {
                    targetException = targetException2;
                }
            }
            if (!bl && targetException != null) {
                throw targetException;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n2 = this.size();
        try {
            n2 = Util.calculateHashCode(DerCoder.encode(this.toASN1Object()));
        }
        catch (CodingException codingException) {}
        return n2;
    }

    public Target[] getTargets() {
        Object[] objectArray = new Target[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof Targets) {
            Targets targets = (Targets)object;
            if (this.a.size() == targets.a.size()) {
                bl = true;
                Target[] targetArray = this.getTargets();
                Target[] targetArray2 = targets.getTargets();
                int n2 = 0;
                while (n2 < targetArray.length) {
                    if (!targetArray[n2].equals(targetArray2[n2])) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getTag() + "). Expected SEQUENCE.");
        }
        this.a.removeAllElements();
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            this.a.addElement(Target.parseTarget(aSN1Object.getComponentAt(n2)));
            ++n2;
        }
    }

    public boolean containsTarget(Target target) {
        return this.a.contains(target);
    }

    public boolean addTarget(Target target) {
        boolean bl = true;
        if (this.a.contains(target)) {
            bl = false;
        } else {
            this.a.addElement(target);
        }
        return bl;
    }

    public Targets(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public Targets() {
    }
}

