/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.Name;
import iaik.cms.CMSParsingException;
import iaik.cms.OtherRevocationInfo;
import iaik.x509.X509CRL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.util.Enumeration;
import java.util.Vector;

public class RevocationInfoChoices {
    private Vector a = new Vector();
    private static boolean b = DebugCMS.getDebugMode() && b;

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRLs: " + this.a.size());
        stringBuffer.append(" -- " + this.a() + " other revocation info(s)\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        SET sET = new SET();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            CRL cRL = (CRL)enumeration.nextElement();
            if (cRL instanceof X509CRL) {
                sET.addComponent(((X509CRL)cRL).toASN1Object());
                continue;
            }
            if (cRL instanceof OtherRevocationInfo) {
                int n2 = 1;
                OtherRevocationInfo otherRevocationInfo = (OtherRevocationInfo)cRL;
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)otherRevocationInfo.getOtherRevInfoFormat());
                sEQUENCE.addComponent(otherRevocationInfo.toASN1Object());
                sET.addComponent((ASN1Object)new CON_SPEC(n2, (ASN1Object)sEQUENCE, true));
                continue;
            }
            throw new CodingException("Unknown recovationInfo type: " + cRL.getType() + "!");
        }
        return sET;
    }

    public void setRevocationInfos(CRL[] cRLArray) {
        this.a.removeAllElements();
        this.addRevocationInfos(cRLArray);
    }

    public void removeAllRevocationInfos() {
        this.a.removeAllElements();
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public X509CRL[] getX509CRLs() {
        Object object;
        Vector vector = new Vector();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof X509CRL)) continue;
            vector.addElement(object);
        }
        object = new X509CRL[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public X509CRL getX509CRL(Name name) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            X509CRL x509CRL;
            CRL cRL = (CRL)enumeration.nextElement();
            if (!(cRL instanceof X509CRL) || !(x509CRL = (X509CRL)cRL).getIssuerDN().equals(name)) continue;
            return x509CRL;
        }
        return null;
    }

    public CRL[] getRevocationInfos() {
        int n2 = this.a.size();
        Object[] objectArray = new CRL[n2];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public OtherRevocationInfo[] getOtherRevocationInfos() {
        Object object;
        Vector vector = new Vector();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof OtherRevocationInfo)) continue;
            vector.addElement(object);
        }
        object = new OtherRevocationInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decode(InputStream inputStream) throws CMSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = (DerInputStream)inputStream;
        DerInputStream derInputStream2 = derInputStream.readSet();
        try {
            while (true) {
                if (derInputStream2.nextTag() <= -1) {
                    return;
                }
                if (derInputStream2.nextIsContextSpecific()) {
                    int n2 = derInputStream2.readContextSpecific(16);
                    if (n2 != 1) {
                        throw new CMSParsingException("Invalid implicit tag " + n2 + " for RevocationInfoChoices!");
                    }
                    DerInputStream derInputStream3 = derInputStream2.readSequence();
                    ObjectID objectID = derInputStream3.readObjectID();
                    try {
                        this.a.addElement(new OtherRevocationInfo(objectID, (InputStream)derInputStream3));
                    }
                    catch (CodingException codingException) {
                        throw new CMSParsingException("Error parsing other revocation info: " + codingException.getMessage());
                    }
                }
                this.a.addElement(new X509CRL((InputStream)derInputStream2));
            }
        }
        catch (CRLException cRLException) {
            throw new CMSParsingException(cRLException.getMessage());
        }
    }

    private int b() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof X509CRL)) continue;
            ++n2;
        }
        return n2;
    }

    private int a() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof OtherRevocationInfo)) continue;
            ++n2;
        }
        return n2;
    }

    public boolean containsX509CRLs() {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof X509CRL)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOtherRevocationInfos() {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof OtherRevocationInfo)) continue;
            return true;
        }
        return false;
    }

    public void addRevocationInfos(CRL[] cRLArray) {
        int n2 = 0;
        while (n2 < cRLArray.length) {
            this.addRevocationInfo(cRLArray[n2]);
            ++n2;
        }
    }

    public void addRevocationInfo(CRL cRL) {
        if (!(cRL instanceof X509CRL) && !(cRL instanceof OtherRevocationInfo)) {
            throw new IllegalArgumentException("Only iaik.x509.X509CRLs or iaik.cms.OtherCRLs are allowed!");
        }
        this.a.addElement(cRL);
    }

    public RevocationInfoChoices(InputStream inputStream) throws IOException, CMSParsingException {
        this();
        this.decode(inputStream);
    }

    public RevocationInfoChoices() {
    }
}

