/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.utils.CryptoUtils;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import java.util.Hashtable;

public class AVA
implements ASN1Type {
    private ASN1Object e;
    private ObjectID a;
    static ASN b;
    static ASN d;
    static Hashtable c;

    public String toString(boolean bl) {
        Object object = AVA.a(this.e, this.a);
        if (!(object instanceof String)) {
            try {
                object = AVA.a(this.e, true, ":");
            }
            catch (Exception exception) {
                object = AVA.a(this.e, this.a);
            }
        }
        return String.valueOf(bl ? this.a.getName() : this.a.getShortName()) + "=" + object;
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        sEQUENCE.addComponent(this.e);
        return sEQUENCE;
    }

    public static void setNonPrintableDefaultEncoding(ASN aSN) {
        b = aSN;
    }

    public static void setDefaultEncoding(ASN aSN) {
        d = aSN;
    }

    private static ASN1Object a(Object object, ObjectID objectID, ASN aSN) throws CodingException {
        try {
            ASN aSN2 = AVA.getEncoding(objectID);
            if (aSN != null) {
                aSN2 = aSN;
            }
            if (aSN2 == null) {
                aSN2 = d;
                if (object instanceof String && (d == ASN.NumericString || d == ASN.PrintableString) && !PrintableString.isPrintableString((String)object)) {
                    aSN2 = b;
                }
            }
            if (objectID == ObjectID.uniqueIdentifier && object instanceof String && aSN2.equals(ASN.BIT_STRING)) {
                PrintableString printableString = new PrintableString((String)object);
                BIT_STRING bIT_STRING = new BIT_STRING(DerCoder.encode(printableString));
                return bIT_STRING;
            }
            return ASN.create(aSN2, object);
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public int hashCode() {
        return this.a.hashCode() + AVA.a(this.e, this.a).hashCode();
    }

    private static Object a(ASN1Object aSN1Object, ObjectID objectID) {
        Object object = null;
        if (objectID.equals(ObjectID.uniqueIdentifier) && !aSN1Object.isA(ASN.PrintableString)) {
            try {
                ASN1Object aSN1Object2 = DerCoder.decode((byte[])aSN1Object.getValue());
                object = aSN1Object2.getValue();
            }
            catch (Exception exception) {}
        }
        if (object == null) {
            object = aSN1Object.getValue();
        }
        return object;
    }

    public Object getValue() {
        return AVA.a(this.e, this.a);
    }

    public ObjectID getType() {
        return this.a;
    }

    public String getRFC2253String(boolean bl) throws RFC2253NameParserException {
        Object object = AVA.a(this.e, this.a);
        ASN aSN = this.e.getAsnType();
        boolean bl2 = aSN.equals(ASN.BIT_STRING);
        if (!(object instanceof String) || bl2 || !ObjectID.hasRegisteredName(this.a.getID())) {
            try {
                object = AVA.a(this.e, false, "");
            }
            catch (Exception exception) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + exception.getMessage());
            }
        } else if (object instanceof String) {
            try {
                object = UTF8String.getRFC2253String((String)object, bl);
            }
            catch (CodingException codingException) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + codingException.getMessage());
            }
        } else {
            throw new RFC2253NameParserException("Cannot write this AVA: unknown representation.");
        }
        return String.valueOf(this.a.getShortName()) + "=" + object;
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        return this.getRFC2253String(true);
    }

    public static ASN getNonPrintableDefaultEncoding() {
        return b;
    }

    private static String a(ASN1Object aSN1Object, boolean bl, String string) {
        String string2;
        if (aSN1Object.isA(ASN.BIT_STRING) && bl) {
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object;
            string2 = "#'" + bIT_STRING.getBinaryString() + "'B";
        } else {
            byte[] byArray = DerCoder.encode(aSN1Object);
            String string3 = Util.toString(byArray, string);
            string2 = "#" + string3;
        }
        return string2;
    }

    public static ASN getEncoding(ObjectID objectID) {
        return (ASN)c.get(objectID);
    }

    public static ASN getDefaultEncoding() {
        return d;
    }

    public ASN1Object getASN1Value() throws CodingException {
        return this.e;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        if (!this.a.equals(aVA.a)) {
            return false;
        }
        if (this.e.isStringType()) {
            return ((ASN1String)this.e).equals(aVA.e);
        }
        return CryptoUtils.equalsBlock(DerCoder.encode(this.e), DerCoder.encode(aVA.e));
    }

    public static void defineEncoding(ObjectID objectID, ASN aSN) {
        c.put(objectID, aSN);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = (ObjectID)aSN1Object.getComponentAt(0);
        this.e = aSN1Object.getComponentAt(1);
    }

    public AVA(ObjectID objectID, Object object, ASN aSN) throws IllegalArgumentException {
        if (objectID == null || object == null) {
            throw new IllegalArgumentException("Type and value must be non null for creating an AVA!");
        }
        this.a = objectID;
        if (object instanceof ASN1Object) {
            this.e = (ASN1Object)object;
            return;
        }
        try {
            this.e = AVA.a(object, objectID, aSN);
            return;
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Cannot create ASN.1 representation of given object for requested type!");
        }
    }

    public AVA(ObjectID objectID, Object object) throws IllegalArgumentException {
        this(objectID, object, null);
    }

    public AVA(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot create an AVA from a null object!");
        }
        this.decode(aSN1Object);
    }

    static {
        c = new Hashtable();
        d = ASN.PrintableString;
        b = ASN.UTF8String;
        AVA.defineEncoding(ObjectID.emailAddress, ASN.IA5String);
        AVA.defineEncoding(ObjectID.uniqueIdentifier, ASN.BIT_STRING);
    }
}

