/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Statement;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;

public abstract class NotifyingSailConnectionBase
extends SailConnectionBase
implements NotifyingSailConnection {
    private List<SailConnectionListener> listeners = new ArrayList<SailConnectionListener>(0);

    public NotifyingSailConnectionBase(SailBase sailBase) {
        super(sailBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(SailConnectionListener listener) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(SailConnectionListener listener) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasConnectionListeners() {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            return !this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStatementAdded(Statement st) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            for (SailConnectionListener listener : this.listeners) {
                listener.statementAdded(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStatementRemoved(Statement st) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            for (SailConnectionListener listener : this.listeners) {
                listener.statementRemoved(st);
            }
        }
    }
}

