/* @(#)caplist.c	1.9 09/07/05 Copyright 2000-2008 J. Schilling */
/*
 *	The list of capabilities for the termcap command
 *
 *	Copyright (c) 2000-2008 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

/*
 * Termcap Terminfo	Terminfo variable		Comment
 * name    name		name
 */

/*
 * Boolean capabilities:
 */
{ "--",	"--",		"BOOL",				"--" },
{ "bw",	"bw",		"auto_left_margin",		"cursor_left wraps from column 0 to last column" },
{ "am",	"am",		"auto_right_margin",		"terminal has automatic margins" },
{ "xb",	"xsb",		"no_esc_ctlc",			"beehive (f1=escape, f2=ctrl C)" },
{ "xs",	"xhp",		"ceol_standout_glitch",		"standout not erased by overwriting (hp)" },
{ "xn",	"xenl",		"eat_newline_glitch",		"newline ignored after 80 cols (concept)" },
{ "eo",	"eo",		"erase_overstrike",		"can erase overstrikes with a blank" },
{ "gn",	"gn",		"generic_type",			"generic line type" },
{ "hc",	"hc",		"hard_copy",			"hardcopy terminal" },
{ "km",	"km",		"has_meta_key",			"Has a meta key, sets msb high" },
{ "hs",	"hs",		"has_status_line",		"has extra status line" },
{ "in",	"in",		"insert_null_glitch",		"insert mode distinguishes nulls" },
{ "da",	"da",		"memory_above",			"display may be retained above the screen" },
{ "db",	"db",		"memory_below",			"display may be retained below the screen" },
{ "mi",	"mir",		"move_insert_mode",		"safe to move while in insert mode" },
{ "ms",	"msgr",		"move_standout_mode",		"safe to move while in standout mode" },
{ "os",	"os",		"over_strike",			"terminal can overstrike" },
{ "es",	"eslok",	"status_line_esc_ok",		"escape can be used on the status line" },
{ "xt",	"xt",		"dest_tabs_magic_smso",		"tabs destructive, magic so char (t1061)" },
{ "hz",	"hz",		"tilde_glitch",			"can't print ~'s (hazeltine)" },
{ "ul",	"ul",		"transparent_underline",	"underline character overstrikes" },
{ "xo",	"xon",		"xon_xoff",			"terminal uses xon/xoff handshaking" },
{ "nx",	"nxon",		"needs_xon_xoff",		"padding won't work, xon/xoff required" },
{ "5i",	"mc5i",		"prtr_silent",			"printer won't echo on screen" },
{ "HC",	"chts",		"hard_cursor",			"cursor is hard to see" },
{ "NR",	"nrrmc",	"non_rev_rmcup",		"enter_ca_mode does not reverse exit_ca_mode" },
{ "NP",	"npc",		"no_pad_char",			"pad character does not exist" },
{ "ND",	"ndscr",	"non_dest_scroll_region",	"scrolling region is non-destructive" },
{ "cc",	"ccc",		"can_change",			"terminal can re-define existing colors" },
{ "ut",	"bce",		"back_color_erase",		"screen erased with background color" },
{ "hl",	"hls",		"hue_lightness_saturation",	"terminal uses only HLS color notation (tektronix)" },
{ "YA",	"xhpa",		"col_addr_glitch",		"only positive motion for column address and micro_column_address caps" },
{ "YB",	"crxm",		"cr_cancels_micro_mode",	"using cr turns off micro mode" },
{ "YC",	"daisy",	"has_print_wheel",		"printer needs operator to change character set" },
{ "YD",	"xvpa",		"row_addr_glitch",		"only positive motion for row_address and micro_row_address caps" },
{ "YE",	"sam",		"semi_auto_right_margin",	"printing in last column causes cr" },
{ "YF",	"cpix",		"cpi_changes_res",		"changing character pitch changes resolution" },
{ "YG",	"lpix",		"lpi_changes_res",		"changing line pitch changes resolution" },

/*
 * Numeric capabilities:
 */
{ "--",	"--",		"INT",				"--" },
{ "co",	"cols",		"columns",			"number of columns in a line" },
{ "it",	"it",		"init_tabs",			"tabs initially every # spaces" },
{ "li",	"lines",	"lines",			"number of lines on screen or page" },
{ "lm",	"lm",		"lines_of_memory",		"lines of memory if > line. 0 => varies" },
{ "sg",	"xmc",		"magic_cookie_glitch",		"number of blank chars left by enter_standout_mode or exit_standout_mode" },
{ "pb",	"pb",		"padding_baud_rate",		"lowest baud rate where padding needed" },
{ "vt",	"vt",		"virtual_terminal",		"virtual terminal number (CB/unix)" },
{ "ws",	"wsl",		"width_status_line",		"columns in status line" },
{ "Nl",	"nlab",		"num_labels",			"number of labels on screen" },
{ "lh",	"lh",		"label_height",			"rows in each label" },
{ "lw",	"lw",		"label_width",			"columns in each label" },
{ "ma",	"ma",		"max_attributes",		"maximum combined attributes terminal can handle" },
{ "MW",	"wnum",		"maximum_windows",		"maximum number of definable windows" },
{ "ug",	"ug",		"magic_cookie_glitch_ul",	"number of blanks left by underline" },

	/*
	 * These came in with SVr4's color support
	 */
{ "Co",	"colors",	"max_colors",			"maximum numbers of colors on screen" },
{ "pa",	"pairs",	"max_pairs",			"maximum number of color-pairs on the screen" },
{ "NC",	"ncv",		"no_color_video",		"video attributes that can't be used with colors" },

	/*
	 * The following numeric capabilities are present in the SVr4.0 term
	 * structure, but are not yet documented in the man page.
	 * They came in with SVr4's printer support.
	 */
{ "Ya",	"bufsz",	"buffer_capacity",		"numbers of bytes buffered before printing" },
{ "Yb",	"spinv",	"dot_vert_spacing",		"spacing of pins vertically in pins per inch" },
{ "Yc",	"spinh",	"dot_horz_spacing",		"spacing of dots horizontally in dots per inch" },
{ "Yd",	"maddr",	"max_micro_address",		"maximum value in micro_..._address" },
{ "Ye",	"mjump",	"max_micro_jump",		"maximum value in parm_..._micro" },
{ "Yf",	"mcs",		"micro_char_size",		"character size when in micro mode" },
{ "Yg",	"mls",		"micro_line_size",		"line size when in micro mode" },
{ "Yh",	"npins",	"number_of_pins",		"numbers of pins in print-head" },
{ "Yi",	"orc",		"output_res_char",		"horizontal resolution in units per line" },
{ "Yj",	"orl",		"output_res_line",		"vertical resolution in units per line" },
{ "Yk",	"orhi",		"output_res_horz_inch",		"horizontal resolution in units per inch" },
{ "Yl",	"orvi",		"output_res_vert_inch",		"vertical resolution in units per inch" },
{ "Ym",	"cps",		"print_rate",			"print rate in chars per second" },
{ "Yn",	"widcs",	"wide_char_size",		"character step size when in double wide mode" },
{ "BT",	"btns",		"buttons",			"number of buttons on mouse" },
{ "Yo",	"bitwin",	"bit_image_entwining",		"number of passed for each bit-image row" },
{ "Yp",	"bitype",	"bit_image_type",		"type of bit-image device" },

/*
 * String capabilities:
 */
{ "--",	"--",		"STRING",			"--" },
{ "bt",	"cbt",		"back_tab",			"back tab (P)" },
{ "bl",	"bel",		"bell",				"audible signal (bell) (P)" },
{ "cr",	"cr",		"carriage_return",		"carriage return (P*)" },
{ "cs",	"csr",		"change_scroll_region",		"change region to line #1 to line #2 (NP)" },
{ "ct",	"tbc",		"clear_all_tabs",		"clear all tab stops (P)" },
{ "cl",	"clear",	"clear_screen",			"clear screen and home cursor (P*)" },
{ "ce",	"el",		"clr_eol",			"clear to end of line (P)" },
{ "cd",	"ed",		"clr_eos",			"clear to end of screen (P*)" },
{ "ch",	"hpa",		"column_address",		"horizontal position #1, absolute (NP)" },
{ "CC",	"cmdch",	"command_character",		"terminal settable cmd character in prototype" },
{ "cm",	"cup",		"cursor_address",		"move to row #1 column #2 (NP)" },
{ "do",	"cud1",		"cursor_down",			"down one line" },
{ "ho",	"home",		"cursor_home",			"home cursor" },
{ "vi",	"civis",	"cursor_invisible",		"make cursor invisible" },
{ "le",	"cub1",		"cursor_left",			"move left one space" },
{ "CM",	"mrcup",	"cursor_mem_address",		"memory relative cursor addressing to row #1 (N)" },
{ "ve",	"cnorm",	"cursor_normal",		"make cursor appear normal (undo cursor_invisible/cursor_visible)" },
{ "nd",	"cuf1",		"cursor_right",			"move right one space" },
{ "ll",	"ll",		"cursor_to_ll",			"last line, first column" },
{ "up",	"cuu1",		"cursor_up",			"up one line" },
{ "vs",	"cvvis",	"cursor_visible",		"make cursor very visible" },
{ "dc",	"dch1",		"delete_character",		"delete character (P*)" },
{ "dl",	"dl1",		"delete_line",			"delete line (P*)" },
{ "ds",	"dsl",		"dis_status_line",		"disable status line" },
{ "hd",	"hd",		"down_half_line",		"half a line down" },
{ "as",	"smacs",	"enter_alt_charset_mode",	"start alternate character set (P)" },
{ "mb",	"blink",	"enter_blink_mode",		"turn on blinking" },
{ "md",	"bold",		"enter_bold_mode",		"turn on bold (extra bright) mode" },
{ "ti",	"smcup",	"enter_ca_mode",		"string to start programs using cursor_address" },
{ "dm",	"smdc",		"enter_delete_mode",		"enter delete mode" },
{ "mh",	"dim",		"enter_dim_mode",		"turn on half-bright mode" },
{ "im",	"smir",		"enter_insert_mode",		"enter insert mode" },
{ "mk",	"invis",	"enter_secure_mode",		"turn on blank mode (characters invisible)" },
{ "mp",	"prot",		"enter_protected_mode",		"turn on protected mode" },
{ "mr",	"rev",		"enter_reverse_mode",		"turn on reverse video mode" },
{ "so",	"smso",		"enter_standout_mode",		"begin standout mode" },
{ "us",	"smul",		"enter_underline_mode",		"begin underline mode" },
{ "ec",	"ech",		"erase_chars",			"erase #1 characters (NP)" },
{ "ae",	"rmacs",	"exit_alt_charset_mode",	"end alternate character set (P)" },
{ "me",	"sgr0",		"exit_attribute_mode",		"turn off all attributes" },
{ "te",	"rmcup",	"exit_ca_mode",			"strings to end programs using cup" },
{ "ed",	"rmdc",		"exit_delete_mode",		"end delete mode" },
{ "ei",	"rmir",		"exit_insert_mode",		"exit insert mode" },
{ "se",	"rmso",		"exit_standout_mode",		"exit standout mode" },
{ "ue",	"rmul",		"exit_underline_mode",		"exit underline mode" },
{ "vb",	"flash",	"flash_screen",			"visible bell (may not move cursor)" },
{ "ff",	"ff",		"form_feed",			"hardcopy terminal page eject (P*)" },
{ "fs",	"fsl",		"from_status_line",		"return from status line" },
{ "i1",	"is1",		"init_1string",			"initialization string" },
{ "is",	"is2",		"init_2string",			"initialization string" },
{ "i3",	"is3",		"init_3string",			"initialization string" },
{ "if",	"if",		"init_file",			"name of initialization file" },
{ "ic",	"ich1",		"insert_character",		"insert character (P)" },
{ "al",	"il1",		"insert_line",			"insert line (P*)" },
{ "ip",	"ip",		"insert_padding",		"insert padding after inserted character" },
{ "kb",	"kbs",		"key_backspace",		"backspace key" },
{ "ka",	"ktbc",		"key_catab",			"clear-all-tabs key" },
{ "kC",	"kclr",		"key_clear",			"clear-screen or erase key" },
{ "kt",	"kctab",	"key_ctab",			"clear-tab key" },
{ "kD",	"kdch1",	"key_dc",			"delete-character key" },
{ "kL",	"kdl1",		"key_dl",			"delete-line key" },
{ "kd",	"kcud1",	"key_down",			"down-arrow key" },
{ "kM",	"krmir",	"key_eic",			"sent by rmir or smir in insert mode" },
{ "kE",	"kel",		"key_eol",			"clear-to-end-of-line key" },
{ "kS",	"ked",		"key_eos",			"clear-to-end-of-screen key" },
{ "k0",	"kf0",		"key_f0",			"F0 function key" },
{ "k1",	"kf1",		"key_f1",			"F1 function key" },
{ "k;",	"kf10",		"key_f10",			"F10 function key" },
{ "k2",	"kf2",		"key_f2",			"F2 function key" },
{ "k3",	"kf3",		"key_f3",			"F3 function key" },
{ "k4",	"kf4",		"key_f4",			"F4 function key" },
{ "k5",	"kf5",		"key_f5",			"F5 function key" },
{ "k6",	"kf6",		"key_f6",			"F6 function key" },
{ "k7",	"kf7",		"key_f7",			"F7 function key" },
{ "k8",	"kf8",		"key_f8",			"F8 function key" },
{ "k9",	"kf9",		"key_f9",			"F9 function key" },
{ "kh",	"khome",	"key_home",			"home key" },
{ "kI",	"kich1",	"key_ic",			"insert-character key" },
{ "kA",	"kil1",		"key_il",			"insert-line key" },
{ "kl",	"kcub1",	"key_left",			"left-arrow key" },
{ "kH",	"kll",		"key_ll",			"last-line key" },
{ "kN",	"knp",		"key_npage",			"next-page key" },
{ "kP",	"kpp",		"key_ppage",			"prev-page key" },
{ "kr",	"kcuf1",	"key_right",			"right-arrow key" },
{ "kF",	"kind",		"key_sf",			"scroll-forward key" },
{ "kR",	"kri",		"key_sr",			"scroll-backward key" },
{ "kT",	"khts",		"key_stab",			"set-tab key" },
{ "ku",	"kcuu1",	"key_up",			"up-arrow key" },
{ "ke",	"rmkx",		"keypad_local",			"leave 'keyboard_transmit' mode" },
{ "ks",	"smkx",		"keypad_xmit",			"enter 'keyboard_transmit' mode" },
{ "l0",	"lf0",		"lab_f0",			"label on function key f0 if not f0" },
{ "l1",	"lf1",		"lab_f1",			"label on function key f1 if not f1" },
{ "la",	"lf10",		"lab_f10",			"label on function key f10 if not f10" },
{ "l2",	"lf2",		"lab_f2",			"label on function key f2 if not f2" },
{ "l3",	"lf3",		"lab_f3",			"label on function key f3 if not f3" },
{ "l4",	"lf4",		"lab_f4",			"label on function key f4 if not f4" },
{ "l5",	"lf5",		"lab_f5",			"label on function key f5 if not f5" },
{ "l6",	"lf6",		"lab_f6",			"label on function key f6 if not f6" },
{ "l7",	"lf7",		"lab_f7",			"label on function key f7 if not f7" },
{ "l8",	"lf8",		"lab_f8",			"label on function key f8 if not f8" },
{ "l9",	"lf9",		"lab_f9",			"label on function key f9 if not f9" },
{ "mo",	"rmm",		"meta_off",			"turn off meta mode" },
{ "mm",	"smm",		"meta_on",			"turn on meta mode (8th-bit on)" },
{ "nw",	"nel",		"newline",			"newline (behave like cr followed by lf)" },
{ "pc",	"pad",		"pad_char",			"padding char (instead of null)" },
{ "DC",	"dch",		"parm_dch",			"delete #1 chars (NP*)" },
{ "DL",	"dl",		"parm_delete_line",		"delete #1 lines (NP*)" },
{ "DO",	"cud",		"parm_down_cursor",		"down #1 lines (NP*)" },
{ "IC",	"ich",		"parm_ich",			"insert #1 chars (NP*)" },
{ "SF",	"indn",		"parm_index",			"scroll forward #1 lines (NP)" },
{ "AL",	"il",		"parm_insert_line",		"insert #1 lines (NP*)" },
{ "LE",	"cub",		"parm_left_cursor",		"move #1 chars to the left (NP)" },
{ "RI",	"cuf",		"parm_right_cursor",		"move #1 chars to the right (NP*)" },
{ "SR",	"rin",		"parm_rindex",			"scroll back #1 lines (NP)" },
{ "UP",	"cuu",		"parm_up_cursor",		"up #1 lines (NP*)" },
{ "pk",	"pfkey",	"pkey_key",			"program function key #1 to type string #2" },
{ "pl",	"pfloc",	"pkey_local",			"program function key #1 to execute string #2" },
{ "px",	"pfx",		"pkey_xmit",			"program function key #1 to transmit string #2" },
{ "ps",	"mc0",		"print_screen",			"print contents of screen" },
{ "pf",	"mc4",		"prtr_off",			"turn off printer" },
{ "po",	"mc5",		"prtr_on",			"turn on printer" },
{ "rp",	"rep",		"repeat_char",			"repeat char #1 #2 times (NP*)" },
{ "r1",	"rs1",		"reset_1string",		"reset string" },
{ "r2",	"rs2",		"reset_2string",		"reset string" },
{ "r3",	"rs3",		"reset_3string",		"reset string" },
{ "rf",	"rf",		"reset_file",			"name of reset file" },
{ "rc",	"rc",		"restore_cursor",		"restore cursor to last position of save_cursor" },
{ "cv",	"vpa",		"row_address",			"vertical position #1 absolute (NP)" },
{ "sc",	"sc",		"save_cursor",			"save current cursor position (P)" },
{ "sf",	"ind",		"scroll_forward",		"scroll text up (P)" },
{ "sr",	"ri",		"scroll_reverse",		"scroll text down (P)" },
{ "sa",	"sgr",		"set_attributes",		"define video attributes #1-#9 (PG9) (NP)" },
{ "st",	"hts",		"set_tab",			"set a tab in every row, current columns" },
{ "wi",	"wind",		"set_window",			"current window is lines #1-#2 cols #3-#4 (N)" },
{ "ta",	"ht",		"tab",				"tab to next 8-space hardware tab stop" },
{ "ts",	"tsl",		"to_status_line",		"move to status line col #1 (N)" },
{ "uc",	"uc",		"underline_char",		"underline char and move past it" },
{ "hu",	"hu",		"up_half_line",			"half a line up" },
{ "iP",	"iprog",	"init_prog",			"path name of program for initialization" },
{ "K1",	"ka1",		"key_a1",			"upper left of keypad" },
{ "K3",	"ka3",		"key_a3",			"upper right of keypad" },
{ "K2",	"kb2",		"key_b2",			"center of keypad" },
{ "K4",	"kc1",		"key_c1",			"lower left of keypad" },
{ "K5",	"kc3",		"key_c3",			"lower right of keypad" },
{ "pO",	"mc5p",		"prtr_non",			"turn on printer for #1 bytes (N)" },
{ "i2",	"i2",		"termcap_init2",		"secondary initialization string" },
{ "rs",	"rs",		"termcap_reset",		"terminal reset string" },

	/*
	 * SVr1 capabilities stop here.  IBM's version of terminfo is the same as
	 * SVr4 up to this point, but has a different set afterwards.
	 */
{ "rP",	"rmp",		"char_padding",			"like insert_padding but when in insert mode" },
{ "ac",	"acsc",		"acs_chars",			"graphics charset pairs - def=vt100" },
{ "pn",	"pln",		"plab_norm",			"program label #1 to show string #2 (NP)" },
{ "kB",	"kcbt",		"key_btab",			"back-tab key" },
{ "SX",	"smxon",	"enter_xon_mode",		"turn on xon/xoff handshaking" },
{ "RX",	"rmxon",	"exit_xon_mode",		"turn off xon/xoff handshaking" },
{ "SA",	"smam",		"enter_am_mode",		"turn on automatic margins" },
{ "RA",	"rmam",		"exit_am_mode",			"turn off automatic margins" },
{ "XN",	"xonc",		"xon_character",		"XON character" },
{ "XF",	"xoffc",	"xoff_character",		"XOFF character" },
{ "eA",	"enacs",	"ena_acs",			"enable alternate char set" },
{ "LO",	"smln",		"label_on",			"turn on soft labels" },
{ "LF",	"rmln",		"label_off",			"turn off soft labels" },
{ "@1",	"kbeg",		"key_beg",			"begin key" },
{ "@2",	"kcan",		"key_cancel",			"cancel key" },
{ "@3",	"kclo",		"key_close",			"close key" },
{ "@4",	"kcmd",		"key_command",			"command key" },
{ "@5",	"kcpy",		"key_copy",			"copy key" },
{ "@6",	"kcrt",		"key_create",			"create key" },
{ "@7",	"kend",		"key_end",			"end key" },
{ "@8",	"kent",		"key_enter",			"enter/send key" },
{ "@9",	"kext",		"key_exit",			"exit key" },
{ "@0",	"kfnd",		"key_find",			"find key" },
{ "%1",	"khlp",		"key_help",			"help key" },
{ "%2",	"kmrk",		"key_mark",			"mark key" },
{ "%3",	"kmsg",		"key_message",			"message key" },
{ "%4",	"kmov",		"key_move",			"move key" },
{ "%5",	"knxt",		"key_next",			"next key" },
{ "%6",	"kopn",		"key_open",			"open key" },
{ "%7",	"kopt",		"key_options",			"options key" },
{ "%8",	"kprv",		"key_previous",			"previous key" },
{ "%9",	"kprt",		"key_print",			"print key" },
{ "%0",	"krdo",		"key_redo",			"redo key" },
{ "&1",	"kref",		"key_reference",		"reference key" },
{ "&2",	"krfr",		"key_refresh",			"refresh key" },
{ "&3",	"krpl",		"key_replace",			"replace key" },
{ "&4",	"krst",		"key_restart",			"restart key" },
{ "&5",	"kres",		"key_resume",			"resume key" },
{ "&6",	"ksav",		"key_save",			"save key" },
{ "&7",	"kspd",		"key_suspend",			"suspend key" },
{ "&8",	"kund",		"key_undo",			"undo key" },
{ "&9",	"kBEG",		"key_sbeg",			"shifted key" },
{ "&0",	"kCAN",		"key_scancel",			"shifted key" },
{ "*1",	"kCMD",		"key_scommand",			"shifted key" },
{ "*2",	"kCPY",		"key_scopy",			"shifted key" },
{ "*3",	"kCRT",		"key_screate",			"shifted key" },
{ "*4",	"kDC",		"key_sdc",			"shifted key" },
{ "*5",	"kDL",		"key_sdl",			"shifted key" },
{ "*6",	"kslt",		"key_select",			"select key" },
{ "*7",	"kEND",		"key_send",			"shifted key" },
{ "*8",	"kEOL",		"key_seol",			"shifted key" },
{ "*9",	"kEXT",		"key_sexit",			"shifted key" },
{ "*0",	"kFND",		"key_sfind",			"shifted key" },
{ "#1",	"kHLP",		"key_shelp",			"shifted key" },
{ "#2",	"kHOM",		"key_shome",			"shifted key" },
{ "#3",	"kIC",		"key_sic",			"shifted key" },
{ "#4",	"kLFT",		"key_sleft",			"shifted key" },
{ "%a",	"kMSG",		"key_smessage",			"shifted key" },
{ "%b",	"kMOV",		"key_smove",			"shifted key" },
{ "%c",	"kNXT",		"key_snext",			"shifted key" },
{ "%d",	"kOPT",		"key_soptions",			"shifted key" },
{ "%e",	"kPRV",		"key_sprevious",		"shifted key" },
{ "%f",	"kPRT",		"key_sprint",			"shifted key" },
{ "%g",	"kRDO",		"key_sredo",			"shifted key" },
{ "%h",	"kRPL",		"key_sreplace",			"shifted key" },
{ "%i",	"kRIT",		"key_sright",			"shifted key" },
{ "%j",	"kRES",		"key_srsume",			"shifted key" },
{ "!1",	"kSAV",		"key_ssave",			"shifted key" },
{ "!2",	"kSPD",		"key_ssuspend",			"shifted key" },
{ "!3",	"kUND",		"key_sundo",			"shifted key" },
{ "RF",	"rfi",		"req_for_input",		"send next input char (for ptys)" },
{ "F1",	"kf11",		"key_f11",			"F11 function key" },
{ "F2",	"kf12",		"key_f12",			"F12 function key" },
{ "F3",	"kf13",		"key_f13",			"F13 function key" },
{ "F4",	"kf14",		"key_f14",			"F14 function key" },
{ "F5",	"kf15",		"key_f15",			"F15 function key" },
{ "F6",	"kf16",		"key_f16",			"F16 function key" },
{ "F7",	"kf17",		"key_f17",			"F17 function key" },
{ "F8",	"kf18",		"key_f18",			"F18 function key" },
{ "F9",	"kf19",		"key_f19",			"F19 function key" },
{ "FA",	"kf20",		"key_f20",			"F20 function key" },
{ "FB",	"kf21",		"key_f21",			"F21 function key" },
{ "FC",	"kf22",		"key_f22",			"F22 function key" },
{ "FD",	"kf23",		"key_f23",			"F23 function key" },
{ "FE",	"kf24",		"key_f24",			"F24 function key" },
{ "FF",	"kf25",		"key_f25",			"F25 function key" },
{ "FG",	"kf26",		"key_f26",			"F26 function key" },
{ "FH",	"kf27",		"key_f27",			"F27 function key" },
{ "FI",	"kf28",		"key_f28",			"F28 function key" },
{ "FJ",	"kf29",		"key_f29",			"F29 function key" },
{ "FK",	"kf30",		"key_f30",			"F30 function key" },
{ "FL",	"kf31",		"key_f31",			"F31 function key" },
{ "FM",	"kf32",		"key_f32",			"F32 function key" },
{ "FN",	"kf33",		"key_f33",			"F33 function key" },
{ "FO",	"kf34",		"key_f34",			"F34 function key" },
{ "FP",	"kf35",		"key_f35",			"F35 function key" },
{ "FQ",	"kf36",		"key_f36",			"F36 function key" },
{ "FR",	"kf37",		"key_f37",			"F37 function key" },
{ "FS",	"kf38",		"key_f38",			"F38 function key" },
{ "FT",	"kf39",		"key_f39",			"F39 function key" },
{ "FU",	"kf40",		"key_f40",			"F40 function key" },
{ "FV",	"kf41",		"key_f41",			"F41 function key" },
{ "FW",	"kf42",		"key_f42",			"F42 function key" },
{ "FX",	"kf43",		"key_f43",			"F43 function key" },
{ "FY",	"kf44",		"key_f44",			"F44 function key" },
{ "FZ",	"kf45",		"key_f45",			"F45 function key" },
{ "Fa",	"kf46",		"key_f46",			"F46 function key" },
{ "Fb",	"kf47",		"key_f47",			"F47 function key" },
{ "Fc",	"kf48",		"key_f48",			"F48 function key" },
{ "Fd",	"kf49",		"key_f49",			"F49 function key" },
{ "Fe",	"kf50",		"key_f50",			"F50 function key" },
{ "Ff",	"kf51",		"key_f51",			"F51 function key" },
{ "Fg",	"kf52",		"key_f52",			"F52 function key" },
{ "Fh",	"kf53",		"key_f53",			"F53 function key" },
{ "Fi",	"kf54",		"key_f54",			"F54 function key" },
{ "Fj",	"kf55",		"key_f55",			"F55 function key" },
{ "Fk",	"kf56",		"key_f56",			"F56 function key" },
{ "Fl",	"kf57",		"key_f57",			"F57 function key" },
{ "Fm",	"kf58",		"key_f58",			"F58 function key" },
{ "Fn",	"kf59",		"key_f59",			"F59 function key" },
{ "Fo",	"kf60",		"key_f60",			"F60 function key" },
{ "Fp",	"kf61",		"key_f61",			"F61 function key" },
{ "Fq",	"kf62",		"key_f62",			"F62 function key" },
{ "Fr",	"kf63",		"key_f63",			"F63 function key" },
{ "cb",	"el1",		"clr_bol",			"Clear to beginning of line" },
{ "MC",	"mgc",		"clear_margins",		"clear right and left soft margins" },
{ "ML",	"smgl",		"set_left_margin",		"set left soft margin" },
{ "MR",	"smgr",		"set_right_margin",		"set right soft margin" },
{ "Lf",	"fln",		"label_format",			"label format" },
{ "SC",	"sclk",		"set_clock",			"set clock, #1 hrs #2 mins #3 secs" },
{ "DK",	"dclk",		"display_clock",		"display clock at (#1,#2)" },
{ "RC",	"rmclk",	"remove_clock",			"remove clock" },
{ "CW",	"cwin",		"create_window",		"define a window #1 from #2, #3 to #4, #5" },
{ "WG",	"wingo",	"goto_window",			"go to window #1" },
{ "HU",	"hup",		"hangup",			"hang-up phone" },
{ "DI",	"dial",		"dial_phone",			"dial number #1" },
{ "QD",	"qdial",	"quick_dial",			"dial number #1 without checking" },
{ "TO",	"tone",		"tone",				"select touch tone dialing" },
{ "PU",	"pulse",	"pulse",			"select pulse dialing" },
{ "fh",	"hook",		"flash_hook",			"flash switch hook" },
{ "PA",	"pause",	"fixed_pause",			"pause for 2-3 seconds" },
{ "WA",	"wait",		"wait_tone",			"wait for dial-tone" },
{ "u0",	"u0",		"user0",			"User string #0" },
{ "u1",	"u1",		"user1",			"User string #1" },
{ "u2",	"u2",		"user2",			"User string #2" },
{ "u3",	"u3",		"user3",			"User string #3" },
{ "u4",	"u4",		"user4",			"User string #4" },
{ "u5",	"u5",		"user5",			"User string #5" },
{ "u6",	"u6",		"user6",			"User string #6" },
{ "u7",	"u7",		"user7",			"User string #7" },
{ "u8",	"u8",		"user8",			"User string #8" },
{ "u9",	"u9",		"user9",			"User string #9" },

	/*
	 * SVr4 added these capabilities to support color
	 */
{ "op",	"op",		"orig_pair",			"Set default pair to its original value" },
{ "oc",	"oc",		"orig_colors",			"Set all color pairs to the original ones" },
{ "Ic",	"initc",	"initialize_color",		"initialize color #1 to (#2,#3,#4)" },
{ "Ip",	"initp",	"initialize_pair",		"Initialize color pair #1 to fg=(#2,#3,#4), bg=(#5,#6,#7)" },
{ "sp",	"scp",		"set_color_pair",		"Set current color pair to #1" },
{ "Sf",	"setf",		"set_foreground",		"Set foreground color #1" },
{ "Sb",	"setb",		"set_background",		"Set background color #1" },

	/*
	 * SVr4 added these capabilities to support printers
	 */
{ "ZA",	"cpi",		"change_char_pitch",		"Change number of characters per inch" },
{ "ZB",	"lpi",		"change_line_pitch",		"Change number of lines per inch" },
{ "ZC",	"chr",		"change_res_horz",		"Change horizontal resolution" },
{ "ZD",	"cvr",		"change_res_vert",		"Change vertical resolution" },
{ "ZE",	"defc",		"define_char",			"Define a character" },
{ "ZF",	"swidm",	"enter_doublewide_mode",	"Enter double-wide mode" },
{ "ZG",	"sdrfq",	"enter_draft_quality",		"Enter draft-quality mode" },
{ "ZH",	"sitm",		"enter_italics_mode",		"Enter italic mode" },
{ "ZI",	"slm",		"enter_leftward_mode",		"Start leftward carriage motion" },
{ "ZJ",	"smicm",	"enter_micro_mode",		"Start micro-motion mode" },
{ "ZK",	"snlq",		"enter_near_letter_quality",	"Enter NLQ mode" },
{ "ZL",	"snrmq",	"enter_normal_quality",		"Enter normal-quality mode" },
{ "ZM",	"sshm",		"enter_shadow_mode",		"Enter shadow-print mode" },
{ "ZN",	"ssubm",	"enter_subscript_mode",		"Enter subscript mode" },
{ "ZO",	"ssupm",	"enter_superscript_mode",	"Enter superscript mode" },
{ "ZP",	"sum",		"enter_upward_mode",		"Start upward carriage motion" },
{ "ZQ",	"rwidm",	"exit_doublewide_mode",		"End double-wide mode" },
{ "ZR",	"ritm",		"exit_italics_mode",		"End italic mode" },
{ "ZS",	"rlm",		"exit_leftward_mode",		"End left-motion mode" },
{ "ZT",	"rmicm",	"exit_micro_mode",		"End micro-motion mode" },
{ "ZU",	"rshm",		"exit_shadow_mode",		"End shadow-print mode" },
{ "ZV",	"rsubm",	"exit_subscript_mode",		"End subscript mode" },
{ "ZW",	"rsupm",	"exit_superscript_mode",	"End superscript mode" },
{ "ZX",	"rum",		"exit_upward_mode",		"End reverse character motion" },
{ "ZY",	"mhpa",		"micro_column_address",		"Like column_address in micro mode" },
{ "ZZ",	"mcud1",	"micro_down",			"Like cursor_down in micro mode" },
{ "Za",	"mcub1",	"micro_left",			"Like cursor_left in micro mode" },
{ "Zb",	"mcuf1",	"micro_right",			"Like cursor_right in micro mode" },
{ "Zc",	"mvpa",		"micro_row_address",		"Like row_address in micro mode" },
{ "Zd",	"mcuu1",	"micro_up",			"Like cursor_up in micro mode" },
{ "Ze",	"porder",	"order_of_pins",		"Match software bits to print-head pins" },
{ "Zf",	"mcud",		"parm_down_micro",		"Like parm_down_cursor in micro mode" },
{ "Zg",	"mcub",		"parm_left_micro",		"Like parm_left_cursor in micro mode" },
{ "Zh",	"mcuf",		"parm_right_micro",		"Like parm_right_cursor in micro mode" },
{ "Zi",	"mcuu",		"parm_up_micro",		"Like parm_up_cursor in micro mode" },
{ "Zj",	"scs",		"select_char_set",		"Select character set" },
{ "Zk",	"smgb",		"set_bottom_margin",		"Set bottom margin at current line" },
{ "Zl",	"smgbp",	"set_bottom_margin_parm",	"Set bottom margin at line #1 or #2 lines from bottom" },
{ "Zm",	"smglp",	"set_left_margin_parm",		"Set left (right) margin at column #1 (#2)" },
{ "Zn",	"smgrp",	"set_right_margin_parm",	"Set right margin at column #1" },
{ "Zo",	"smgt",		"set_top_margin",		"Set top margin at current line" },
{ "Zp",	"smgtp",	"set_top_margin_parm",		"Set top (bottom) margin at row #1 (#2)" },
{ "Zq",	"sbim",		"start_bit_image",		"Start printing bit image graphics" },
{ "Zr",	"scsd",		"start_char_set_def",		"Start character set definition" },
{ "Zs",	"rbim",		"stop_bit_image",		"Stop printing bit image graphics" },
{ "Zt",	"rcsd",		"stop_char_set_def",		"End definition of character aet" },
{ "Zu",	"subcs",	"subscript_characters",		"List of subscriptable characters" },
{ "Zv",	"supcs",	"superscript_characters",	"List of superscriptable characters" },
{ "Zw",	"docr",		"these_cause_cr",		"Printing any of these chars causes CR" },
{ "Zx",	"zerom",	"zero_motion",			"No motion for subsequent character" },

	/*
	 * The following string capabilities are present in the SVr4.0 term
	 * structure, but are not documented in the man page.
	 */
{ "Zy",	"csnm",		"char_set_names",		"List of character set names" },
{ "Km",	"kmous",	"key_mouse",			"Mouse event has occurred" },
{ "Mi",	"minfo",	"mouse_info",			"Mouse status information" },
{ "RQ",	"reqmp",	"req_mouse_pos",		"Request mouse position" },
{ "Gm",	"getm",		"get_mouse",			"Curses should get button events" },
{ "AF",	"setaf",	"set_a_foreground",		"Set ANSI foreground color" },
{ "AB",	"setab",	"set_a_background",		"Set ANSI background color" },
{ "xl",	"pfxl",		"pkey_plab",			"Program function key #1 to type string #2 and show string #3" },
{ "dv",	"devt",		"device_type",			"Indicate language/codeset support" },
{ "ci",	"csin",		"code_set_init",		"Init sequence for multiple codesets" },
{ "s0",	"s0ds",		"set0_des_seq",			"Shift to code set 0 (EUC set 0, ASCII)" },
{ "s1",	"s1ds",		"set1_des_seq",			"Shift to code set 1" },
{ "s2",	"s2ds",		"set2_des_seq",			"Shift to code set 2" },
{ "s3",	"s3ds",		"set3_des_seq",			"Shift to code set 3" },
/*
 *  See above "ML", "smgl" -> "set_left_margin"
 */
{ "ML",	"smglr",	"set_lr_margin",		"Set both left and right margins to #1, #2" },
{ "MT",	"smgtb",	"set_tb_margin",		"Sets both top and bottom margins to #1, #2" },
{ "Xy",	"birep",	"bit_image_repeat",		"Repeat bit image cell #1 #2 times" },
{ "Zz",	"binel",	"bit_image_newline",		"Move to next row of the bit image" },
{ "Yv",	"bicr",		"bit_image_carriage_return",	"Move to beginning of same row" },
{ "Yw",	"colornm",	"color_names",			"Give name for color #1" },
{ "Yx",	"defbi",	"define_bit_image_region",	"Define rectangular bit image region" },
{ "Yy",	"endbi",	"end_bit_image_region",		"End a bit-image region" },
{ "Yz",	"setcolor",	"set_color_band",		"Change to ribbon color #1" },
{ "YZ",	"slines",	"set_page_length",		"Set page length to #1 lines" },

	/*
	 * SVr4 added these capabilities for direct PC-clone support
	 */
{ "S1",	"dispc",	"display_pc_char",		"Display PC character" },
{ "S2",	"smpch",	"enter_pc_charset_mode",	"Enter PC character display mode" },
{ "S3",	"rmpch",	"exit_pc_charset_mode",		"Exit PC character display mode" },
{ "S4",	"smsc",		"enter_scancode_mode",		"Enter PC scancode mode" },
{ "S5",	"rmsc",		"exit_scancode_mode",		"Exit PC scancode mode" },
{ "S6",	"pctrm",	"pc_term_options",		"PC terminal options" },
{ "S7",	"scesc",	"scancode_escape",		"Escape for scancode emulation" },
{ "S8",	"scesa",	"alt_scancode_esc",		"Alternate escape for scancode emulation" },

	/*
	 * The XSI Curses standard added these.
	 */
{ "Xh",	"Xh",		"enter_horizontal_hl_mode",	"Enter horizontal highlight mode" },
{ "Xl",	"Xl",		"enter_left_hl_mode",		"Enter left highlight mode" },
{ "Xo",	"Xo",		"enter_low_hl_mode",		"Enter low highlight mode" },
{ "Xr",	"Xr",		"enter_right_hl_mode",		"Enter right highlight mode" },
{ "Xt",	"Xt",		"enter_top_hl_mode",		"Enter top highlight mode" },
{ "Xv",	"Xv",		"enter_vertical_hl_mode",	"Enter vertical highlight mode" },

#ifdef	SVSV_adds
	/*
	 * Defined on SVr4 but not used
	 */
{ "??",	"sgr1"		"set_a_attributes",		"Define second set of attributes #1-#6" },
{ "YI",	"slength",	"set_pglen_inch",		"Set page length to #1/100 of an inch" },
#endif

	/*
	 * Obsolete termcap capabilities.
	 * (see current BSD man pages)
	 * New software should not rely on them at all.
	 */
{ "--",	"--",		"OBSOLETE",			"--" },
{ "--",	"--",		"BOOL",				"--" },
{ "NL",	"NL",		"linefeed_is_newline",		"move down with ^J" },
{ "EP",	"EP",		"even_parity",			"terminal requires even parity" },
{ "OP",	"OP",		"odd_parity",			"terminal requires odd parity" },
{ "HD",	"HD",		"half_duplex",			"terminal is half-duplex" },
{ "LC",	"LC",		"lower_case_only",		"terminal has only lower case" },
{ "UC",	"UC",		"upper_case_only",		"terminal has only upper case" },
{ "pt",	"pt",		"has_hardware_tabs",		"has 8-char tabs invoked with ^I" },
{ "xr",	"xr",		"return_does_clr_eol",		"return clears the line" },
{ "xx",	"xx",		"tek_4025_insert_line",		"Tektronix 4025 insert-line glitch" },
{ "bs",	"bs",		"backspaces_with_bs",		"uses ^H to move left" },
{ "ns",	"ns",		"crt_no_scrolling",		"crt cannot scroll" },
{ "nc",	"nc",		"no_correctly_working_cr",	"no way to go to start of line" },

{ "--",	"--",		"OBSOLETE",			"--" },
{ "--",	"--",		"INT",				"--" },
{ "dB",	"dB",		"backspace_delay",		"padding required for ^H" },
{ "dF",	"dF",		"form_feed_delay",		"padding required for ^L" },
{ "dT",	"dT",		"horizontal_tab_delay",		"padding required for ^I" },
{ "dV",	"dV",		"vertical_tab_delay",		"padding required for ^V" },
{ "kn",	"kn",		"number_of_function_keys",	"count of function keys" },
{ "dC",	"dC",		"carriage_return_delay",	"pad needed for CR" },
{ "dN",	"dN",		"new_line_delay",		"pad needed for LF" },

{ "--",	"--",		"OBSOLETE",			"--" },
{ "--",	"--",		"STRING",			"--" },
{ "ko",	"ko",		"other_non_function_keys",	"list of self-mapped keycaps" },
/*
 * See above "ma", "ma" -> max_attributes
 */
{ "ma",	"ma",		"arrow_key_map",		"map arrow keys rogue(1) motion keys" },
{ "ml",	"ml",		"memory_lock_above",		"lock visible screen memory above the current line" },
{ "mu",	"mu",		"memory_unlock",		"unlock visible screen memory above the current line" },
{ "nl",	"nl",		"linefeed_if_not_lf",		"use to move down" },
{ "bc",	"bc",		"backspace_if_not_bs",		"move left, if not ^H" },

{ "--",	"--",		"COMMENT",			"--" },
{ "..",	"..",		"unknown",			"unknown entries" },
{ "..",	"..",		"commented_out",		"commented out entries" },

	/*
	 * This must be last...
	 */
{ "--",	"--",		"CURIOUS",			"--" },
{ "--",	"--",		"STRING",			"--" },
{ "--",	"--",		"TC",				"--" },
{ "tc",	"use",		"similar_terminal",		"similar terminal" },
