/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;

public class QtBluetoothBroadcastReceiver
extends BroadcastReceiver {
    long qtObject = 0L;
    static Context qtContext = null;
    private static final int TURN_BT_ON = 3330;
    private static final int TURN_BT_DISCOVERABLE = 3331;
    private static final String TAG = "QtBluetoothBroadcastReceiver";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Context context2 = qtContext;
        synchronized (context2) {
            if (this.qtObject == 0L) {
                return;
            }
            this.jniOnReceive(this.qtObject, context, intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReceiver() {
        Context context = qtContext;
        synchronized (context) {
            this.qtObject = 0L;
            qtContext.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public native void jniOnReceive(long var1, Context var3, Intent var4);

    public static void setContext(Context context) {
        qtContext = context;
    }

    public static void setDiscoverable() {
        if (!(qtContext instanceof Activity)) {
            Log.w((String)TAG, (String)"Discovery mode cannot be enabled from a service.");
            return;
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
        intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 300);
        try {
            ((Activity)qtContext).startActivityForResult(intent, 3330);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setConnectable() {
        if (!(qtContext instanceof Activity)) {
            Log.w((String)TAG, (String)"Connectable mode cannot be enabled from a service.");
            return;
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
        try {
            ((Activity)qtContext).startActivityForResult(intent, 3331);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean setPairingMode(String string, boolean bl) {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        try {
            BluetoothDevice bluetoothDevice = bluetoothAdapter.getRemoteDevice(string);
            String string2 = "createBond";
            if (!bl) {
                string2 = "removeBond";
            }
            Method method = bluetoothDevice.getClass().getMethod(string2, null);
            method.invoke((Object)bluetoothDevice, (Object[])null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static String[] getConnectedDevices() {
        try {
            Field field = Context.class.getField("BLUETOOTH_SERVICE");
            String string = (String)field.get(qtContext);
            Class<?> clazz = Class.forName("android.bluetooth.BluetoothProfile");
            field = clazz.getField("GATT");
            int n = field.getInt(null);
            field = clazz.getField("GATT_SERVER");
            int n2 = field.getInt(null);
            Object object = qtContext.getSystemService(string);
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = object.getClass().getMethod("getConnectedDevices", classArray);
            List list = (List)method.invoke(object, n);
            List list2 = (List)method.invoke(object, n2);
            HashSet<String> hashSet = new HashSet<String>();
            for (Object e : list) {
                hashSet.add(e.toString());
            }
            for (Object e : list2) {
                hashSet.add(e.toString());
            }
            return hashSet.toArray(new String[hashSet.size()]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }
}

