/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.security.md.SHA;
import iaik.security.provider.IAIK;
import iaik.security.rsa.RSA;
import iaik.utils.CryptoUtils;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class SSLRSASignature
extends Signature {
    private RSA b;
    private MessageDigest a;
    private MessageDigest c = IAIK.getMd5();
    private static final String d = "PKCS1Padding";
    private static final String e = "ECB";

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[36];
        System.arraycopy(this.c.digest(), 0, byArray2, 0, 16);
        System.arraycopy(this.a.digest(), 0, byArray2, 16, 20);
        try {
            byte[] byArray3 = this.b.doFinal(byArray2, 0, byArray2.length);
            return CryptoUtils.equalsBlock(byArray, byArray3);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.c.update(byArray, n2, n3);
        this.a.update(byArray, n2, n3);
    }

    protected void engineUpdate(byte by) {
        this.c.update(by);
        this.a.update(by);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[36];
        System.arraycopy(this.c.digest(), 0, byArray, 0, 16);
        System.arraycopy(this.a.digest(), 0, byArray, 16, 20);
        try {
            return this.b.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.b.init(2, publicKey, null);
        this.c.reset();
        this.a.reset();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.b.init(1, privateKey, null);
        this.c.reset();
        this.a.reset();
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    public SSLRSASignature() throws NoSuchAlgorithmException {
        super("SSL/RSA Signature");
        this.a = new SHA();
        try {
            this.b = RSA.b();
            this.b.setMode(e);
            this.b.setPadding(d);
            return;
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException(exception.toString());
        }
    }
}

