/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptedContentInfo
extends EncryptedContentInfoStream {
    int a = 0;
    boolean b = false;
    byte[] c;

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.d == null) {
            throw new PKCSException("contentEncryptionAlgorithm field not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(this.f > 0);
        sEQUENCE.addComponent(((EncryptedContentInfoStream)this).c);
        sEQUENCE.addComponent(this.d.toASN1Object());
        if (this.c != null && this.c.length > 0) {
            OCTET_STRING oCTET_STRING = null;
            oCTET_STRING = this.f > 0 ? new OCTET_STRING(new ByteArrayInputStream(this.c), this.f) : new OCTET_STRING(this.c);
            CON_SPEC cON_SPEC = new CON_SPEC(0, oCTET_STRING, true);
            sEQUENCE.addComponent(cON_SPEC);
        }
        return sEQUENCE;
    }

    public void setupCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        super.setupCipher(key, algorithmParameterSpec);
        if (this.c != null) {
            byte[] byArray = this.c;
            try {
                this.c = this.e.doFinal(byArray);
                if (this.a == 1) {
                    OCTET_STRING oCTET_STRING = (OCTET_STRING)DerCoder.decode(this.c);
                    this.c = (byte[])oCTET_STRING.getValue();
                    return;
                }
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidAlgorithmParameterException("Padding error: " + badPaddingException.toString());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new InvalidAlgorithmParameterException("Illegal blocksize: " + illegalBlockSizeException.toString());
            }
            catch (CodingException codingException) {
                throw new InvalidAlgorithmParameterException("Error decoding PKCS#7v1.6 decrypted content: " + codingException.getMessage());
            }
        }
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        super.setupCipher(algorithmID, key, algorithmParameterSpec);
        if (this.e != null && this.c != null) {
            try {
                byte[] byArray = this.a == 1 ? this.e.doFinal(DerCoder.encode(new OCTET_STRING(this.c))) : this.e.doFinal(this.c);
                this.c = byArray;
                return;
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidAlgorithmParameterException("Padding error at content encryption: " + badPaddingException.getMessage());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new InvalidAlgorithmParameterException("Illegal block size for content encryption: " + illegalBlockSizeException.getMessage());
            }
        }
    }

    public void setVersion(int n2) {
        if (n2 == 1) {
            this.a = 1;
            return;
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
    }

    public boolean hasContent() {
        return this.c != null;
    }

    public InputStream getInputStream() {
        byte[] byArray = this.getContent();
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        return this.c;
    }

    protected void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        this.b = true;
        super.decode(inputStream);
        if (((EncryptedContentInfoStream)this).b != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Util.copyStream(((EncryptedContentInfoStream)this).b, byteArrayOutputStream, null);
            this.c = byteArrayOutputStream.toByteArray();
        }
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        this.b = true;
        if (aSN1Object == null) {
            throw new PKCSParsingException("Cannot decode a null object!");
        }
        try {
            byte[] byArray = DerCoder.encode(aSN1Object);
            if (byArray == null) {
                throw new PKCSParsingException("Error parsing ASN.1 object!");
            }
            this.decode(new ByteArrayInputStream(byArray));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public EncryptedContentInfo(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public EncryptedContentInfo(ObjectID objectID, byte[] byArray) {
        this();
        this.c = byArray;
        ((EncryptedContentInfoStream)this).c = objectID;
        ((EncryptedContentInfoStream)this).a = 1;
        this.b = false;
    }

    public EncryptedContentInfo(ObjectID objectID, AlgorithmID algorithmID) {
        this();
        ((EncryptedContentInfoStream)this).c = objectID;
        this.d = algorithmID;
        this.b = false;
    }

    public EncryptedContentInfo(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
        this.b = true;
    }

    protected EncryptedContentInfo() {
        this.f = -1;
    }
}

