/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameters;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAPssParameters
extends PKCS1AlgorithmParameters {
    private RSAPssParameterSpec a;
    private static boolean b;

    public ASN1Object toASN1Object() {
        if (this.a == null) {
            throw new NullPointerException("Cannot encode null params!");
        }
        AlgorithmID algorithmID = this.a.getHashAlgorithm();
        AlgorithmID algorithmID2 = this.a.getMaskGenAlgorithm();
        int n2 = this.a.getSaltLength();
        int n3 = this.a.getTrailerField();
        Boolean bl = this.a.getEncodeDefaultValues();
        boolean bl2 = bl != null ? bl : b;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (algorithmID != null && (bl2 || !algorithmID.equals(RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM))) {
            sEQUENCE.addComponent(new CON_SPEC(0, algorithmID.toASN1Object()));
        }
        if (algorithmID2 != null) {
            ASN1Object aSN1Object = null;
            ASN1Object aSN1Object2 = algorithmID2.getParameter();
            if (aSN1Object2 != null && aSN1Object2.isA(ASN.SEQUENCE)) {
                try {
                    aSN1Object = aSN1Object2.getComponentAt(0);
                }
                catch (CodingException codingException) {}
            }
            if (bl2 || !algorithmID2.equals(RSAPssParameterSpec.DEFAULT_MASK_GEN_ALGORITHM) || !RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM.getAlgorithm().equals(aSN1Object)) {
                sEQUENCE.addComponent(new CON_SPEC(1, algorithmID2.toASN1Object()));
            }
        }
        if (n2 != -1 && (bl2 || n2 != 20)) {
            sEQUENCE.addComponent(new CON_SPEC(2, new INTEGER(n2)));
        }
        if (n3 != -1 && (bl2 || n3 != RSAPssParameterSpec.DEFAULT_TRAILER_FIELD)) {
            sEQUENCE.addComponent(new CON_SPEC(3, new INTEGER(n3)));
        }
        return sEQUENCE;
    }

    public static void setEncodeDefaultValues(boolean bl) {
        b = bl;
    }

    public static boolean getEncodeDefaultValues() {
        return b;
    }

    protected String engineToString() {
        if (this.a == null) {
            return "";
        }
        return this.a.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.decode(DerCoder.decode(byArray));
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Parsing error: " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a = null;
        if (algorithmParameterSpec instanceof RSAPssParameterSpec) {
            this.a = (RSAPssParameterSpec)((RSAPssParameterSpec)algorithmParameterSpec).clone();
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be a RSAPssParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!this.a.getClass().isAssignableFrom(clazz)) {
            try {
                Class<?> clazz2 = Class.forName("iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec");
                if (!clazz.isAssignableFrom(clazz2)) {
                    throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
            }
        }
        return (RSAPssParameterSpec)this.a.clone();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.toASN1Object());
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = null;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid PSS parameter encoding. Expected ASN.1 SEQUENCE!");
        }
        AlgorithmID algorithmID = null;
        AlgorithmID algorithmID2 = null;
        int n2 = 20;
        int n3 = RSAPssParameterSpec.DEFAULT_TRAILER_FIELD;
        int n4 = 0;
        while (n4 < aSN1Object.countComponents()) {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n4);
            int n5 = cON_SPEC.getAsnType().getTag();
            switch (n5) {
                case 0: {
                    algorithmID = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 1: {
                    algorithmID2 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 2: {
                    n2 = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                    break;
                }
                case 3: {
                    n3 = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                    break;
                }
                default: {
                    throw new CodingException("Invalid tagged (" + n5 + ") in PSS parameter component number " + n4 + ".");
                }
            }
            ++n4;
        }
        if (algorithmID == null) {
            algorithmID = RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM;
        }
        if (algorithmID2 == null) {
            algorithmID2 = RSAPssParameterSpec.DEFAULT_MASK_GEN_ALGORITHM;
        }
        this.a = new RSAPssParameterSpec(algorithmID, algorithmID2, n2);
        this.a.setTrailerField(n3);
    }
}

