/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2006;

import finanze.IDTE.generale2006.BaseTelem;
import finanze.IDTE.generale2006.Diagnostici;
import finanze.IDTE.generale2006.Dichiarazione;
import finanze.IDTE.generale2006.Modello;
import finanze.IDTE.generale2006.Util;
import finanze.IDTE.resources.RecordParser;

public abstract class LiquidatoreOld
extends Modello {
    protected String flagsTelem = "";
    protected boolean banchePoste = false;
    protected int tipoFornitore = 0;
    protected static final int CODGRAV = 16;
    protected static int CODWARNING = 4;
    protected int codGravDatiIncoerenti;
    protected int codGravConferma;
    protected String codFiscDichiarante = "";
    public static final int CTR_B_INDEX = 0;
    public static final int CTR_RECVAR_INDEX = 1;
    public static final int CTR_F_INDEX = 2;
    public static final int CTR_G_INDEX = 3;
    public static final int CTR_H_INDEX = 4;
    public static final int CTR_C_INDEX = 1;
    public static final int CTR_D_INDEX = 2;
    public static final int CTR_E_INDEX = 3;
    public static final int CTR_I_INDEX = 7;
    public static final int CTR_L_INDEX = 10;
    public static final int CTR_Q_INDEX = 15;
    public static final int CTR_R_INDEX = 16;
    public static final int CTR_S_INDEX = 17;
    public static final int CTR_T_INDEX = 18;
    public static final int CTR_U_INDEX = 19;
    public static final int CTR_X_INDEX = 22;

    protected LiquidatoreOld() {
        this(null, new Dichiarazione());
    }

    protected LiquidatoreOld(RecordParser recordB, Dichiarazione dichiarazione) {
        this.recordB = recordB;
        this.dich = dichiarazione;
        String modClassName = this.getClass().getName();
        this.TIPO_MODELLO = modClassName.substring(modClassName.length() - 5, modClassName.length() - 2);
        this.ANNO = modClassName.substring(modClassName.length() - 2);
    }

    public static String[] controlloProtocolloBanchePoste(String protocollo, String pacco, double sequenza, String modello, int fornitore, int altricasi2, int Cab, int annoCorrente) {
        String[] rc = new String[]{"0", "0", "0", "0", "0"};
        String prot = "";
        String abi = "";
        String cab = "";
        String tipo = "";
        String data8 = "";
        String progr = "";
        String dataPoste = "";
        String agenzia = "";
        if (protocollo.trim().length() == 25) {
            abi = protocollo.substring(0, 5);
            cab = protocollo.substring(5, 10);
            tipo = protocollo.substring(10, 13);
            data8 = protocollo.substring(13, 21);
            progr = protocollo.substring(21, 25);
            if (fornitore != 8) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(abi) || abi.equals("00000")) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(cab) || cab.equals("00000")) {
                rc[0] = "1070";
            }
            if (!(tipo.equals("UNI") || tipo.equals("SCE") || tipo.equals("SCS") || tipo.equals("IVA") || tipo.equals("730") || tipo.equals("U50") || tipo.equals("U60") || tipo.equals("U61") || tipo.equals("770") || tipo.equals("77S"))) {
                rc[0] = "1070";
            }
            if (!tipo.equals(modello.substring(0, 3))) {
                rc[1] = "1071";
            }
            if (!tipo.equals(modello.substring(0, 3)) && altricasi2 != 1) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(data8) || !Util.controlloData(data8) || data8.equals("00000000")) {
                rc[0] = "1070";
            } else if (Util.valoreDouble(data8.substring(4, 8)) != (double)annoCorrente && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente - 1) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 1) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 2) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 3) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 4)) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(progr)) {
                rc[0] = "1070";
            }
        } else if (protocollo.trim().length() == 18) {
            agenzia = protocollo.substring(0, 5);
            progr = protocollo.substring(5, 10);
            dataPoste = protocollo.substring(10, 18);
            if (fornitore != 7) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(agenzia) || agenzia.equals("00000")) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(progr)) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(dataPoste) || !Util.controlloData(dataPoste) || dataPoste.equals("00000000")) {
                rc[0] = "1070";
            } else if (Util.valoreDouble(dataPoste.substring(4, 8)) != (double)annoCorrente && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente - 1) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 1) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 2) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 3) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 4)) {
                rc[0] = "1070";
            }
        } else {
            rc[0] = "1070";
        }
        if ((pacco = pacco.replace(' ', '0')).equals("0000000") || pacco.length() != 7) {
            rc[2] = "1072";
        } else if (fornitore == 7 && (Util.valoreDouble(pacco.substring(0, 2)) == 0.0 || Util.valoreDouble(pacco.substring(0, 2)) > 12.0)) {
            rc[2] = "1072";
        }
        if (sequenza == 0.0 || sequenza > 100.0) {
            rc[3] = "1073";
        }
        if (fornitore == 8 && Cab == 0) {
            rc[4] = "1095";
        }
        return rc;
    }

    public static boolean controlloProtocolloTelematico(String protocollo, String progr_dich, String annoDich) {
        boolean protOK = true;
        String data_invio = "";
        String ora_invio = "";
        String min_invio = "";
        String sec_invio = "";
        String num_invio = "";
        boolean protAss = false;
        if (protocollo.trim().length() == 17 && progr_dich.trim().length() == 6 && BaseTelem.currentSystem == 0 && (protocollo.equals("00000000000000000") || progr_dich.equals("000000"))) {
            return false;
        }
        if (protocollo.trim().length() == 17) {
            if (protocollo.equals("00000000000000000")) {
                protAss = true;
            } else {
                data_invio = String.valueOf(protocollo.substring(4, 6)) + protocollo.substring(2, 4) + "20" + protocollo.substring(0, 2);
                ora_invio = protocollo.substring(6, 8);
                min_invio = protocollo.substring(8, 10);
                sec_invio = protocollo.substring(10, 12);
                num_invio = protocollo.substring(12, 17);
                if (!Util.isNumericoAssoluto(data_invio) || data_invio.equals("00000000") || data_invio.equals("0000" + annoDich) || !Util.controlloData(data_invio)) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(ora_invio) || Util.valoreDouble(ora_invio) > 47.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(min_invio) || Util.valoreDouble(min_invio) > 59.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(sec_invio) || Util.valoreDouble(sec_invio) > 59.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(num_invio) || Util.valoreDouble(num_invio) == 0.0) {
                    protOK = false;
                }
            }
        } else if (protocollo.trim().length() == 0) {
            protAss = true;
        } else {
            protOK = false;
        }
        if (progr_dich.trim().length() == 6) {
            if (!Util.isNumericoAssoluto(progr_dich) || progr_dich.equals("000000") && !protAss) {
                protOK = false;
            }
        } else if (progr_dich.trim().length() == 0) {
            if (!protAss) {
                protOK = false;
            }
        } else {
            protOK = false;
        }
        return protOK;
    }

    public boolean getBanchePoste() {
        return this.banchePoste;
    }

    public String getCodFiscDichiarante() {
        return this.codFiscDichiarante;
    }

    public int getCodGravConferma() {
        return this.codGravConferma;
    }

    public int getCodGravDatiIncoerenti() {
        return this.codGravDatiIncoerenti;
    }

    public int getTipoFornitore() {
        return this.tipoFornitore;
    }

    public abstract String getVersione();

    private int liquidaQuadriCompilati() {
        int rc = 0;
        String campo = "";
        this.codFiscDichiarante = this.BS(2).trim();
        Dichiarazione dich770 = null;
        if (this.TIPO_MODELLO.equals("770")) {
            String[] quadri = new String[]{"SF", "SG", "SH", "SI", "SK", "SL", "SM", "SO", "SP", "SQ", "SR", "ST", "SX"};
            campo = "";
            if (this.TIPO_MODELLO.equals("770")) {
                dich770 = this.getDichiarazione();
            }
            if (this.AI(7) == 0 && this.AI(8) == 0 || this.AI(7) == 1) {
                int ind = 187;
                while (ind <= 199) {
                    campo = "XXX" + Util.formNum(2, ind - 100);
                    if (this.BI(ind) != 1 && dich770.esisteQuadro(quadri[ind - 187])) {
                        rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1322", campo, (double)this.BI(ind), "1");
                    }
                    if (this.BI(ind) == 1 && !dich770.esisteQuadro(quadri[ind - 187])) {
                        rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1321", campo, (double)this.BI(ind), "");
                    }
                    ++ind;
                }
            }
        }
        return rc;
    }

    public int liquidaTRecA() {
        String cfRecA;
        int rc = 0;
        int CODGRAV24 = 24;
        String string = cfRecA = BaseTelem.currentSystem == 2 ? this.AS(5) : "AAAAAAAAAAAAAAAA";
        if (this.AI(7) > this.AI(8) || this.AI(7) == 0 && this.AI(8) > 0 || this.AI(7) == 1 && this.AI(8) == 1) {
            rc = Diagnostici.DIA(rc, 24, cfRecA, "1047", "XXA", "", "");
        }
        if (this.AS(3).equals("INP05") && this.AS(9).charAt(0) == '1') {
            rc = Diagnostici.DIA(rc, 4, "0000000000000000", "1042", "        ", "", "");
        }
        return rc;
    }

    public int liquidaTRecB() {
        int rc = 0;
        this.codGravDatiIncoerenti = this.banchePoste && this.BI(252) == 1 ? 4 : 16;
        this.codGravConferma = this.flagConferma ? 8 : 14;
        this.codFiscDichiarante = this.BS(2).trim();
        rc = Util.aggRc(rc, this.liquidaTRecBProtocollo());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && (this.AI(4) == 7 || this.AI(4) == 8)) {
            return rc;
        }
        if (this.TIPO_MODELLO.equals("77S")) {
            if (this.BL(232) != 0L && this.BL(233) != 0L && !LiquidatoreOld.controlloProtocolloTelematico(this.BS(232), this.BS(233), "2006")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1068", "XXY32", "", "");
            }
            if (this.BL(232) != 0L && this.BL(233) == 0L) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXY33", "", "");
            }
            if (this.BL(232) == 0L && this.BL(233) != 0L) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXY32", "", "");
            }
            if (this.BL(232) != 0L && this.BL(233) != 0L && this.BI(9) == 0 && this.BI(10) == 0) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "6221", "XXB", "", "");
            }
        }
        if (this.BI(9) != 0 && this.BI(10) != 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1314", "XXB", "", "");
        }
        rc = Util.aggRc(rc, this.liquidaTRecBTipoFornitore());
        rc = Util.aggRc(rc, this.liquidaTRecBCF());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && Util.esisteAlmenoUnCampo(this.recordB, 38, 49) && (Util.esisteAlmenoUnCampo(this.recordB, 57, 66) || Util.esisteAlmenoUnCampo(this.recordB, 71, 73) || this.BL(79) != 0L)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1316", "XXB", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && Util.esisteAlmenoUnCampo(this.recordB, 38, 47) && (Util.esisteAlmenoUnCampo(this.recordB, 58, 66) || this.BL(72) != 0L)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1316", "XXB", "", "");
        }
        if (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) {
            rc = Util.aggRc(rc, this.liquidaTRecBAnagrafica());
        }
        rc = Util.aggRc(rc, this.liquidaTRecBDatiSocieta());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && Util.esisteAlmenoUnCampo(this.recordB, 57, 73) && !Util.esisteAlmenoUnCampo(this.recordB, 93, 113)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1318", "XXB", "", "");
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && Util.esisteAlmenoUnCampo(this.recordB, 93, 113)) {
            rc = Util.aggRc(rc, this.liquidaTRecBRappresentante());
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BI(209) == 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXY09", "", "");
        }
        rc = Util.aggRc(rc, this.liquidaQuadriCompilati());
        if (!this.TIPO_MODELLO.equals("77S") && this.BI(210) == 0) {
            rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXY10", "", "");
        }
        if (this.BI(211) != 0 && !Util.esisteAlmenoUnCampo(this.recordB, 218, 223)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1388", "XXY11", "", "");
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && Util.esisteAlmenoUnCampo(this.recordB, 227, 228) && this.BS(224).trim().length() == 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXY24", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && Util.isNumericoAssoluto(this.BS(224).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1345", "XXY24", "", "");
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && Util.esisteAlmenoUnCampo(this.recordB, 212, 214) && !Util.esistenzaTuttiCampi(this.recordB, 212, 214, true)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1435", "XXY12", "", "");
        }
        if (this.BS(218).trim().length() != 0 && this.BI(223) == 0) {
            rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1310", "XXY03", "", "");
        }
        return rc;
    }

    private int liquidaTRecBAnagrafica() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean isPNF = false;
        if (Util.isNumericoAssoluto(this.codFiscDichiarante) && this.BS(27).trim().length() != 0) {
            isPNF = true;
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BL(28) == 0L) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1096", "XXB28", this.BS(28), "");
        }
        if (this.BS(33).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(33).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXB33", "", "");
        }
        if (this.BS(34).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(34).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXB34", "", "");
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && !isPNF) {
            String provRes;
            if (this.BS(44).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB44", "", "");
            }
            if (!(provRes = this.BS(45).trim()).equals("EE") && !Util.isNonValorizzato(provRes)) {
                if (this.BI(47) == 0) {
                    rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXB47", "", "");
                }
                if (this.BS(46).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB46", "", "");
                }
            }
        }
        return rc;
    }

    private int liquidaTRecBCF() {
        int rc = 0;
        int rcBP = 0;
        String CF2 = this.BS(2).trim();
        String CF10 = "";
        if (CF2.length() > 9) {
            CF10 = this.BS(2).substring(0, 10);
        }
        boolean isCfAssente = CF10.equals("PROG REC N");
        boolean isCFPNF = false;
        boolean isCFerrato = true;
        if (!isCfAssente) {
            boolean bl = isCFerrato = !Util.controlloCF(CF2);
            if (Util.isNumericoAssoluto(CF2) && this.BS(27).trim().length() != 0) {
                isCFPNF = true;
            }
        }
        boolean pf = false;
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && !isCFPNF) {
            pf = true;
        }
        boolean errore = true;
        errore = true;
        if (this.banchePoste && (this.BS(25).trim().length() != 0 && this.BS(26).trim().length() != 0 || this.BS(27).trim().length() != 0)) {
            errore = false;
        }
        if (isCfAssente && errore) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB02", "", "");
        }
        if (!isCfAssente && isCFerrato && errore) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1013", "XXB02", CF2, "");
        }
        errore = true;
        if (this.banchePoste && !isCFerrato) {
            errore = false;
        }
        if (!pf) {
            if (this.BS(27).trim().length() == 0 && errore) {
                rc = Diagnostici.DIA(rc, CODWARNING, CF2, "1016", "XXB27", "", "");
            }
        } else {
            if (this.BS(25).trim().length() == 0 && errore) {
                rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB25", "", "");
            }
            if (this.BS(26).trim().length() == 0 && errore) {
                rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB26", "", "");
            }
        }
        if (this.BS(25).trim().length() != 0 && this.BS(27).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1342", "XXB", "", "");
        } else if (this.BS(26).trim().length() != 0 && this.BS(27).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1342", "XXB", "", "");
        }
        int coderr = 16;
        if (this.banchePoste) {
            coderr = this.codGravDatiIncoerenti;
        }
        if (pf) {
            if (this.BS(38).trim().length() == 0 && errore) {
                rcBP = Diagnostici.DIA(rcBP, coderr, this.codFiscDichiarante, "1016", "XXB38", "", "");
            }
            if (this.BL(40) == 0L && errore) {
                rcBP = Diagnostici.DIA(rcBP, coderr, this.codFiscDichiarante, "1016", "XXB40", "", "");
            }
            if (this.BS(41).trim().length() == 0 && errore) {
                rcBP = Diagnostici.DIA(rcBP, coderr, this.codFiscDichiarante, "1016", "XXB41", "", "");
            }
            rc = Util.aggRc(rc, rcBP);
        }
        return rc;
    }

    private int liquidaTRecBDatiSocieta() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean isCFNumerico = Util.isNumericoAssoluto(this.codFiscDichiarante);
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && isCFNumerico && this.BS(27).trim().length() != 0) {
            String prov;
            if (this.BI(57) != 0 && !Util.controlloMeseAnno(this.BS(57))) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB57", this.BS(57), "");
            }
            if (this.BS(58).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB58", "", "");
            }
            if (!(prov = this.BS(59).trim()).equals("EE") && !Util.isNonValorizzato(prov)) {
                if (this.BS(60).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB60", "", "");
                }
                if (this.BI(61) == 0) {
                    rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXB61", "", "");
                }
            }
            if (this.BI(62) != 0 && !Util.controlloMeseAnno(this.BS(62))) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB62", this.BS(62), "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 63, 66)) {
                if (this.BS(63).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB63", "", "");
                }
                if (this.BS(64).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB64", "", "");
                }
                if (this.BS(64).trim().length() != 0 && this.BS(64).trim().equals("EE")) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1354", "XXB64", "", "");
                }
                if (this.BS(65).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB65", "", "");
                }
                if (this.BI(66) == 0) {
                    rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXB66", "", "");
                }
            }
            if (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) {
                if (this.BI(71) == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB71", "", "");
                }
                if (this.BI(73) == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB73", "", "");
                }
            }
            if (this.BI(72) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB72", "", "");
            }
            if (this.TIPO_MODELLO.equals("770") && this.BI(188) == 0 && Util.esisteAlmenoUnCampo(this.recordB, 82, 85)) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "6234", "XXB82", "", "");
            }
        }
        return rc;
    }

    private int liquidaTRecBProtocollo() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        String[] rcProt = new String[5];
        if (this.banchePoste) {
            rcProt = LiquidatoreOld.controlloProtocolloBanchePoste(this.BS(5), this.BS(247), this.BD(248), this.getCodiceFornitura(), this.tipoFornitore, this.BI(254), this.BI(249), 2005);
            if (rcProt[0].equals("1070")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[0], "XXB05", "", "");
            }
            if (rcProt[1].equals("1071") && !rcProt[0].equals("1070")) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1070", "XXB05", "", "");
            }
            if (rcProt[2].equals("1072")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[2], "XXY47", "", "");
            }
            if (rcProt[3].equals("1073")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[3], "XXY48", "", "");
            }
            if (rcProt[4].equals("1095")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[4], "XXY49", "", "");
            }
        } else if (this.BS(5).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1300", "XXB05", "", "");
        }
        if (this.tipoFornitore == 7 && this.BS(245).trim().length() != 0) {
            String protocollo = this.BS(245).trim();
            if (protocollo.length() == 25) {
                String abi = protocollo.substring(0, 5);
                String cab = protocollo.substring(5, 10);
                String tipo = protocollo.substring(10, 13);
                String data8 = protocollo.substring(13, 21);
                String progr = protocollo.substring(21, 25);
                double annoCorrente = 2006.0;
                if (!(Util.isNumericoAssoluto(abi) && !abi.equals("00000") && Util.isNumericoAssoluto(cab) && !cab.equals("00000") && (tipo.equals("UNI") || tipo.equals("SCE") || tipo.equals("SCS") || tipo.equals("IVA") || tipo.equals("730") || tipo.equals("U50") || tipo.equals("U60") || tipo.equals("U61") || tipo.equals("770") || tipo.equals("77S")) && Util.isNumericoAssoluto(data8) && Util.controlloData(data8) && !data8.equals("00000000") && Util.isNumericoAssoluto(progr))) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1070", "XXY45", "", "");
                } else if (Util.valoreDouble(data8.substring(4, 8)) != annoCorrente && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente - 1.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 1.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 2.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 3.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 4.0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1070", "XXY45", "", "");
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1070", "XXY45", "", "");
            }
        }
        return rc;
    }

    private int liquidaTRecBRappresentanteDenominazione() {
        int rc = 0;
        String codFiscRappresentante = this.BS(93).trim();
        boolean isNascitaPresente = Util.esistenzaTuttiCampi(this.recordB, 98, 103, true);
        if (Util.isNumericoAssoluto(codFiscRappresentante) && this.BS(97).trim().length() == 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1362", "XXB97", "", "");
        }
        if (isNascitaPresente && this.BS(97).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1363", "XXB97", "", "");
        }
        return rc;
    }

    private int liquidaTRecBRappresentante() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        String codFiscRappresentante = this.BS(93).trim();
        boolean isAnagraficaPresente = Util.esistenzaTuttiCampi(this.recordB, 93, 107, true);
        boolean isProvIta = false;
        boolean isPf = false;
        if (!this.banchePoste) {
            if (codFiscRappresentante.length() == 0) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1014", "XXB93", "", "");
            }
            if (!Util.isNumericoAssoluto(codFiscRappresentante) || this.TIPO_MODELLO.equals("IVA")) {
                isPf = true;
            }
            if (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) {
                rc = Util.aggRc(rc, this.liquidaTRecBRappresentanteDenominazione());
            }
            if (isPf) {
                if (this.BS(98).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXB98", "", "");
                }
                if (this.BS(99).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXB99", "", "");
                }
                if (this.BS(100).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX00", "", "");
                }
                if (this.BI(101) == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX01", "", "");
                }
                if (this.BS(102).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX02", "", "");
                }
            }
        } else {
            if (!isAnagraficaPresente && codFiscRappresentante.length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXB93", "", "");
            }
            if (codFiscRappresentante.length() == 0) {
                if (this.BS(98).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB98", "", "");
                }
                if (this.BS(99).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB99", "", "");
                }
                if (this.BS(100).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX00", "", "");
                }
                if (this.BI(101) == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX01", "", "");
                }
                if (this.BS(102).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX02", "", "");
                }
            }
            if (isAnagraficaPresente && codFiscRappresentante.length() != 0 && Util.controlloCF(codFiscRappresentante)) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1326", "XXB", "", "");
            }
        }
        boolean dichiaranteIsPNF = false;
        if (Util.isNumericoAssoluto(this.codFiscDichiarante) && this.BS(27).trim().length() != 0) {
            dichiaranteIsPNF = true;
        }
        if (this.BI(95) == 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB95", "", "");
        } else if ((this.BI(95) == 2 || this.BI(95) == 7 || this.BI(95) == 11) && dichiaranteIsPNF) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1434", "XXB95", "", "");
        }
        String prov = this.BS(105).trim();
        if (!prov.equals("EE") && !Util.isNonValorizzato(prov)) {
            isProvIta = true;
        }
        if (isProvIta) {
            if (this.BS(104).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX04", "", "");
            }
            if (this.BI(106) == 0) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXX06", "", "");
            }
            if (this.BS(107).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX07", "", "");
            }
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BI(95) != 1 && this.BI(95) != 6 && this.BI(95) != 9 && this.BL(94) != 0L) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1300", "XXB95", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BL(96) == 0L && (this.BI(95) == 3 || this.BI(95) == 4)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB96", "", "");
        }
        if (this.BS(108).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(108).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXX08", "", "");
        }
        return rc;
    }

    public int liquidaTRecBScelte() {
        int rc = 0;
        return rc;
    }

    private int liquidaTRecBTipoFornitore() {
        boolean propria;
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        int codiceCarica = this.BI(95);
        String codFiscFornitore = this.AS(5).trim();
        String codFiscRappresentante = this.BS(93).trim();
        String codFiscIntermediario = this.BS(218).trim();
        boolean esisteIntermediario = Util.esisteAlmenoUnCampo(this.recordB, 218, 223);
        boolean rappresentantePersonale = codiceCarica == 2 || codiceCarica == 3 || codiceCarica == 4 || codiceCarica == 5 || codiceCarica == 7 || codiceCarica == 11;
        boolean bl = propria = codFiscFornitore.equals(this.codFiscDichiarante) || codFiscFornitore.equals(codFiscRappresentante) && rappresentantePersonale;
        if (this.tipoFornitore == 10 && !propria || esisteIntermediario) {
            if (Util.isNonValorizzato(codFiscIntermediario)) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1074", "XXX93", "", "");
            }
            if (this.BI(220) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXY20", "", "");
            }
            if (this.BI(221) != 0 && this.BI(211) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1389", "XXY21", "", "");
            }
            if (this.BI(222) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1309", "XXY22", "", "");
            }
        }
        if (this.tipoFornitore == 6) {
            if (!Util.isNumericoAssoluto(this.codFiscDichiarante) || this.codFiscDichiarante.length() != 11) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1305", "XXB02", this.codFiscDichiarante, "");
            }
            if (!codFiscFornitore.equals(this.codFiscDichiarante) && !codFiscFornitore.equals(codFiscIntermediario)) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1306", "XXB02", "", "");
            }
        }
        if ((this.tipoFornitore == 7 || this.tipoFornitore == 8) && this.BS(250).trim().length() == 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXY32", "", "");
        }
        return rc;
    }

    public int liquidaTRecZ(int[] ctrRecords) {
        int rc = 0;
        String cfRecZ = "ZZZZZZZZZZZZZZZZ";
        if (this.ZD(3) != (double)ctrRecords[0]) {
            rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ03", this.ZD(3), (double)ctrRecords[0]);
        }
        if (this.TIPO_MODELLO.equals("UNI") || this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) {
            if (this.ZD(4) != (double)ctrRecords[1]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ04", this.ZD(4), (double)ctrRecords[1]);
            }
            if (this.ZD(5) != (double)ctrRecords[2]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ05", this.ZD(5), (double)ctrRecords[2]);
            }
            if (this.ZD(6) != (double)ctrRecords[3]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ06", this.ZD(6), (double)ctrRecords[3]);
            }
            if (this.ZD(7) != (double)ctrRecords[7]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ07", this.ZD(7), (double)ctrRecords[7]);
            }
            if (this.ZD(8) != (double)ctrRecords[10]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ08", this.ZD(8), (double)ctrRecords[10]);
            }
            if (this.ZD(9) != (double)ctrRecords[15]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ10", this.ZD(9), (double)ctrRecords[15]);
            }
            if (this.ZD(10) != (double)ctrRecords[16]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ10", this.ZD(10), (double)ctrRecords[16]);
            }
            if (this.ZD(11) != (double)ctrRecords[17]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ11", this.ZD(11), (double)ctrRecords[17]);
            }
            if (this.ZD(12) != (double)ctrRecords[18]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ12", this.ZD(12), (double)ctrRecords[18]);
            }
            if (this.ZD(13) != (double)ctrRecords[19]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ13", this.ZD(13), (double)ctrRecords[19]);
            }
            if (this.ZD(14) != (double)ctrRecords[22]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ14", this.ZD(14), (double)ctrRecords[22]);
            }
        }
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("CAP")) && this.ZD(4) != (double)ctrRecords[1]) {
            rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ04", this.ZD(4), (double)ctrRecords[1]);
        }
        if (this.TIPO_MODELLO.equals("77S")) {
            if (this.ZD(4) != (double)ctrRecords[1]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ04", this.ZD(4), (double)ctrRecords[1]);
            }
            if (this.ZD(5) != (double)ctrRecords[2]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ05", this.ZD(5), (double)ctrRecords[2]);
            }
            if (this.ZD(6) != (double)ctrRecords[3]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ06", this.ZD(6), (double)ctrRecords[3]);
            }
            if (this.ZD(7) != (double)ctrRecords[4]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ07", this.ZD(7), (double)ctrRecords[4]);
            }
        }
        return rc;
    }

    public String mod(int m) {
        String modulo = Util.formNum(8, m);
        return modulo;
    }

    public int numeroModuliQuadro(String quadro) {
        return this.dich.maxModuliDaQuadro(quadro);
    }

    public void setBanchePoste(boolean banchePoste) {
        this.banchePoste = banchePoste;
    }

    public void setcodGravDatiIncoerenti(int codGravDatiIncoerenti) {
        this.codGravDatiIncoerenti = codGravDatiIncoerenti;
    }

    public void setcodGravConferma(int codGravConferma) {
        this.codGravConferma = codGravConferma;
    }

    public void setcodFiscDichiarante(String codFiscDichiarante) {
        this.codFiscDichiarante = codFiscDichiarante;
    }

    public void setTipoFornitore(int tipoFornitore) {
        this.tipoFornitore = tipoFornitore;
    }

    protected int soloSulPrimoModulo(String[] campi, String cfPerc) {
        int rc = 0;
        if (campi == null) {
            return rc;
        }
        int len = campi.length;
        int j = 0;
        while (j < len) {
            String codCampo = campi[j];
            if (codCampo.length() == 8) {
                String quadro = codCampo.substring(0, 2);
                String rigaColonna = codCampo.substring(2, 8);
                int MaxModQuadro = this.dich.maxModuliDaQuadro(quadro);
                int i = 2;
                while (i <= MaxModQuadro) {
                    String modCorrente = Util.formNum(8, i);
                    if (this.dich.esisteCampo(String.valueOf(codCampo) + modCorrente)) {
                        rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, cfPerc, "1052", String.valueOf(quadro) + rigaColonna + modCorrente, "", "", "", "");
                    }
                    ++i;
                }
            } else {
                System.out.println("!!!ERRORE!!! - soloSulPrimoModulo(...): formato del codice campo errato: " + codCampo);
            }
            ++j;
        }
        return rc;
    }
}

