/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.xml.internal.stream.XMLBufferListener;

public class XMLAttributesImpl
implements XMLAttributes,
XMLBufferListener {
    protected static final int TABLE_SIZE = 101;
    protected static final int SIZE_LIMIT = 20;
    protected boolean fNamespaces = true;
    protected int fLargeCount = 1;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Attribute[] fAttributeTableView;
    protected int[] fAttributeTableViewChainState;
    protected int fTableViewBuckets;
    protected boolean fIsTableViewConsistent;

    public XMLAttributesImpl() {
        this(101);
    }

    public XMLAttributesImpl(int n) {
        this.fTableViewBuckets = n;
        for (int i = 0; i < this.fAttributes.length; ++i) {
            this.fAttributes[i] = new Attribute();
        }
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    @Override
    public int addAttribute(QName qName, String string, String string2) {
        return this.addAttribute(qName, string, string2, null);
    }

    public int addAttribute(QName qName, String string, String string2, XMLString xMLString) {
        Attribute[] attributeArray;
        int n;
        if (this.fLength < 20) {
            int n2 = n = qName.uri != null && !qName.uri.equals("") ? this.getIndexFast(qName.uri, qName.localpart) : this.getIndexFast(qName.rawname);
            if (n == -1) {
                n = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    attributeArray = new Attribute[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributeArray.length; ++i) {
                        attributeArray[i] = new Attribute();
                    }
                    this.fAttributes = attributeArray;
                }
            }
        } else if (qName.uri == null || qName.uri.length() == 0 || (n = this.getIndexFast(qName.uri, qName.localpart)) == -1) {
            int n3;
            if (!this.fIsTableViewConsistent || this.fLength == 20) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[n3 = this.getTableViewBucket(qName.rawname)] != this.fLargeCount) {
                n = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributeArray2 = new Attribute[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributeArray2, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributeArray2.length; ++i) {
                        attributeArray2[i] = new Attribute();
                    }
                    this.fAttributes = attributeArray2;
                }
                this.fAttributeTableViewChainState[n3] = this.fLargeCount;
                this.fAttributes[n].next = null;
                this.fAttributeTableView[n3] = this.fAttributes[n];
            } else {
                Attribute attribute = this.fAttributeTableView[n3];
                while (attribute != null && attribute.name.rawname != qName.rawname) {
                    attribute = attribute.next;
                }
                if (attribute == null) {
                    n = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        Attribute[] attributeArray3 = new Attribute[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributeArray3, 0, this.fAttributes.length);
                        for (int i = this.fAttributes.length; i < attributeArray3.length; ++i) {
                            attributeArray3[i] = new Attribute();
                        }
                        this.fAttributes = attributeArray3;
                    }
                    this.fAttributes[n].next = this.fAttributeTableView[n3];
                    this.fAttributeTableView[n3] = this.fAttributes[n];
                } else {
                    n = this.getIndexFast(qName.rawname);
                }
            }
        }
        attributeArray = this.fAttributes[n];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.xmlValue = xMLString;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        if (attributeArray.augs != null) {
            attributeArray.augs.removeAllItems();
        }
        return n;
    }

    @Override
    public void removeAllAttributes() {
        this.fLength = 0;
    }

    @Override
    public void removeAttributeAt(int n) {
        this.fIsTableViewConsistent = false;
        if (n < this.fLength - 1) {
            Attribute attribute = this.fAttributes[n];
            System.arraycopy(this.fAttributes, n + 1, this.fAttributes, n, this.fLength - n - 1);
            this.fAttributes[this.fLength - 1] = attribute;
        }
        --this.fLength;
    }

    @Override
    public void setName(int n, QName qName) {
        this.fAttributes[n].name.setValues(qName);
    }

    @Override
    public void getName(int n, QName qName) {
        qName.setValues(this.fAttributes[n].name);
    }

    @Override
    public void setType(int n, String string) {
        this.fAttributes[n].type = string;
    }

    @Override
    public void setValue(int n, String string) {
        this.setValue(n, string, null);
    }

    @Override
    public void setValue(int n, String string, XMLString xMLString) {
        Attribute attribute = this.fAttributes[n];
        attribute.value = string;
        attribute.nonNormalizedValue = string;
        attribute.xmlValue = xMLString;
    }

    @Override
    public void setNonNormalizedValue(int n, String string) {
        if (string == null) {
            string = this.fAttributes[n].value;
        }
        this.fAttributes[n].nonNormalizedValue = string;
    }

    @Override
    public String getNonNormalizedValue(int n) {
        String string = this.fAttributes[n].nonNormalizedValue;
        return string;
    }

    @Override
    public void setSpecified(int n, boolean bl) {
        this.fAttributes[n].specified = bl;
    }

    @Override
    public boolean isSpecified(int n) {
        return this.fAttributes[n].specified;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public String getType(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.getReportableType(this.fAttributes[n].type);
    }

    @Override
    public String getType(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.getReportableType(this.fAttributes[n].type) : null;
    }

    @Override
    public String getValue(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        if (this.fAttributes[n].value == null && this.fAttributes[n].xmlValue != null) {
            this.fAttributes[n].value = this.fAttributes[n].xmlValue.toString();
        }
        return this.fAttributes[n].value;
    }

    @Override
    public String getValue(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return null;
        }
        if (this.fAttributes[n].value == null) {
            this.fAttributes[n].value = this.fAttributes[n].xmlValue.toString();
        }
        return this.fAttributes[n].value;
    }

    public String getName(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].name.rawname;
    }

    @Override
    public int getIndex(String string) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.rawname == null || !attribute.name.rawname.equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String string, String string2) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.localpart == null || !attribute.name.localpart.equals(string2) || string != attribute.name.uri && (string == null || attribute.name.uri == null || !attribute.name.uri.equals(string))) continue;
            return i;
        }
        return -1;
    }

    public int getIndexByLocalName(String string) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.localpart == null || !attribute.name.localpart.equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getLocalName(int n) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].name.localpart;
    }

    @Override
    public String getQName(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].name.rawname;
        return string != null ? string : "";
    }

    @Override
    public QName getQualifiedName(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].name;
    }

    @Override
    public String getType(String string, String string2) {
        if (!this.fNamespaces) {
            return null;
        }
        int n = this.getIndex(string, string2);
        return n != -1 ? this.getType(n) : null;
    }

    public int getIndexFast(String string) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.rawname != string) continue;
            return i;
        }
        return -1;
    }

    public void addAttributeNS(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n = this.fLength;
        if (this.fLength++ == this.fAttributes.length) {
            attributeArray = this.fLength < 20 ? new Attribute[this.fAttributes.length + 4] : new Attribute[this.fAttributes.length << 1];
            System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
            for (int i = this.fAttributes.length; i < attributeArray.length; ++i) {
                attributeArray[i] = new Attribute();
            }
            this.fAttributes = attributeArray;
        }
        attributeArray = this.fAttributes[n];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
    }

    public QName checkDuplicatesNS() {
        if (this.fLength <= 20) {
            for (int i = 0; i < this.fLength - 1; ++i) {
                Attribute attribute = this.fAttributes[i];
                for (int j = i + 1; j < this.fLength; ++j) {
                    Attribute attribute2 = this.fAttributes[j];
                    if (attribute.name.localpart != attribute2.name.localpart || attribute.name.uri != attribute2.name.uri) continue;
                    return attribute2.name;
                }
            }
        } else {
            this.fIsTableViewConsistent = false;
            this.prepareTableView();
            for (int i = this.fLength - 1; i >= 0; --i) {
                Attribute attribute = this.fAttributes[i];
                int n = this.getTableViewBucket(attribute.name.localpart, attribute.name.uri);
                if (this.fAttributeTableViewChainState[n] != this.fLargeCount) {
                    this.fAttributeTableViewChainState[n] = this.fLargeCount;
                    attribute.next = null;
                    this.fAttributeTableView[n] = attribute;
                    continue;
                }
                Attribute attribute3 = this.fAttributeTableView[n];
                while (attribute3 != null) {
                    if (attribute3.name.localpart == attribute.name.localpart && attribute3.name.uri == attribute.name.uri) {
                        return attribute.name;
                    }
                    attribute3 = attribute3.next;
                }
                attribute.next = this.fAttributeTableView[n];
                this.fAttributeTableView[n] = attribute;
            }
        }
        return null;
    }

    public int getIndexFast(String string, String string2) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.localpart != string2 || attribute.name.uri != string) continue;
            return i;
        }
        return -1;
    }

    private String getReportableType(String string) {
        if (string.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return string;
    }

    protected int getTableViewBucket(String string) {
        return (string.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected int getTableViewBucket(String string, String string2) {
        if (string2 == null) {
            return (string.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
        }
        return (string.hashCode() + string2.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected void cleanTableView() {
        if (++this.fLargeCount < 0) {
            if (this.fAttributeTableViewChainState != null) {
                for (int i = this.fTableViewBuckets - 1; i >= 0; --i) {
                    this.fAttributeTableViewChainState[i] = 0;
                }
            }
            this.fLargeCount = 1;
        }
    }

    protected void prepareTableView() {
        if (this.fAttributeTableView == null) {
            this.fAttributeTableView = new Attribute[this.fTableViewBuckets];
            this.fAttributeTableViewChainState = new int[this.fTableViewBuckets];
        } else {
            this.cleanTableView();
        }
    }

    protected void prepareAndPopulateTableView() {
        this.prepareTableView();
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            int n = this.getTableViewBucket(attribute.name.rawname);
            if (this.fAttributeTableViewChainState[n] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n] = this.fLargeCount;
                attribute.next = null;
                this.fAttributeTableView[n] = attribute;
                continue;
            }
            attribute.next = this.fAttributeTableView[n];
            this.fAttributeTableView[n] = attribute;
        }
    }

    @Override
    public String getPrefix(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].name.prefix;
        return string != null ? string : "";
    }

    @Override
    public String getURI(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n].name.uri;
        return string;
    }

    @Override
    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n != -1 ? this.getValue(n) : null;
    }

    @Override
    public Augmentations getAugmentations(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n != -1 ? this.fAttributes[n].augs : null;
    }

    @Override
    public Augmentations getAugmentations(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.fAttributes[n].augs : null;
    }

    @Override
    public Augmentations getAugmentations(int n) {
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fAttributes[n].augs;
    }

    @Override
    public void setAugmentations(int n, Augmentations augmentations) {
        this.fAttributes[n].augs = augmentations;
    }

    public void setURI(int n, String string) {
        this.fAttributes[n].name.uri = string;
    }

    public void setSchemaId(int n, boolean bl) {
        this.fAttributes[n].schemaId = bl;
    }

    public boolean getSchemaId(int n) {
        if (n < 0 || n >= this.fLength) {
            return false;
        }
        return this.fAttributes[n].schemaId;
    }

    public boolean getSchemaId(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.fAttributes[n].schemaId : false;
    }

    public boolean getSchemaId(String string, String string2) {
        if (!this.fNamespaces) {
            return false;
        }
        int n = this.getIndex(string, string2);
        return n != -1 ? this.fAttributes[n].schemaId : false;
    }

    @Override
    public void refresh() {
        if (this.fLength > 0) {
            for (int i = 0; i < this.fLength; ++i) {
                this.getValue(i);
            }
        }
    }

    @Override
    public void refresh(int n) {
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public XMLString xmlValue;
        public String nonNormalizedValue;
        public boolean specified;
        public boolean schemaId;
        public Augmentations augs = new AugmentationsImpl();
        public Attribute next;

        Attribute() {
        }
    }
}

