; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=fiji -amdgpu-sdwa-peephole=0 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,NOSDWA %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=fiji -amdgpu-sdwa-peephole -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,SDWA,GFX89 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx900 -amdgpu-sdwa-peephole -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,SDWA,GFX9_10,GFX9 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1010 -amdgpu-sdwa-peephole -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,SDWA,GFX9_10,GFX10 %s

define amdgpu_kernel void @add_shr_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; NOSDWA-LABEL: add_shr_i32:
; NOSDWA:       ; %bb.0:
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    flat_load_dword v2, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: add_shr_i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    flat_load_dword v2, v[0:1]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_add_u32_sdwa v2, vcc, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: add_shr_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: add_shr_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
  %a = load i32, ptr addrspace(1) %in, align 4
  %shr = lshr i32 %a, 16
  %add = add i32 %a, %shr
  store i32 %add, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @sub_shr_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; NOSDWA-LABEL: sub_shr_i32:
; NOSDWA:       ; %bb.0:
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    flat_load_dword v2, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; NOSDWA-NEXT:    v_sub_u32_e32 v2, vcc, v3, v2
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: sub_shr_i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    flat_load_dword v2, v[0:1]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_sub_u32_sdwa v2, vcc, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_shr_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sub_shr_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_sub_nc_u32_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
  %a = load i32, ptr addrspace(1) %in, align 4
  %shr = lshr i32 %a, 16
  %sub = sub i32 %shr, %a
  store i32 %sub, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_shr_i32(ptr addrspace(1) %out, ptr addrspace(1) %in1, ptr addrspace(1) %in2) #0 {
; NOSDWA-LABEL: mul_shr_i32:
; NOSDWA:       ; %bb.0:
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dword v4, v[0:1]
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_mul_u32_u24_e32 v2, v3, v2
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_shr_i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dword v4, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_u32_u24_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_shr_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_shr_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr i32, ptr addrspace(1) %in1, i32 %idx
  %gep2 = getelementptr i32, ptr addrspace(1) %in2, i32 %idx
  %a = load i32, ptr addrspace(1) %gep1, align 4
  %b = load i32, ptr addrspace(1) %gep2, align 4
  %shra = lshr i32 %a, 16
  %shrb = lshr i32 %b, 16
  %mul = mul i32 %shra, %shrb
  store i32 %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_i16(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_ushort v4, v[0:1]
; NOSDWA-NEXT:    flat_load_ushort v2, v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; NOSDWA-NEXT:    flat_store_short v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_ushort v4, v[0:1]
; GFX89-NEXT:    flat_load_ushort v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; GFX89-NEXT:    flat_store_short v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX9-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u16_e32 v1, v1, v2
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u16 v1, v1, v2
; GFX10-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr i16, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr i16, ptr addrspace(1) %inb, i32 %idx
  %a = load i16, ptr addrspace(1) %gepa, align 4
  %b = load i16, ptr addrspace(1) %gepb, align 4
  %mul = mul i16 %a, %b
  store i16 %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v2i16(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v2i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dword v4, v[0:1]
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v4, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v3, v2
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v2i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dword v4, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v3, v4, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v2, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v2i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v2i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <2 x i16>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <2 x i16>, ptr addrspace(1) %inb, i32 %idx
  %a = load <2 x i16>, ptr addrspace(1) %gepa, align 4
  %b = load <2 x i16>, ptr addrspace(1) %gepb, align 4
  %mul = mul <2 x i16> %a, %b
  store <2 x i16> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v4i16(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v4i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; NOSDWA-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v4, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v5, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v6, v1, v3
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v7, v0, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; NOSDWA-NEXT:    v_or_b32_e32 v1, v6, v1
; NOSDWA-NEXT:    v_or_b32_e32 v0, v7, v0
; NOSDWA-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v4i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX89-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v4, s0
; GFX89-NEXT:    v_mov_b32_e32 v5, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v6, v1, v3
; GFX89-NEXT:    v_mul_lo_u16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_lo_u16_e32 v3, v0, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX89-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX89-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v4i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX9-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v4i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX10-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v1, v1, v3
; GFX10-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <4 x i16>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <4 x i16>, ptr addrspace(1) %inb, i32 %idx
  %a = load <4 x i16>, ptr addrspace(1) %gepa, align 4
  %b = load <4 x i16>, ptr addrspace(1) %gepb, align 4
  %mul = mul <4 x i16> %a, %b
  store <4 x i16> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v8i16(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v8i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 4, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v4, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v5, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; NOSDWA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; NOSDWA-NEXT:    v_mov_b32_e32 v8, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v9, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v10, v3, v7
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v11, v2, v6
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v12, v1, v5
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v13, v0, v4
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v3, v7
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v2, v6
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v1, v1, v5
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v0, v0, v4
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; NOSDWA-NEXT:    v_or_b32_e32 v3, v10, v3
; NOSDWA-NEXT:    v_or_b32_e32 v2, v11, v2
; NOSDWA-NEXT:    v_or_b32_e32 v1, v12, v1
; NOSDWA-NEXT:    v_or_b32_e32 v0, v13, v0
; NOSDWA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v8i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 4, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v4, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v5, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX89-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GFX89-NEXT:    v_mov_b32_e32 v8, s0
; GFX89-NEXT:    v_mov_b32_e32 v9, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v10, v3, v7
; GFX89-NEXT:    v_mul_lo_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_lo_u16_e32 v7, v2, v6
; GFX89-NEXT:    v_mul_lo_u16_sdwa v2, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_lo_u16_e32 v6, v1, v5
; GFX89-NEXT:    v_mul_lo_u16_sdwa v1, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_lo_u16_e32 v5, v0, v4
; GFX89-NEXT:    v_mul_lo_u16_sdwa v0, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_or_b32_e32 v3, v10, v3
; GFX89-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX89-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX89-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX89-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v8i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v8, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v3, v3, v7
; GFX9-NEXT:    v_pk_mul_lo_u16 v2, v2, v6
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX9-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX9-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v8i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 4, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v8, s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v3, v3, v7
; GFX10-NEXT:    v_pk_mul_lo_u16 v2, v2, v6
; GFX10-NEXT:    v_pk_mul_lo_u16 v1, v1, v5
; GFX10-NEXT:    v_pk_mul_lo_u16 v0, v0, v4
; GFX10-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <8 x i16>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <8 x i16>, ptr addrspace(1) %inb, i32 %idx
  %a = load <8 x i16>, ptr addrspace(1) %gepa, align 4
  %b = load <8 x i16>, ptr addrspace(1) %gepb, align 4
  %mul = mul <8 x i16> %a, %b
  store <8 x i16> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_half(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_half:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    flat_load_ushort v4, v[0:1]
; NOSDWA-NEXT:    flat_load_ushort v2, v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_f16_e32 v2, v4, v2
; NOSDWA-NEXT:    flat_store_short v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_half:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mov_b32_e32 v2, s4
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    flat_load_ushort v4, v[0:1]
; GFX89-NEXT:    flat_load_ushort v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_f16_e32 v2, v4, v2
; GFX89-NEXT:    flat_store_short v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX9-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v1, v1, v2
; GFX10-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load half, ptr addrspace(1) %ina, align 4
  %b = load half, ptr addrspace(1) %inb, align 4
  %mul = fmul half %a, %b
  store half %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v2half(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v2half:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    flat_load_dword v3, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; NOSDWA-NEXT:    v_mul_f16_e32 v4, v5, v4
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; NOSDWA-NEXT:    v_mul_f16_e32 v2, v3, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v4
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v2half:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mov_b32_e32 v2, s4
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    flat_load_dword v4, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_f16_sdwa v3, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v2, v4, v2
; GFX89-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v2half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v2half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_f16 v1, v1, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load <2 x half>, ptr addrspace(1) %ina, align 4
  %b = load <2 x half>, ptr addrspace(1) %inb, align 4
  %mul = fmul <2 x half> %a, %b
  store <2 x half> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v4half(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v4half:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; NOSDWA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v4, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v5, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; NOSDWA-NEXT:    v_mul_f16_e32 v1, v1, v3
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; NOSDWA-NEXT:    v_mul_f16_e32 v0, v0, v2
; NOSDWA-NEXT:    v_mul_f16_e32 v2, v7, v6
; NOSDWA-NEXT:    v_mul_f16_e32 v3, v8, v3
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_or_b32_e32 v1, v1, v2
; NOSDWA-NEXT:    v_or_b32_e32 v0, v0, v3
; NOSDWA-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v4half:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mov_b32_e32 v2, s4
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX89-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v4, s0
; GFX89-NEXT:    v_mov_b32_e32 v5, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_f16_sdwa v6, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v1, v1, v3
; GFX89-NEXT:    v_mul_f16_sdwa v3, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX89-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX89-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX89-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v4half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v4half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX10-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_f16 v1, v1, v3
; GFX10-NEXT:    v_pk_mul_f16 v0, v0, v2
; GFX10-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load <4 x half>, ptr addrspace(1) %ina, align 4
  %b = load <4 x half>, ptr addrspace(1) %inb, align 4
  %mul = fmul <4 x half> %a, %b
  store <4 x half> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v8half(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v8half:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v4, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v5, s3
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s5
; NOSDWA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; NOSDWA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; NOSDWA-NEXT:    v_mov_b32_e32 v8, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v9, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v11, 16, v7
; NOSDWA-NEXT:    v_mul_f16_e32 v3, v7, v3
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v12, 16, v6
; NOSDWA-NEXT:    v_mul_f16_e32 v2, v6, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v13, 16, v5
; NOSDWA-NEXT:    v_mul_f16_e32 v1, v5, v1
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; NOSDWA-NEXT:    v_mul_f16_e32 v0, v4, v0
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; NOSDWA-NEXT:    v_mul_f16_e32 v10, v11, v10
; NOSDWA-NEXT:    v_mul_f16_e32 v7, v12, v7
; NOSDWA-NEXT:    v_mul_f16_e32 v6, v13, v6
; NOSDWA-NEXT:    v_mul_f16_e32 v4, v4, v5
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; NOSDWA-NEXT:    v_or_b32_e32 v3, v3, v5
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v7
; NOSDWA-NEXT:    v_or_b32_e32 v1, v1, v6
; NOSDWA-NEXT:    v_or_b32_e32 v0, v0, v4
; NOSDWA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v8half:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mov_b32_e32 v4, s4
; GFX89-NEXT:    v_mov_b32_e32 v5, s5
; GFX89-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX89-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GFX89-NEXT:    v_mov_b32_e32 v8, s0
; GFX89-NEXT:    v_mov_b32_e32 v9, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_f16_sdwa v10, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v3, v3, v7
; GFX89-NEXT:    v_mul_f16_sdwa v7, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v2, v2, v6
; GFX89-NEXT:    v_mul_f16_sdwa v6, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v1, v1, v5
; GFX89-NEXT:    v_mul_f16_sdwa v5, v0, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX89-NEXT:    v_or_b32_e32 v3, v3, v10
; GFX89-NEXT:    v_or_b32_e32 v2, v2, v7
; GFX89-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX89-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX89-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v8half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v8, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v3, v3, v7
; GFX9-NEXT:    v_pk_mul_f16 v2, v2, v6
; GFX9-NEXT:    v_pk_mul_f16 v1, v1, v5
; GFX9-NEXT:    v_pk_mul_f16 v0, v0, v4
; GFX9-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v8half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v8, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_f16 v3, v3, v7
; GFX10-NEXT:    v_pk_mul_f16 v2, v2, v6
; GFX10-NEXT:    v_pk_mul_f16 v1, v1, v5
; GFX10-NEXT:    v_pk_mul_f16 v0, v0, v4
; GFX10-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load <8 x half>, ptr addrspace(1) %ina, align 4
  %b = load <8 x half>, ptr addrspace(1) %inb, align 4
  %mul = fmul <8 x half> %a, %b
  store <8 x half> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_i8(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_i8:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s3
; NOSDWA-NEXT:    v_add_u32_e32 v1, vcc, s2, v0
; NOSDWA-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v4, s5
; NOSDWA-NEXT:    v_add_u32_e32 v3, vcc, s4, v0
; NOSDWA-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; NOSDWA-NEXT:    flat_load_ubyte v2, v[1:2]
; NOSDWA-NEXT:    flat_load_ubyte v3, v[3:4]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v2, v3
; NOSDWA-NEXT:    flat_store_byte v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_i8:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v2, s3
; GFX89-NEXT:    v_add_u32_e32 v1, vcc, s2, v0
; GFX89-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX89-NEXT:    v_mov_b32_e32 v4, s5
; GFX89-NEXT:    v_add_u32_e32 v3, vcc, s4, v0
; GFX89-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; GFX89-NEXT:    flat_load_ubyte v2, v[1:2]
; GFX89-NEXT:    flat_load_ubyte v3, v[3:4]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v2, v2, v3
; GFX89-NEXT:    flat_store_byte v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_i8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ubyte v1, v0, s[2:3]
; GFX9-NEXT:    global_load_ubyte v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u16_e32 v1, v1, v2
; GFX9-NEXT:    global_store_byte v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_i8:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_ubyte v1, v0, s[2:3]
; GFX10-NEXT:    global_load_ubyte v2, v0, s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u16 v1, v1, v2
; GFX10-NEXT:    global_store_byte v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr i8, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr i8, ptr addrspace(1) %inb, i32 %idx
  %a = load i8, ptr addrspace(1) %gepa, align 4
  %b = load i8, ptr addrspace(1) %gepb, align 4
  %mul = mul i8 %a, %b
  store i8 %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v2i8(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v2i8:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_ushort v4, v[0:1]
; NOSDWA-NEXT:    flat_load_ushort v2, v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v3, 8, v4
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v5, 8, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v3, v5
; NOSDWA-NEXT:    v_and_b32_e32 v2, 0xff, v2
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v3, 8, v3
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v3
; NOSDWA-NEXT:    flat_store_short v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v2i8:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_ushort v4, v[0:1]
; GFX89-NEXT:    flat_load_ushort v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v3, v4, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v2, v4, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX89-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    flat_store_short v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v2i8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX9-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u16_e32 v3, v1, v2
; GFX9-NEXT:    v_mul_lo_u16_sdwa v1, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NEXT:    v_or_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v2i8:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_lshrrev_b16 v0, 8, v1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b16 v3, 8, v2
; GFX10-NEXT:    v_mul_lo_u16 v1, v1, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mul_lo_u16 v0, v0, v3
; GFX10-NEXT:    v_lshlrev_b16 v0, 8, v0
; GFX10-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v2, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <2 x i8>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <2 x i8>, ptr addrspace(1) %inb, i32 %idx
  %a = load <2 x i8>, ptr addrspace(1) %gepa, align 4
  %b = load <2 x i8>, ptr addrspace(1) %gepb, align 4
  %mul = mul <2 x i8> %a, %b
  store <2 x i8> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v4i8(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v4i8:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    flat_load_dword v4, v[0:1]
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dword v2, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 24, v4
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v6, 8, v4
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v8, 24, v2
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v9, 8, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v4, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v4, v6, v9
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v5, v5, v8
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v3, v7
; NOSDWA-NEXT:    v_and_b32_e32 v2, 0xff, v2
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v4, 8, v4
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; NOSDWA-NEXT:    v_and_b32_e32 v3, 0xff, v3
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v4
; NOSDWA-NEXT:    v_or_b32_e32 v3, v3, v5
; NOSDWA-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v3
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v4i8:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dword v4, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v3, v4, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v5, v4, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX89-NEXT:    v_mul_lo_u16_sdwa v6, v4, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX89-NEXT:    v_mul_lo_u16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_or_b32_sdwa v3, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v2, v2, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v4i8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u16_e32 v3, v1, v2
; GFX9-NEXT:    v_mul_lo_u16_sdwa v4, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NEXT:    v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NEXT:    v_mul_lo_u16_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v4i8:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX10-NEXT:    v_lshrrev_b16 v3, 8, v1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b16 v4, 8, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX10-NEXT:    v_mul_lo_u16 v1, v1, v2
; GFX10-NEXT:    v_mul_lo_u16 v3, v3, v4
; GFX10-NEXT:    v_mul_lo_u16 v0, v0, v5
; GFX10-NEXT:    v_mul_lo_u16 v2, v6, v7
; GFX10-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX10-NEXT:    v_lshlrev_b16 v0, 8, v0
; GFX10-NEXT:    v_or_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <4 x i8>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <4 x i8>, ptr addrspace(1) %inb, i32 %idx
  %a = load <4 x i8>, ptr addrspace(1) %gepa, align 4
  %b = load <4 x i8>, ptr addrspace(1) %gepb, align 4
  %mul = mul <4 x i8> %a, %b
  store <4 x i8> %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @mul_v8i8(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mul_v8i8:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; NOSDWA-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v4, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v5, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v8, 8, v0
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v11, 8, v1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v13, 24, v2
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v14, 8, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v15, 16, v3
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v16, 24, v3
; NOSDWA-NEXT:    v_lshrrev_b16_e32 v17, 8, v3
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v1, v1, v3
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v0, v0, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v11, v17
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v10, v16
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v9, v9, v15
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v8, v8, v14
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v7, v7, v13
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v6, v6, v12
; NOSDWA-NEXT:    v_and_b32_e32 v1, 0xff, v1
; NOSDWA-NEXT:    v_and_b32_e32 v0, 0xff, v0
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v2, 8, v2
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v3, 8, v3
; NOSDWA-NEXT:    v_and_b32_e32 v9, 0xff, v9
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v8, 8, v8
; NOSDWA-NEXT:    v_lshlrev_b16_e32 v7, 8, v7
; NOSDWA-NEXT:    v_and_b32_e32 v6, 0xff, v6
; NOSDWA-NEXT:    v_or_b32_e32 v1, v1, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v9, v3
; NOSDWA-NEXT:    v_or_b32_e32 v0, v0, v8
; NOSDWA-NEXT:    v_or_b32_e32 v3, v6, v7
; NOSDWA-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_or_b32_e32 v1, v1, v2
; NOSDWA-NEXT:    v_or_b32_e32 v0, v0, v3
; NOSDWA-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mul_v8i8:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX89-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v4, s0
; GFX89-NEXT:    v_mov_b32_e32 v5, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v6, v1, v3
; GFX89-NEXT:    v_mul_lo_u16_sdwa v7, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX89-NEXT:    v_mul_lo_u16_sdwa v8, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX89-NEXT:    v_mul_lo_u16_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_lo_u16_e32 v3, v0, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v9, v0, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX89-NEXT:    v_mul_lo_u16_sdwa v10, v0, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX89-NEXT:    v_mul_lo_u16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_or_b32_sdwa v2, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v3, v3, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v0, v0, v10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX89-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mul_v8i8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u16_e32 v5, v1, v3
; GFX9-NEXT:    v_mul_lo_u16_sdwa v6, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NEXT:    v_mul_lo_u16_sdwa v7, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NEXT:    v_mul_lo_u16_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_mul_lo_u16_e32 v3, v0, v2
; GFX9-NEXT:    v_mul_lo_u16_sdwa v8, v0, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NEXT:    v_mul_lo_u16_sdwa v9, v0, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NEXT:    v_mul_lo_u16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_or_b32_sdwa v2, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul_v8i8:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX10-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX10-NEXT:    v_lshrrev_b16 v6, 8, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX10-NEXT:    v_lshrrev_b16 v9, 8, v1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 24, v2
; GFX10-NEXT:    v_lshrrev_b16 v12, 8, v2
; GFX10-NEXT:    v_lshrrev_b16 v13, 8, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v14, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v15, 16, v3
; GFX10-NEXT:    v_mul_lo_u16 v1, v1, v3
; GFX10-NEXT:    v_mul_lo_u16 v0, v0, v2
; GFX10-NEXT:    v_mul_lo_u16 v2, v9, v13
; GFX10-NEXT:    v_mul_lo_u16 v3, v8, v14
; GFX10-NEXT:    v_mul_lo_u16 v6, v6, v12
; GFX10-NEXT:    v_mul_lo_u16 v5, v5, v11
; GFX10-NEXT:    v_mul_lo_u16 v7, v7, v15
; GFX10-NEXT:    v_mul_lo_u16 v4, v4, v10
; GFX10-NEXT:    v_lshlrev_b16 v2, 8, v2
; GFX10-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX10-NEXT:    v_lshlrev_b16 v6, 8, v6
; GFX10-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX10-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v2, v7, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v3, v4, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <8 x i8>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <8 x i8>, ptr addrspace(1) %inb, i32 %idx
  %a = load <8 x i8>, ptr addrspace(1) %gepa, align 4
  %b = load <8 x i8>, ptr addrspace(1) %gepb, align 4
  %mul = mul <8 x i8> %a, %b
  store <8 x i8> %mul, ptr addrspace(1) %out, align 4
  ret void
}

; FIXME: Should be able to avoid or
define amdgpu_kernel void @sitofp_v2i16_to_v2f16(
; NOSDWA-LABEL: sitofp_v2i16_to_v2f16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    flat_load_dword v2, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; NOSDWA-NEXT:    v_cvt_f16_i16_e32 v3, v3
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_cvt_f16_i16_e32 v2, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v3
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: sitofp_v2i16_to_v2f16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    flat_load_dword v2, v[0:1]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_cvt_f16_i16_sdwa v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX89-NEXT:    v_cvt_f16_i16_e32 v2, v2
; GFX89-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: sitofp_v2i16_to_v2f16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cvt_f16_i16_e32 v2, v1
; GFX9-NEXT:    v_cvt_f16_i16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sitofp_v2i16_to_v2f16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f16_i16_e32 v2, v1
; GFX10-NEXT:    v_cvt_f16_i16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX10-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) #0 {
entry:
  %a.val = load <2 x i16>, ptr addrspace(1) %a
  %r.val = sitofp <2 x i16> %a.val to <2 x half>
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @mac_v2half(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mac_v2half:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    flat_load_dword v3, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; NOSDWA-NEXT:    v_mac_f16_e32 v4, v5, v4
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; NOSDWA-NEXT:    v_mac_f16_e32 v2, v3, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v4
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mac_v2half:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v2, s4
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    flat_load_dword v3, v[0:1]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(1)
; GFX89-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mac_f16_sdwa v4, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX89-NEXT:    v_mac_f16_e32 v2, v3, v2
; GFX89-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mac_v2half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_f16 v1, v1, v2
; GFX9-NEXT:    v_pk_add_f16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mac_v2half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_f16 v1, v1, v2
; GFX10-NEXT:    v_pk_add_f16 v1, v1, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load <2 x half>, ptr addrspace(1) %ina, align 4
  %b = load <2 x half>, ptr addrspace(1) %inb, align 4
  %mul = fmul <2 x half> %a, %b
  %mac = fadd <2 x half> %mul, %b
  store <2 x half> %mac, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @immediate_mul_v2i16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; NOSDWA-LABEL: immediate_mul_v2i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    flat_load_dword v2, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, 0x7b, v2
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, 0x141, v2
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v3, v2
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: immediate_mul_v2i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX89-NEXT:    v_mov_b32_e32 v3, 0x141
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    flat_load_dword v2, v[0:1]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_e32 v4, 0x7b, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v2, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX89-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: immediate_mul_v2i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0x141007b
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v0, v0, s2
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: immediate_mul_v2i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v0, 0x141007b, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x i16>, ptr addrspace(1) %in, i32 %idx
  %a = load <2 x i16>, ptr addrspace(1) %gep, align 4
  %mul = mul <2 x i16> %a, <i16 123, i16 321>
  store <2 x i16> %mul, ptr addrspace(1) %out, align 4
  ret void
}

; Double use of same src - should not convert it
define amdgpu_kernel void @mulmul_v2i16(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mulmul_v2i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; NOSDWA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    flat_load_dword v3, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v3, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v5, v5, v4
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v2, v3, v2
; NOSDWA-NEXT:    v_mul_lo_u16_e32 v3, v5, v4
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; NOSDWA-NEXT:    v_or_b32_e32 v2, v2, v3
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mulmul_v2i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX89-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    v_add_u32_e32 v2, vcc, s4, v2
; GFX89-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX89-NEXT:    flat_load_dword v4, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mul_lo_u16_sdwa v3, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_mul_lo_u16_e32 v4, v4, v2
; GFX89-NEXT:    v_mul_lo_u16_e32 v4, v4, v2
; GFX89-NEXT:    v_mul_lo_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX89-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mulmul_v2i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mulmul_v2i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_mul_lo_u16 v0, v1, v2
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_pk_mul_lo_u16 v0, v0, v2
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gepa = getelementptr <2 x i16>, ptr addrspace(1) %ina, i32 %idx
  %gepb = getelementptr <2 x i16>, ptr addrspace(1) %inb, i32 %idx
  %a = load <2 x i16>, ptr addrspace(1) %gepa, align 4
  %b = load <2 x i16>, ptr addrspace(1) %gepb, align 4
  %mul = mul <2 x i16> %a, %b
  %mul2 = mul <2 x i16> %mul, %b
  store <2 x i16> %mul2, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @add_bb_v2i16(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: add_bb_v2i16:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    flat_load_dword v1, v[0:1]
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; NOSDWA-NEXT:    v_add_u32_e32 v1, vcc, v1, v2
; NOSDWA-NEXT:    v_add_u32_e32 v2, vcc, v3, v4
; NOSDWA-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v1, v2
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: add_bb_v2i16:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mov_b32_e32 v2, s4
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    flat_load_dword v1, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_add_u32_sdwa v3, vcc, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_add_u32_e32 v1, vcc, v1, v2
; GFX89-NEXT:    v_or_b32_sdwa v2, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: add_bb_v2i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: add_bb_v2i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_u16 v1, v1, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load <2 x i16>, ptr addrspace(1) %ina, align 4
  %b = load <2 x i16>, ptr addrspace(1) %inb, align 4
  br label %add_label
add_label:
  %add = add <2 x i16> %a, %b
  br label %store_label
store_label:
  store <2 x i16> %add, ptr addrspace(1) %out, align 4
  ret void
}

; Check that "pulling out" SDWA operands works correctly.
define amdgpu_kernel void @pulled_out_test(ptr addrspace(1) %sourceA, ptr addrspace(1) %destValues) #0 {
; NOSDWA-LABEL: pulled_out_test:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s3
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s2
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_readfirstlane_b32 s0, v1
; NOSDWA-NEXT:    v_readfirstlane_b32 s1, v0
; NOSDWA-NEXT:    s_lshr_b32 s3, s1, 24
; NOSDWA-NEXT:    s_lshr_b32 s5, s0, 24
; NOSDWA-NEXT:    s_and_b32 s2, s1, 0xffff
; NOSDWA-NEXT:    s_bfe_u32 s1, s1, 0x80010
; NOSDWA-NEXT:    s_and_b32 s4, s0, 0xffff
; NOSDWA-NEXT:    s_bfe_u32 s0, s0, 0x80010
; NOSDWA-NEXT:    s_lshl_b32 s3, s3, 8
; NOSDWA-NEXT:    s_lshl_b32 s5, s5, 8
; NOSDWA-NEXT:    s_or_b32 s1, s1, s3
; NOSDWA-NEXT:    s_or_b32 s0, s0, s5
; NOSDWA-NEXT:    s_lshl_b32 s1, s1, 16
; NOSDWA-NEXT:    s_lshl_b32 s0, s0, 16
; NOSDWA-NEXT:    s_or_b32 s1, s2, s1
; NOSDWA-NEXT:    s_or_b32 s0, s4, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s1
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s0
; NOSDWA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: pulled_out_test:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX89-NEXT:    v_mov_b32_e32 v3, s3
; GFX89-NEXT:    v_mov_b32_e32 v2, s2
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_readfirstlane_b32 s0, v1
; GFX89-NEXT:    v_readfirstlane_b32 s1, v0
; GFX89-NEXT:    s_lshr_b32 s3, s1, 24
; GFX89-NEXT:    s_lshr_b32 s5, s0, 24
; GFX89-NEXT:    s_and_b32 s2, s1, 0xffff
; GFX89-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX89-NEXT:    s_and_b32 s4, s0, 0xffff
; GFX89-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX89-NEXT:    s_lshl_b32 s3, s3, 8
; GFX89-NEXT:    s_lshl_b32 s5, s5, 8
; GFX89-NEXT:    s_or_b32 s1, s1, s3
; GFX89-NEXT:    s_or_b32 s0, s0, s5
; GFX89-NEXT:    s_lshl_b32 s1, s1, 16
; GFX89-NEXT:    s_lshl_b32 s0, s0, 16
; GFX89-NEXT:    s_or_b32 s1, s2, s1
; GFX89-NEXT:    s_or_b32 s0, s4, s0
; GFX89-NEXT:    v_mov_b32_e32 v0, s1
; GFX89-NEXT:    v_mov_b32_e32 v1, s0
; GFX89-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: pulled_out_test:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    v_readfirstlane_b32 s1, v0
; GFX9-NEXT:    s_lshr_b32 s5, s1, 24
; GFX9-NEXT:    s_lshr_b32 s7, s0, 24
; GFX9-NEXT:    s_and_b32 s4, s1, 0xffff
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_and_b32 s6, s0, 0xffff
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_or_b32 s1, s1, s5
; GFX9-NEXT:    s_or_b32 s0, s0, s7
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s1, s4, s1
; GFX9-NEXT:    s_or_b32 s0, s6, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: pulled_out_test:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    s_lshr_b32 s5, s0, 24
; GFX10-NEXT:    s_lshr_b32 s7, s1, 24
; GFX10-NEXT:    s_and_b32 s4, s0, 0xffff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_and_b32 s6, s1, 0xffff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_or_b32 s0, s0, s5
; GFX10-NEXT:    s_or_b32 s1, s1, s7
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s0, s4, s0
; GFX10-NEXT:    s_or_b32 s1, s6, s1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX10-NEXT:    s_endpgm
entry:
  %idxprom = ashr exact i64 15, 32
  %arrayidx = getelementptr inbounds <8 x i8>, ptr addrspace(1) %sourceA, i64 %idxprom
  %tmp = load <8 x i8>, ptr addrspace(1) %arrayidx, align 8

  %tmp1 = extractelement <8 x i8> %tmp, i32 0
  %tmp2 = extractelement <8 x i8> %tmp, i32 1
  %tmp3 = extractelement <8 x i8> %tmp, i32 2
  %tmp4 = extractelement <8 x i8> %tmp, i32 3
  %tmp5 = extractelement <8 x i8> %tmp, i32 4
  %tmp6 = extractelement <8 x i8> %tmp, i32 5
  %tmp7 = extractelement <8 x i8> %tmp, i32 6
  %tmp8 = extractelement <8 x i8> %tmp, i32 7

  %tmp9 = insertelement <2 x i8> undef, i8 %tmp1, i32 0
  %tmp10 = insertelement <2 x i8> %tmp9, i8 %tmp2, i32 1
  %tmp11 = insertelement <2 x i8> undef, i8 %tmp3, i32 0
  %tmp12 = insertelement <2 x i8> %tmp11, i8 %tmp4, i32 1
  %tmp13 = insertelement <2 x i8> undef, i8 %tmp5, i32 0
  %tmp14 = insertelement <2 x i8> %tmp13, i8 %tmp6, i32 1
  %tmp15 = insertelement <2 x i8> undef, i8 %tmp7, i32 0
  %tmp16 = insertelement <2 x i8> %tmp15, i8 %tmp8, i32 1

  %tmp17 = shufflevector <2 x i8> %tmp10, <2 x i8> %tmp12, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp18 = shufflevector <2 x i8> %tmp14, <2 x i8> %tmp16, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %tmp19 = shufflevector <4 x i8> %tmp17, <4 x i8> %tmp18, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>

  %arrayidx5 = getelementptr inbounds <8 x i8>, ptr addrspace(1) %destValues, i64 %idxprom
  store <8 x i8> %tmp19, ptr addrspace(1) %arrayidx5, align 8
  ret void
}

; TODO: Why is the constant not peepholed into the v_or_b32_e32?
define amdgpu_kernel void @sdwa_crash_inlineasm_def() #0 {
; NOSDWA-LABEL: sdwa_crash_inlineasm_def:
; NOSDWA:       ; %bb.0: ; %bb
; NOSDWA-NEXT:    s_mov_b32 s0, 0xffff
; NOSDWA-NEXT:    ;;#ASMSTART
; NOSDWA-NEXT:    v_and_b32_e32 v0, s0, v0
; NOSDWA-NEXT:    ;;#ASMEND
; NOSDWA-NEXT:    v_or_b32_e32 v0, 0x10000, v0
; NOSDWA-NEXT:    s_and_b64 vcc, exec, -1
; NOSDWA-NEXT:  .LBB21_1: ; %bb1
; NOSDWA-NEXT:    ; =>This Inner Loop Header: Depth=1
; NOSDWA-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    s_mov_b64 vcc, vcc
; NOSDWA-NEXT:    s_cbranch_vccnz .LBB21_1
; NOSDWA-NEXT:  ; %bb.2: ; %DummyReturnBlock
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: sdwa_crash_inlineasm_def:
; GFX89:       ; %bb.0: ; %bb
; GFX89-NEXT:    s_mov_b32 s0, 0xffff
; GFX89-NEXT:    ;;#ASMSTART
; GFX89-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX89-NEXT:    ;;#ASMEND
; GFX89-NEXT:    v_or_b32_e32 v0, 0x10000, v0
; GFX89-NEXT:    s_and_b64 vcc, exec, -1
; GFX89-NEXT:  .LBB21_1: ; %bb1
; GFX89-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX89-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    s_mov_b64 vcc, vcc
; GFX89-NEXT:    s_cbranch_vccnz .LBB21_1
; GFX89-NEXT:  ; %bb.2: ; %DummyReturnBlock
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: sdwa_crash_inlineasm_def:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    v_or_b32_e32 v0, 0x10000, v0
; GFX9-NEXT:    s_and_b64 vcc, exec, -1
; GFX9-NEXT:  .LBB21_1: ; %bb1
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    global_store_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b64 vcc, vcc
; GFX9-NEXT:    s_cbranch_vccnz .LBB21_1
; GFX9-NEXT:  ; %bb.2: ; %DummyReturnBlock
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sdwa_crash_inlineasm_def:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_mov_b32 s0, 0xffff
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    v_or_b32_e32 v0, 0x10000, v0
; GFX10-NEXT:    s_mov_b32 vcc_lo, exec_lo
; GFX10-NEXT:  .LBB21_1: ; %bb1
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_cbranch_vccnz .LBB21_1
; GFX10-NEXT:  ; %bb.2: ; %DummyReturnBlock
; GFX10-NEXT:    s_endpgm
bb:
  br label %bb1

bb1:                                              ; preds = %bb11, %bb
  %tmp = phi <2 x i32> [ %tmp12, %bb11 ], [ undef, %bb ]
  br i1 true, label %bb2, label %bb11

bb2:                                              ; preds = %bb1
  %tmp3 = call i32 asm "v_and_b32_e32 $0, $1, $2", "=v,s,v"(i32 65535, i32 undef) #1
  %tmp5 = or i32 %tmp3, 65536
  %tmp6 = insertelement <2 x i32> %tmp, i32 %tmp5, i64 0
  br label %bb11

bb11:                                             ; preds = %bb10, %bb2
  %tmp12 = phi <2 x i32> [ %tmp6, %bb2 ], [ %tmp, %bb1 ]
  store volatile <2 x i32> %tmp12, ptr addrspace(1) undef
  br label %bb1
}

define void @crash_lshlrevb16_not_reg_op() {
; NOSDWA-LABEL: crash_lshlrevb16_not_reg_op:
; NOSDWA:       ; %bb.0: ; %bb0
; NOSDWA-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; NOSDWA-NEXT:    s_mov_b64 s[4:5], 0
; NOSDWA-NEXT:    s_and_b64 vcc, exec, -1
; NOSDWA-NEXT:  .LBB22_1: ; %bb1
; NOSDWA-NEXT:    ; =>This Inner Loop Header: Depth=1
; NOSDWA-NEXT:    s_lshl_b32 s6, s4, 3
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s4
; NOSDWA-NEXT:    s_lshr_b32 s6, 0x100, s6
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s5
; NOSDWA-NEXT:    s_mov_b64 s[4:5], 1
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s6
; NOSDWA-NEXT:    flat_store_byte v[0:1], v2
; NOSDWA-NEXT:    s_mov_b64 vcc, vcc
; NOSDWA-NEXT:    s_cbranch_vccnz .LBB22_1
; NOSDWA-NEXT:  ; %bb.2: ; %DummyReturnBlock
; NOSDWA-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; NOSDWA-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: crash_lshlrevb16_not_reg_op:
; GFX89:       ; %bb.0: ; %bb0
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    s_mov_b64 s[4:5], 0
; GFX89-NEXT:    s_and_b64 vcc, exec, -1
; GFX89-NEXT:  .LBB22_1: ; %bb1
; GFX89-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX89-NEXT:    s_lshl_b32 s6, s4, 3
; GFX89-NEXT:    v_mov_b32_e32 v0, s4
; GFX89-NEXT:    s_lshr_b32 s6, 0x100, s6
; GFX89-NEXT:    v_mov_b32_e32 v1, s5
; GFX89-NEXT:    s_mov_b64 s[4:5], 1
; GFX89-NEXT:    v_mov_b32_e32 v2, s6
; GFX89-NEXT:    flat_store_byte v[0:1], v2
; GFX89-NEXT:    s_mov_b64 vcc, vcc
; GFX89-NEXT:    s_cbranch_vccnz .LBB22_1
; GFX89-NEXT:  ; %bb.2: ; %DummyReturnBlock
; GFX89-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: crash_lshlrevb16_not_reg_op:
; GFX9:       ; %bb.0: ; %bb0
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    s_and_b64 vcc, exec, -1
; GFX9-NEXT:  .LBB22_1: ; %bb1
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_lshl_b32 s6, s4, 3
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_lshr_b32 s6, 0x100, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_mov_b64 s[4:5], 1
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    flat_store_byte v[0:1], v2
; GFX9-NEXT:    s_mov_b64 vcc, vcc
; GFX9-NEXT:    s_cbranch_vccnz .LBB22_1
; GFX9-NEXT:  ; %bb.2: ; %DummyReturnBlock
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: crash_lshlrevb16_not_reg_op:
; GFX10:       ; %bb.0: ; %bb0
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b64 s[4:5], 0
; GFX10-NEXT:    s_mov_b32 vcc_lo, exec_lo
; GFX10-NEXT:  .LBB22_1: ; %bb1
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_lshl_b32 s6, s4, 3
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    s_lshr_b32 s4, 0x100, s6
; GFX10-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-NEXT:    s_mov_b64 s[4:5], 1
; GFX10-NEXT:    flat_store_byte v[0:1], v2
; GFX10-NEXT:    s_cbranch_vccnz .LBB22_1
; GFX10-NEXT:  ; %bb.2: ; %DummyReturnBlock
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %1 = alloca [2 x i8], align 1, addrspace(5)
  %2 = getelementptr [2 x i8], ptr addrspace(5) %1, i32 0, i32 1
  br label %bb0

bb0:
  store i8 1, ptr addrspace(5) %2, align 1
  br label %bb1

bb1:
  %3 = phi i64 [ 1, %bb1 ], [ 0, %bb0 ]
  %4 = trunc i64 %3 to i32
  %5 = getelementptr i8, ptr addrspace(5) %1, i32 %4
  %6 = load i8, ptr addrspace(5) %5, align 1
  %7 = getelementptr i8, ptr null, i64 %3
  store i8 %6, ptr %7, align 1
  br i1 false, label %bb2, label %bb1

bb2:
  br label %bb0
}

define amdgpu_kernel void @mac_v2half_same_srcop(ptr addrspace(1) %out, ptr addrspace(1) %ina, ptr addrspace(1) %inb) #0 {
; NOSDWA-LABEL: mac_v2half_same_srcop:
; NOSDWA:       ; %bb.0: ; %entry
; NOSDWA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; NOSDWA-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; NOSDWA-NEXT:    s_waitcnt lgkmcnt(0)
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s2
; NOSDWA-NEXT:    v_mov_b32_e32 v2, s4
; NOSDWA-NEXT:    v_mov_b32_e32 v3, s5
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s3
; NOSDWA-NEXT:    flat_load_dword v2, v[2:3]
; NOSDWA-NEXT:    flat_load_dword v3, v[0:1]
; NOSDWA-NEXT:    v_mov_b32_e32 v0, s0
; NOSDWA-NEXT:    v_mov_b32_e32 v1, s1
; NOSDWA-NEXT:    s_waitcnt vmcnt(1)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; NOSDWA-NEXT:    s_waitcnt vmcnt(0)
; NOSDWA-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; NOSDWA-NEXT:    v_mac_f16_e32 v5, v4, v4
; NOSDWA-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; NOSDWA-NEXT:    v_mac_f16_e32 v3, v2, v2
; NOSDWA-NEXT:    v_or_b32_e32 v2, v3, v4
; NOSDWA-NEXT:    flat_store_dword v[0:1], v2
; NOSDWA-NEXT:    s_endpgm
;
; GFX89-LABEL: mac_v2half_same_srcop:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mov_b32_e32 v2, s4
; GFX89-NEXT:    v_mov_b32_e32 v3, s5
; GFX89-NEXT:    flat_load_dword v4, v[0:1]
; GFX89-NEXT:    flat_load_dword v2, v[2:3]
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    v_mov_b32_e32 v1, s1
; GFX89-NEXT:    s_waitcnt vmcnt(1)
; GFX89-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mac_f16_sdwa v3, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX89-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX89-NEXT:    v_mac_f16_e32 v4, v2, v2
; GFX89-NEXT:    v_or_b32_e32 v2, v4, v3
; GFX89-NEXT:    flat_store_dword v[0:1], v2
; GFX89-NEXT:    s_endpgm
;
; GFX9-LABEL: mac_v2half_same_srcop:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_pk_mul_f16 v1, v1, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_add_f16 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mac_v2half_same_srcop:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dword v1, v0, s[6:7]
; GFX10-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    v_pk_mul_f16 v1, v1, v1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v1, v1, v2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
entry:
  %a = load <2 x half>, ptr addrspace(1) %ina, align 4
  %b = load <2 x half>, ptr addrspace(1) %inb, align 4
  %mul = fmul <2 x half> %b, %b
  %mac = fadd <2 x half> %mul, %a
  store <2 x half> %mac, ptr addrspace(1) %out, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()

attributes #0 = { "denormal-fp-math"="preserve-sign,preserve-sign" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; GFX9_10: {{.*}}
; SDWA: {{.*}}
