; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu | FileCheck %s -check-prefixes=CHECK,ALIGN
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu -align-loops=32 | FileCheck %s -check-prefixes=CHECK,ALIGN32
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu -align-loops=256 | FileCheck %s -check-prefixes=CHECK,ALIGN256

; This test is to check if .p2align can be correctly generated by considerring
; 1. -align-loops=N from llc option
; 2. loop metadata node !{!"llvm.loop.align", i32 64}
; The test IR is generated from below simple C file:
; $ clang -S -emit-llvm loop.c
; $ cat loop.c
; void bar(void);
; void var(void);
; void foo(int a) {
;   for (int i = 0; i < a; ++i)
;     bar();
;   for (int i = 0; i < a; ++i)
;     var();
; }
; The difference between test1 and test2 is test2 only set one loop metadata node for the second loop.

; CHECK-LABEL: test1:
; ALIGN: .p2align 6, 0x90
; ALIGN-NEXT: .LBB0_2: # %for.body
; ALIGN: .p2align 9, 0x90
; ALIGN-NEXT: .LBB0_3: # %for.body

; ALIGN32: .p2align 6, 0x90
; ALIGN32-NEXT: .LBB0_2: # %for.body
; ALIGN32: .p2align 9, 0x90
; ALIGN32-NEXT: .LBB0_3: # %for.body

; ALIGN256: .p2align 8, 0x90
; ALIGN256-NEXT: .LBB0_2: # %for.body
; ALIGN256: .p2align 9, 0x90
; ALIGN256-NEXT: .LBB0_3: # %for.body

define void @test1(i32 %a) nounwind {
entry:
  %cmp12 = icmp sgt i32 %a, 0
  br i1 %cmp12, label %for.body, label %for.cond.cleanup4

for.body:                                         ; preds = %entry, %for.body
  %i.013 = phi i32 [ %inc, %for.body ], [ 0, %entry ]
  tail call void @bar()
  %inc = add nuw nsw i32 %i.013, 1
  %exitcond.not = icmp eq i32 %inc, %a
  br i1 %exitcond.not, label %for.body5, label %for.body, !llvm.loop !0

for.cond.cleanup4:                                ; preds = %for.body5, %entry
  ret void

for.body5:                                        ; preds = %for.body, %for.body5
  %i1.015 = phi i32 [ %inc7, %for.body5 ], [ 0, %for.body ]
  tail call void @var()
  %inc7 = add nuw nsw i32 %i1.015, 1
  %exitcond16.not = icmp eq i32 %inc7, %a
  br i1 %exitcond16.not, label %for.cond.cleanup4, label %for.body5, !llvm.loop !2
}

; CHECK-LABEL: test2:
; ALIGN: .p2align 4, 0x90
; ALIGN-NEXT: .LBB1_2: # %for.body
; ALIGN: .p2align 9, 0x90
; ALIGN-NEXT: .LBB1_3: # %for.body

; ALIGN32: .p2align 5, 0x90
; ALIGN32-NEXT: .LBB1_2: # %for.body
; ALIGN32: .p2align 9, 0x90
; ALIGN32-NEXT: .LBB1_3: # %for.body

; ALIGN256: .p2align 8, 0x90
; ALIGN256-NEXT: .LBB1_2: # %for.body
; ALIGN256: .p2align 9, 0x90
; ALIGN256-NEXT: .LBB1_3: # %for.body
define void @test2(i32 %a) nounwind {
entry:
  %cmp12 = icmp sgt i32 %a, 0
  br i1 %cmp12, label %for.body, label %for.cond.cleanup4

for.body:                                         ; preds = %entry, %for.body
  %i.013 = phi i32 [ %inc, %for.body ], [ 0, %entry ]
  tail call void @bar()
  %inc = add nuw nsw i32 %i.013, 1
  %exitcond.not = icmp eq i32 %inc, %a
  br i1 %exitcond.not, label %for.body5, label %for.body

for.cond.cleanup4:                                ; preds = %for.body5, %entry
  ret void

for.body5:                                        ; preds = %for.body, %for.body5
  %i1.015 = phi i32 [ %inc7, %for.body5 ], [ 0, %for.body ]
  tail call void @var()
  %inc7 = add nuw nsw i32 %i1.015, 1
  %exitcond16.not = icmp eq i32 %inc7, %a
  br i1 %exitcond16.not, label %for.cond.cleanup4, label %for.body5, !llvm.loop !2
}

declare void @bar()
declare void @var()

!0 = distinct !{!0, !1}
!1 = !{!"llvm.loop.align", i32 64}
!2 = distinct !{!2, !3}
!3 = !{!"llvm.loop.align", i32 512}
