; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s

;; This used to cause a backend crash about not being able to
;; select ROTL. Make sure if generates the basic ushr/shl.
define <2 x i64> @testcase(ptr %in) {
; CHECK-LABEL: testcase:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    shl v0.2d, v1.2d, #56
; CHECK-NEXT:    usra v0.2d, v1.2d, #8
; CHECK-NEXT:    ret
  %1 = load <2 x i64>, ptr %in
  %2 = lshr <2 x i64> %1, <i64 8, i64 8>
  %3 = shl <2 x i64> %1, <i64 56, i64 56>
  %4 = or <2 x i64> %2, %3
  ret <2 x i64> %4
}

;; This used to cause a miscompile because rot combine
;; doesn't handle negative shift well.
define i5 @pr59898(i5 %x) {
; CHECK-LABEL: pr59898:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ubfx w8, w0, #1, #4
; CHECK-NEXT:    orr w0, w8, w0, lsl #4
; CHECK-NEXT:    ret
  %r1 = call i5 @llvm.fshr.i5(i5 %x, i5 %x, i5 3)
  %r2 = call i5 @llvm.fshl.i5(i5 %r1, i5 %r1, i5 2)
  ret i5 %r2
}

declare i5 @llvm.fshl.i5(i5, i5, i5)
declare i5 @llvm.fshr.i5(i5, i5, i5)
