﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/elasticmapreduce/EMR_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticmapreduce/model/ScalingAction.h>
#include <aws/elasticmapreduce/model/ScalingTrigger.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace EMR
{
namespace Model
{

  /**
   * <p>A scale-in or scale-out rule that defines scaling activity, including the
   * CloudWatch metric alarm that triggers activity, how Amazon EC2 instances are
   * added or removed, and the periodicity of adjustments. The automatic scaling
   * policy for an instance group can comprise one or more automatic scaling
   * rules.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ScalingRule">AWS
   * API Reference</a></p>
   */
  class ScalingRule
  {
  public:
    AWS_EMR_API ScalingRule();
    AWS_EMR_API ScalingRule(Aws::Utils::Json::JsonView jsonValue);
    AWS_EMR_API ScalingRule& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_EMR_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The name used to identify an automatic scaling rule. Rule names must be
     * unique within a scaling policy.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline ScalingRule& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline ScalingRule& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline ScalingRule& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A friendly, more verbose description of the automatic scaling rule.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }
    inline ScalingRule& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline ScalingRule& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline ScalingRule& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The conditions that trigger an automatic scaling activity.</p>
     */
    inline const ScalingAction& GetAction() const{ return m_action; }
    inline bool ActionHasBeenSet() const { return m_actionHasBeenSet; }
    inline void SetAction(const ScalingAction& value) { m_actionHasBeenSet = true; m_action = value; }
    inline void SetAction(ScalingAction&& value) { m_actionHasBeenSet = true; m_action = std::move(value); }
    inline ScalingRule& WithAction(const ScalingAction& value) { SetAction(value); return *this;}
    inline ScalingRule& WithAction(ScalingAction&& value) { SetAction(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The CloudWatch alarm definition that determines when automatic scaling
     * activity is triggered.</p>
     */
    inline const ScalingTrigger& GetTrigger() const{ return m_trigger; }
    inline bool TriggerHasBeenSet() const { return m_triggerHasBeenSet; }
    inline void SetTrigger(const ScalingTrigger& value) { m_triggerHasBeenSet = true; m_trigger = value; }
    inline void SetTrigger(ScalingTrigger&& value) { m_triggerHasBeenSet = true; m_trigger = std::move(value); }
    inline ScalingRule& WithTrigger(const ScalingTrigger& value) { SetTrigger(value); return *this;}
    inline ScalingRule& WithTrigger(ScalingTrigger&& value) { SetTrigger(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    ScalingAction m_action;
    bool m_actionHasBeenSet = false;

    ScalingTrigger m_trigger;
    bool m_triggerHasBeenSet = false;
  };

} // namespace Model
} // namespace EMR
} // namespace Aws
