﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datazone/model/AwsConsoleLinkParameters.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace DataZone
{
namespace Model
{

AwsConsoleLinkParameters::AwsConsoleLinkParameters() : 
    m_uriHasBeenSet(false)
{
}

AwsConsoleLinkParameters::AwsConsoleLinkParameters(JsonView jsonValue)
  : AwsConsoleLinkParameters()
{
  *this = jsonValue;
}

AwsConsoleLinkParameters& AwsConsoleLinkParameters::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("uri"))
  {
    m_uri = jsonValue.GetString("uri");

    m_uriHasBeenSet = true;
  }

  return *this;
}

JsonValue AwsConsoleLinkParameters::Jsonize() const
{
  JsonValue payload;

  if(m_uriHasBeenSet)
  {
   payload.WithString("uri", m_uri);

  }

  return payload;
}

} // namespace Model
} // namespace DataZone
} // namespace Aws
