.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CLOSE" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
CLOSE \- close a cursor

.SH SYNOPSIS
.sp
.nf
CLOSE \fIname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCLOSE\fR frees the resources associated with an open cursor.
After the cursor is closed, no subsequent operations
are allowed on it. A cursor should be closed when it is
no longer needed.
.PP
Every non-holdable open cursor is implicitly closed when a
transaction is terminated by \fBCOMMIT\fR or
\fBROLLBACK\fR. A holdable cursor is implicitly
closed if the transaction that created it aborts via
\fBROLLBACK\fR. If the creating transaction successfully
commits, the holdable
cursor remains open until an explicit \fBCLOSE\fR is
executed, or the client disconnects.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of an open cursor to close.
.SH "NOTES"
.PP
PostgreSQL does not have an explicit
\fBOPEN\fR cursor statement; a cursor is considered
open when it is declared. Use the \fBDECLARE\fR
statement to declare a cursor.
.SH "EXAMPLES"
.PP
Close the cursor liahona:
.sp
.nf
CLOSE liahona;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCLOSE\fR is fully conforming with the SQL standard.
