.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SET SESSION AUTHORIZATION" "" "2009-03-13" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET SESSION AUTHORIZATION \- set the session user identifier and the current user identifier of the current session

.SH SYNOPSIS
.sp
.nf
SET [ SESSION | LOCAL ] SESSION AUTHORIZATION \fIusername\fR
SET [ SESSION | LOCAL ] SESSION AUTHORIZATION DEFAULT
RESET SESSION AUTHORIZATION
.sp
.fi
.SH "DESCRIPTION"
.PP
This command sets the session user identifier and the current user
identifier of the current SQL session to be \fIusername\fR. The user name may be
written as either an identifier or a string literal. Using this
command, it is possible, for example, to temporarily become an
unprivileged user and later switch back to become a superuser.
.PP
The session user identifier is initially set to be the (possibly
authenticated) user name provided by the client. The current user
identifier is normally equal to the session user identifier, but
might change temporarily in the context of SECURITY DEFINER
functions and similar mechanisms. The current user identifier is
relevant for permission checking.
.PP
The session user identifier may be changed only if the initial session
user (the \fIauthenticated user\fR) had the
superuser privilege. Otherwise, the command is accepted only if it
specifies the authenticated user name.
.PP
The SESSION and LOCAL modifiers act the same
as for the regular SET [\fBset\fR(l)]
command.
.PP
The DEFAULT and RESET forms reset the session
and current user identifiers to be the originally authenticated user
name. These forms may be executed by any user.
.SH "NOTES"
.PP
\fBSET SESSION AUTHORIZATION\fR cannot be used within a
SECURITY DEFINER function.
.SH "EXAMPLES"
.sp
.nf
SELECT SESSION_USER, CURRENT_USER;

 session_user | current_user 
--------------+--------------
 peter        | peter

SET SESSION AUTHORIZATION 'paul';

SELECT SESSION_USER, CURRENT_USER;

 session_user | current_user 
--------------+--------------
 paul         | paul
.sp
.fi
.SH "COMPATIBILITY"
.PP
The SQL standard allows some other expressions to appear in place
of the literal \fIusername\fR which are not
important in practice. PostgreSQL
allows identifier syntax ("username"), which SQL
does not. SQL does not allow this command during a transaction;
PostgreSQL does not make this
restriction because there is no reason to. The privileges
necessary to execute this command are left implementation-defined
by the standard.
