.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "PG_RESULT" "" "2008-01-03" "" "PostgreSQL 7.4.19 Documentation"
.SH NAME
pg_result \- get information about a command result

.SH SYNOPSIS
.sp
.nf
pg_result \fIresultHandle\fR \fIresultOption\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBpg_result\fR returns information about a command
result created by a prior \fBpg_exec\fR.
.PP
You can keep a command result around for as long as you need it,
but when you are done with it, be sure to free it by executing
\fBpg_result -clear\fR. Otherwise, you have a
memory leak, and \fBpgtcl\fR will eventually start
complaining that you have created too many command result objects.
.SH "ARGUMENTS"
.TP
\fB\fIresultHandle\fB\fR
The handle of the command result.
.TP
\fB\fIresultOption\fB\fR
One of the following options, specifying which piece of result
information to return:
.RS
.TP
\fB-status\fR
The status of the result.
.TP
\fB-error\fR
The error message, if the status indicates an error,
otherwise an empty string.
.TP
\fB-conn\fR
The connection that produced the result.
.TP
\fB-oid\fR
If the command was an \fBINSERT\fR, the OID of
the inserted row, otherwise 0.
.TP
\fB-numTuples\fR
The number of rows (tuples) returned by the query.
.TP
\fB-cmdTuples\fR
The number of rows (tuples) affected by the command.
.TP
\fB-numAttrs\fR
The number of columns (attributes) in each row.
.TP
\fB-assign \fIarrayName\fB\fR
Assign the results to an array, using subscripts of the form
(rowNumber, columnName).
.TP
\fB-assignbyidx \fIarrayName\fB [\fIappendstr\fB]\fR
Assign the results to an array using the values of the
first column and the names of the remaining column as keys.
If \fIappendstr\fR is given then it is appended to
each key. In short, all but the first column of each row
are stored into the array, using subscripts of the form
(firstColumnValue, columnNameAppendStr).
.TP
\fB-getTuple \fIrowNumber\fB\fR
Returns the columns of the indicated row in a list. Row
numbers start at zero.
.TP
\fB-tupleArray \fIrowNumber\fB \fIarrayName\fB\fR
Stores the columns of the row in array
\fIarrayName\fR, indexed by column names.
Row numbers start at zero.
.TP
\fB-attributes\fR
Returns a list of the names of the columns in the result.
.TP
\fB-lAttributes\fR
Returns a list of sublists, {name typeOid
typeSize} for each column.
.TP
\fB-clear\fR
Clear the command result object.
.RE
.PP
.SH "RETURN VALUE"
.PP
The result depends on the selected option, as described above.
