@php
	$o = $server->fetch(Crypt::decryptString($dn))
@endphp
<div class="modal-header bg-dark text-white">
	<h1 class="modal-title fs-5">Check Passwords for {{ $o->getDN() }}</h1>
</div>

<div class="modal-body">
	<table class="table table-bordered p-1">
		@foreach(($up=$o->getObject('userpassword'))->values->dot() as $dotkey => $value)
			<tr>
				<th>Check</th>
				<td>{{ $up->render_item_old($dotkey) }}</td>
				<td>
					<input type="password" style="width: 90%" name="password[{{ $dotkey }}]" data-dotkey="{{ $dotkey }}"> <i class="fas fa-fw fa-lock"></i>

					<div class="invalid-feedback pb-2">
						@lang('Invalid Password')
					</div>
				</td>
			</tr>
		@endforeach
	</table>
</div>

<div class="modal-footer">
	<x-modal.close/>
	<button id="userpassword_check-submit" type="button" class="btn btn-sm btn-primary"><i class="fas fa-fw fa-spinner fa-spin d-none"></i> @lang('Check')</button>
</div>

<script type="text/javascript">
	$('button[id=userpassword_check-submit]').on('click',function(item) {
		var that = $(this);

		var passwords = $('#page-modal input[name^="password["')
			.map((index,item) => {
				return {'key': $(item).data('dotkey'), 'value': $(item).val()};
			});

		if (passwords.length === 0)
			return false;

		$.ajax({
			method: 'POST',
			url: '{{ url('entry/password/check') }}',
			data: {
				dn: dn,
				password: Array.from(passwords),
			},
			dataType: 'json',
			cache: false,
			beforeSend: function() {
				// Disable submit, add spinning icon
				that.prop('disabled',true);
				that.find('i').removeClass('d-none');
			},
			complete: function() {
				that.prop('disabled',false);
				that.find('i').addClass('d-none');
			},

		}).done(function(data) {
			Object.keys(data).forEach(function(key) {
				var password = $('#page-modal input[name="password['+key+']');

				var i = password
					.siblings('i');

				var feedback = password
					.siblings('div.invalid-feedback');

				if (data[key] === 'OK') {
					i.removeClass('text-danger')
						.addClass('text-success')
						.removeClass('fa-lock')
						.addClass('fa-lock-open');

					if (feedback.is(':visible'))
						feedback.hide();

				} else {
					i.removeClass('text-success')
						.addClass('text-danger')
						.removeClass('fa-lock-open')
						.addClass('fa-lock');

					if (! feedback.is(':visible'))
						feedback.show();
				}
			})

		}).fail(ajax_error);
	});
</script>