// This file implements the IRelatedItem Interface and Gateway for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIRelatedItem.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIRelatedItem::PyIRelatedItem(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIRelatedItem::~PyIRelatedItem() {}

/* static */ IRelatedItem *PyIRelatedItem::GetI(PyObject *self) { return (IRelatedItem *)PyIUnknown::GetI(self); }

// @pymethod <o PyIDL>|PyIRelatedItem|GetItemIDList|Returns the ID list of the related item
PyObject *PyIRelatedItem::GetItemIDList(PyObject *self, PyObject *args)
{
    IRelatedItem *pIRI = GetI(self);
    if (pIRI == NULL)
        return NULL;
    PIDLIST_ABSOLUTE pidl;
    PyObject *obppidl;
    if (!PyArg_ParseTuple(args, ":GetItemIDList", &obppidl))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIRI->GetItemIDList(&pidl);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIRI, IID_IRelatedItem);
    return PyObject_FromPIDL(pidl, TRUE);
}

// @pymethod <o PyIShellItem>|PyIRelatedItem|GetItem|Returns the related item
PyObject *PyIRelatedItem::GetItem(PyObject *self, PyObject *args)
{
    IRelatedItem *pIRI = GetI(self);
    if (pIRI == NULL)
        return NULL;
    IShellItem *ppsi;
    if (!PyArg_ParseTuple(args, ":GetItem"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIRI->GetItem(&ppsi);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIRI, IID_IRelatedItem);
    return PyCom_PyObjectFromIUnknown(ppsi, IID_IShellItem, FALSE);
}

// @object PyIRelatedItem|Interface used as the base for objects that have a related shell item
// (eg ITransferMediumItem, IDisplayItem, etc).  Should not be used directly.
static struct PyMethodDef PyIRelatedItem_methods[] = {
    {"GetItemIDList", PyIRelatedItem::GetItemIDList,
     1},                                      // @pymeth GetItemIDList|Returns the ID list of the related item
    {"GetItem", PyIRelatedItem::GetItem, 1},  // @pymeth GetItem|Returns the related item
    {NULL}};

PyComTypeObject PyIRelatedItem::type("PyIRelatedItem", &PyIUnknown::type, sizeof(PyIRelatedItem),
                                     PyIRelatedItem_methods, GET_PYCOM_CTOR(PyIRelatedItem));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGRelatedItem::GetItemIDList(
    /* [out] */ PIDLIST_ABSOLUTE *ppidl)
{
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetItemIDList", &result);
    if (FAILED(hr))
        return hr;
    if (!PyObject_AsPIDL(result, ppidl, FALSE))
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetItemIDList");
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGRelatedItem::GetItem(
    /* [out] */ IShellItem **ppsi)
{
    PY_GATEWAY_METHOD;
    if (ppsi == NULL)
        return E_POINTER;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetItem", &result);
    if (FAILED(hr))
        return hr;
    // Process the Python results, and convert back to the real params
    if (!PyCom_InterfaceFromPyInstanceOrObject(result, IID_IShellItem, (void **)ppsi, FALSE))
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetItem");
    Py_DECREF(result);
    return hr;
}
