# デプロイ { #deployment }

**FastAPI** アプリケーションのデプロイは比較的簡単です。

## デプロイとは { #what-does-deployment-mean }

アプリケーションを**デプロイ**するとは、**ユーザーが利用できるようにする**ために必要な手順を実行することを意味します。

**Web API** の場合、通常は **リモートマシン** 上に配置し、優れたパフォーマンス、安定性などを提供する **サーバープログラム** と組み合わせて、**ユーザー** が中断や問題なく効率的にアプリケーションへ**アクセス**できるようにします。

これは **開発** 段階とは対照的です。開発では、コードを常に変更し、壊しては直し、開発サーバーを停止したり再起動したりします。

## デプロイ戦略 { #deployment-strategies }

具体的なユースケースや使用するツールによって、いくつかの方法があります。

複数のツールを組み合わせて自分で**サーバーをデプロイ**することもできますし、作業の一部を代行してくれる **クラウドサービス** を使うこともできます。ほかにも選択肢があります。

たとえば、FastAPI の開発チームである私たちは、クラウドへの FastAPI アプリのデプロイを可能な限り合理化し、FastAPI を使って開発するのと同じ開発者体験を提供するために、<a href="https://fastapicloud.com" class="external-link" target="_blank">**FastAPI Cloud**</a> を構築しました。

**FastAPI** アプリケーションをデプロイする際に、おそらく念頭に置くべき主要な概念をいくつか紹介します（ただし、そのほとんどは他の種類の Web アプリケーションにも当てはまります）。

次のセクションでは、留意すべき点の詳細や、それを実現するためのいくつかの手法を確認します。 ✨
