# Функціональні можливості

## Функціональні можливості FastAPI

**FastAPI** надає вам такі можливості:

### Використання відкритих стандартів

* <a href="https://github.com/OAI/OpenAPI-Specification" class="external-link" target="_blank"><strong>OpenAPI</strong></a> для створення API, включаючи оголошення <abbr title="також відомі як: endpoints, маршрути">шляхів</abbr>, <abbr title="також відомі як HTTP-методи, наприклад, POST, GET, PUT, DELETE">операцій</abbr>, параметрів, тіл запитів, безпеки тощо.
* Автоматична документація моделей даних за допомогою <a href="https://json-schema.org/" class="external-link" target="_blank"><strong>JSON Schema</strong></a> (оскільки OpenAPI базується саме на JSON Schema).
* Розроблено на основі цих стандартів після ретельного аналізу, а не як додатковий рівень поверх основної архітектури.
* Це також дає змогу автоматично **генерувати код клієнта** багатьма мовами.

### Автоматична генерація документації

Інтерактивна документація API та вебінтерфейс для його дослідження. Оскільки фреймворк базується на OpenAPI, є кілька варіантів, два з яких включені за замовчуванням.

* <a href="https://github.com/swagger-api/swagger-ui" class="external-link" target="_blank"><strong>Swagger UI</strong></a> — дозволяє інтерактивно переглядати API, викликати та тестувати його прямо у браузері.

![Swagger UI interaction](https://fastapi.tiangolo.com/img/index/index-03-swagger-02.png)

* Альтернативна документація API за допомогою <a href="https://github.com/Rebilly/ReDoc" class="external-link" target="_blank"><strong>ReDoc</strong></a>.

![ReDoc](https://fastapi.tiangolo.com/img/index/index-06-redoc-02.png)

### Тільки сучасний Python

FastAPI використовує стандартні **типи Python** (завдяки Pydantic). Вам не потрібно вивчати новий синтаксис — лише стандартний сучасний Python.

Якщо вам потрібне коротке нагадування про використання типів у Python (навіть якщо ви не використовуєте FastAPI), перегляньте короткий підручник: [Вступ до типів Python](python-types.md){.internal-link target=_blank}.

Ось приклад стандартного Python-коду з типами:

```Python
from datetime import date
from pydantic import BaseModel

# Оголошення змінної як str
# з підтримкою автодоповнення у редакторі
def main(user_id: str):
    return user_id

# Модель Pydantic
class User(BaseModel):
    id: int
    name: str
    joined: date
```

Приклад використання цієї моделі:

```Python
my_user: User = User(id=3, name="John Doe", joined="2018-07-19")

second_user_data = {
    "id": 4,
    "name": "Mary",
    "joined": "2018-11-30",
}

my_second_user: User = User(**second_user_data)
```

/// info | Інформація

`**second_user_data` означає:

Передати ключі та значення словника `second_user_data` як аргументи у вигляді "ключ-значення", еквівалентно `User(id=4, name="Mary", joined="2018-11-30")`.

///

### Підтримка редакторів (IDE)

Фреймворк спроєктований так, щоб бути легким і інтуїтивно зрозумілим. Усі рішення тестувалися у різних редакторах ще до початку розробки, щоб забезпечити найкращий досвід програмування.

За результатами опитувань розробників Python <a href="https://www.jetbrains.com/research/python-developers-survey-2017/#tools-and-features" class="external-link" target="_blank">однією з найпопулярніших функцій є "автодоповнення"</a>.

**FastAPI** повністю підтримує автодоповнення у всіх місцях, тому вам рідко доведеться повертатися до документації.

Приклад автодоповнення у редакторах:

* у <a href="https://code.visualstudio.com/" class="external-link" target="_blank">Visual Studio Code</a>:

![editor support](https://fastapi.tiangolo.com/img/vscode-completion.png)

* у <a href="https://www.jetbrains.com/pycharm/" class="external-link" target="_blank">PyCharm</a>:

![editor support](https://fastapi.tiangolo.com/img/pycharm-completion.png)

### Короткий код
FastAPI має розумні налаштування **за замовчуванням**, але всі параметри можна налаштовувати відповідно до ваших потреб. Однак за замовчуванням все "просто працює".

### Валідація
* Підтримка валідації для більшості (або всіх?) **типів даних Python**, зокрема:
    * JSON-об'єктів (`dict`).
    * JSON-списків (`list`) з визначенням типів елементів.
    * Рядків (`str`) із мінімальною та максимальною довжиною.
    * Чисел (`int`, `float`) з обмеженнями мінімальних та максимальних значень тощо.

* Валідація складніших типів, таких як:
    * URL.
    * Email.
    * UUID.
    * ...та інші.

Уся валідація виконується через надійний та перевірений **Pydantic**.

### Безпека та автентифікація

**FastAPI** підтримує вбудовану автентифікацію та авторизацію, без прив’язки до конкретних баз даних чи моделей даних.

Підтримуються всі схеми безпеки OpenAPI, включаючи:

* HTTP Basic.
* **OAuth2** (також із підтримкою **JWT-токенів**). Див. підручник: [OAuth2 із JWT](tutorial/security/oauth2-jwt.md){.internal-link target=_blank}.
* Ключі API в:
    * Заголовках.
    * Параметрах запиту.
    * Cookies тощо.

А також усі можливості безпеки від Starlette (зокрема **сесійні cookies**).

Усі вони створені як багаторазові інструменти та компоненти, які легко інтегруються з вашими системами, сховищами даних, реляційними та NoSQL базами даних тощо.

### Впровадження залежностей

**FastAPI** містить надзвичайно просту у використанні, але потужну систему впровадження залежностей.

* Залежності можуть мати власні залежності, утворюючи ієрархію або **"граф залежностей"**.
* Усі залежності автоматично керуються фреймворком.
* Усі залежності можуть отримувати дані з запитів і розширювати **обмеження операції за шляхом** та автоматичну документацію.
* **Автоматична валідація** навіть для параметрів *операцій шляху*, визначених у залежностях.
* Підтримка складних систем автентифікації користувачів, **з'єднань із базами даних** тощо.
* **Жодних обмежень** щодо використання баз даних, фронтендів тощо, але водночас проста інтеграція з усіма ними.

### Немає обмежень на "плагіни"

Або іншими словами, вони не потрібні – просто імпортуйте та використовуйте необхідний код.

Будь-яка інтеграція спроєктована настільки просто (з використанням залежностей), що ви можете створити "плагін" для свого застосунку всього у 2 рядках коду, використовуючи ту саму структуру та синтаксис, що й для ваших *операцій шляху*.

### Протестовано

* 100% <abbr title="Обсяг коду, що автоматично тестується">покриття тестами</abbr>.
* 100% <abbr title="Анотації типів у Python, завдяки яким ваш редактор і зовнішні інструменти можуть надавати кращу підтримку">анотована типами</abbr> кодова база.
* Використовується у робочих середовищах.

## Можливості Starlette

**FastAPI** повністю сумісний із (та побудований на основі) <a href="https://www.starlette.io/" class="external-link" target="_blank"><strong>Starlette</strong></a>. Тому будь-який додатковий код Starlette, який ви маєте, також працюватиме.

**FastAPI** фактично є підкласом **Starlette**. Тому, якщо ви вже знайомі зі Starlette або використовуєте його, більшість функціональності працюватиме так само.

З **FastAPI** ви отримуєте всі можливості **Starlette** (адже FastAPI — це, по суті, Starlette на стероїдах):

* Разюча продуктивність. Це <a href="https://github.com/encode/starlette#performance" class="external-link" target="_blank">один із найшвидших фреймворків на Python</a>, на рівні з **NodeJS** і **Go**.
* Підтримка **WebSocket**.
* Фонові задачі у процесі.
* Події запуску та завершення роботи.
* Клієнт для тестування, побудований на HTTPX.
* Підтримка **CORS**, **GZip**, статичних файлів, потокових відповідей.
* Підтримка **сесій** і **cookie**.
* 100% покриття тестами.
* 100% анотована типами кодова база.

## Можливості Pydantic

**FastAPI** повністю сумісний із (та побудований на основі) <a href="https://docs.pydantic.dev/" class="external-link" target="_blank"><strong>Pydantic</strong></a>. Тому будь-який додатковий код Pydantic, який ви маєте, також працюватиме.

Включаючи зовнішні бібліотеки, побудовані також на Pydantic, такі як <abbr title="Object-Relational Mapper">ORM</abbr>, <abbr title="Object-Document Mapper">ODM</abbr> для баз даних.

Це також означає, що в багатьох випадках ви можете передати той самий об'єкт, який отримуєте з запиту, **безпосередньо в базу даних**, оскільки все автоматично перевіряється.

Те ж саме відбувається й у зворотному напрямку — у багатьох випадках ви можете просто передати об'єкт, який отримуєте з бази даних, **безпосередньо клієнту**.

З **FastAPI** ви отримуєте всі можливості **Pydantic** (адже FastAPI базується на Pydantic для обробки всіх даних):

* **Ніякої плутанини** :
    * Не потрібно вчити нову мову для визначення схем.
    * Якщо ви знаєте типи Python, ви знаєте, як використовувати Pydantic.
* Легко працює з вашим **<abbr title="Інтегроване середовище розробки, схоже на редактор коду">IDE</abbr>/<abbr title="Програма, яка перевіряє помилки в коді">лінтером</abbr>/мозком**:
    * Оскільки структури даних Pydantic є просто екземплярами класів, які ви визначаєте; автодоповнення, лінтинг, mypy і ваша інтуїція повинні добре працювати з вашими перевіреними даними.
* Валідація **складних структур**:
    * Використання ієрархічних моделей Pydantic. Python `typing`, `List` і `Dict` тощо.
    * Валідатори дозволяють чітко і просто визначати, перевіряти й документувати складні схеми даних у вигляді JSON-схеми.
    * Ви можете мати глибоко **вкладені JSON об'єкти** та перевірити та анотувати їх всі.
* **Розширюваність**:
    * Pydantic дозволяє визначати користувацькі типи даних або розширювати валідацію методами в моделі декоратором `validator`.
* 100% покриття тестами.
