# HTTP коды статуса ответа

Вы можете задать HTTP код статуса ответа с помощью параметра `status_code` подобно тому, как вы определяете схему ответа в любой из *операций пути*:

* `@app.get()`
* `@app.post()`
* `@app.put()`
* `@app.delete()`
* и других.

```Python hl_lines="6"
{!../../../docs_src/response_status_code/tutorial001.py!}
```

/// note | "Примечание"

Обратите внимание, что `status_code` является атрибутом метода-декоратора (`get`, `post` и т.д.), а не *функции-обработчика пути* в отличие от всех остальных параметров и тела запроса.

///

Параметр `status_code` принимает число, обозначающее HTTP код статуса ответа.

/// info | "Информация"

В качестве значения параметра `status_code` также может использоваться `IntEnum`, например, из библиотеки <a href="https://docs.python.org/3/library/http.html#http.HTTPStatus" class="external-link" target="_blank">`http.HTTPStatus`</a> в Python.

///

Это позволит:

* Возвращать указанный код статуса в ответе.
* Документировать его как код статуса ответа в OpenAPI схеме (а значит, и в пользовательском интерфейсе):

<img src="/img/tutorial/response-status-code/image01.png">

/// note | "Примечание"

Некоторые коды статуса ответа (см. следующий раздел) указывают на то, что ответ не имеет тела.

FastAPI знает об этом и создаст документацию OpenAPI, в которой будет указано, что тело ответа отсутствует.

///

## Об HTTP кодах статуса ответа

/// note | "Примечание"

Если вы уже знаете, что представляют собой HTTP коды статуса ответа, можете перейти к следующему разделу.

///

В протоколе HTTP числовой код состояния из 3 цифр отправляется как часть ответа.

У кодов статуса есть названия, чтобы упростить их распознавание, но важны именно числовые значения.

Кратко о значениях кодов:

* `1XX` – статус-коды информационного типа. Они редко используются разработчиками напрямую. Ответы с этими кодами не могут иметь тела.
* **`2XX`** – статус-коды, сообщающие об успешной обработке запроса. Они используются чаще всего.
    * `200` – это код статуса ответа по умолчанию, который означает, что все прошло "OK".
    * Другим примером может быть статус `201`, "Created". Он обычно используется после создания новой записи в базе данных.
    * Особый случай – `204`, "No Content".  Этот статус ответа используется, когда нет содержимого для возврата клиенту, и поэтому ответ не должен иметь тела.
* **`3XX`** – статус-коды, сообщающие о перенаправлениях.  Ответы с этими кодами статуса могут иметь или не иметь тело, за исключением ответов со статусом `304`, "Not Modified", у которых не должно быть тела.
* **`4XX`** – статус-коды, сообщающие о клиентской ошибке. Это ещё одна наиболее часто используемая категория.
    * Пример – код `404` для статуса "Not Found".
    * Для общих ошибок со стороны клиента можно просто использовать код `400`.
* `5XX` – статус-коды, сообщающие о серверной ошибке. Они почти никогда не используются разработчиками напрямую. Когда что-то идет не так в какой-то части кода вашего приложения или на сервере, он автоматически вернёт один из 5XX кодов.

/// tip | "Подсказка"

Чтобы узнать больше о HTTP кодах статуса и о том, для чего каждый из них предназначен, ознакомьтесь с <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Status" class="external-link" target="_blank">документацией <abbr title="Mozilla Developer Network">MDN</abbr> об HTTP кодах статуса ответа</a>.

///

## Краткие обозначения для запоминания названий кодов

Рассмотрим предыдущий пример еще раз:

```Python hl_lines="6"
{!../../../docs_src/response_status_code/tutorial001.py!}
```

`201` – это код статуса "Создано".

Но вам не обязательно запоминать, что означает каждый из этих кодов.

Для удобства вы можете использовать переменные из `fastapi.status`.

```Python hl_lines="1  6"
{!../../../docs_src/response_status_code/tutorial002.py!}
```

Они содержат те же числовые значения, но позволяют использовать подсказки редактора для выбора кода статуса:

<img src="/img/tutorial/response-status-code/image02.png">

/// note | "Технические детали"

Вы также можете использовать `from starlette import status` вместо `from fastapi import status`.

**FastAPI** позволяет использовать как `starlette.status`, так и `fastapi.status` исключительно для удобства разработчиков. Но поставляется fastapi.status непосредственно из Starlette.

///

## Изменение кода статуса по умолчанию

Позже, в [Руководстве для продвинутых пользователей](../advanced/response-change-status-code.md){.internal-link target=_blank}, вы узнаете, как возвращать HTTP коды статуса, отличные от используемого здесь кода статуса по умолчанию.
