# Зависимости в декораторах операции пути

В некоторых случаях, возвращаемое значение зависимости не используется внутри *функции операции пути*.

Или же зависимость не возвращает никакого значения.

Но вам всё-таки нужно, чтобы она выполнилась.

Для таких ситуаций, вместо объявления *функции операции пути* с параметром `Depends`, вы можете добавить список зависимостей `dependencies` в *декоратор операции пути*.

## Добавление `dependencies` в *декоратор операции пути*

*Декоратор операции пути* получает необязательный аргумент `dependencies`.

Это должен быть `list` состоящий из `Depends()`:

=== "Python 3.9+"

    ```Python hl_lines="19"
    {!> ../../../docs_src/dependencies/tutorial006_an_py39.py!}
    ```

=== "Python 3.8+"

    ```Python hl_lines="18"
    {!> ../../../docs_src/dependencies/tutorial006_an.py!}
    ```

=== "Python 3.8 без Annotated"

    !!! Подсказка
        Рекомендуется использовать версию с Annotated, если возможно.

    ```Python hl_lines="17"
    {!> ../../../docs_src/dependencies/tutorial006.py!}
    ```

Зависимости из dependencies выполнятся так же, как и обычные зависимости. Но их значения (если они были) не будут переданы в *функцию операции пути*.

!!! Подсказка
    Некоторые редакторы кода определяют неиспользуемые параметры функций и подсвечивают их как ошибку.

    Использование `dependencies` в *декораторе операции пути* гарантирует выполнение зависимостей, избегая при этом предупреждений редактора кода и других инструментов.

    Это также должно помочь предотвратить путаницу у начинающих разработчиков, которые видят неиспользуемые параметры в коде и могут подумать что в них нет необходимости.

!!! Дополнительная информация
    В этом примере мы используем выдуманные пользовательские заголовки `X-Key` и `X-Token`.

    Но в реальных проектах, при внедрении системы безопасности, вы получите больше пользы используя интегрированные [средства защиты (следующая глава)](../security/index.md){.internal-link target=_blank}.

## Исключения в dependencies и возвращаемые значения

Вы можете использовать те же *функции* зависимостей, что и обычно.

### Требования к зависимостям

Они могут объявлять требования к запросу (например заголовки) или другие подзависимости:

=== "Python 3.9+"

    ```Python hl_lines="8  13"
    {!> ../../../docs_src/dependencies/tutorial006_an_py39.py!}
    ```

=== "Python 3.8+"

    ```Python hl_lines="7  12"
    {!> ../../../docs_src/dependencies/tutorial006_an.py!}
    ```

=== "Python 3.8 без Annotated"

    !!! Подсказка
        Рекомендуется использовать версию с Annotated, если возможно.

    ```Python hl_lines="6  11"
    {!> ../../../docs_src/dependencies/tutorial006.py!}
    ```

### Вызов исключений

Зависимости из dependencies могут вызывать исключения с помощью `raise`, как и обычные зависимости:

=== "Python 3.9+"

    ```Python hl_lines="10  15"
    {!> ../../../docs_src/dependencies/tutorial006_an_py39.py!}
    ```

=== "Python 3.8+"

    ```Python hl_lines="9  14"
    {!> ../../../docs_src/dependencies/tutorial006_an.py!}
    ```

=== "Python 3.8 без Annotated"

    !!! Подсказка
        Рекомендуется использовать версию с Annotated, если возможно.

    ```Python hl_lines="8  13"
    {!> ../../../docs_src/dependencies/tutorial006.py!}
    ```

### Возвращаемые значения

И они могут возвращать значения или нет, эти значения использоваться не будут.

Таким образом, вы можете переиспользовать обычную зависимость (возвращающую значение), которую вы уже используете где-то в другом месте, и хотя значение не будет использоваться, зависимость будет выполнена:

=== "Python 3.9+"

    ```Python hl_lines="11  16"
    {!> ../../../docs_src/dependencies/tutorial006_an_py39.py!}
    ```

=== "Python 3.8+"

    ```Python hl_lines="10  15"
    {!> ../../../docs_src/dependencies/tutorial006_an.py!}
    ```

=== "Python 3.8 без Annotated"

    !!! Подсказка
        Рекомендуется использовать версию с Annotated, если возможно.

    ```Python hl_lines="9  14"
    {!> ../../../docs_src/dependencies/tutorial006.py!}
    ```

## Dependencies для группы *операций путей*

Позже, читая о том как структурировать большие приложения ([Bigger Applications - Multiple Files](../../tutorial/bigger-applications.md){.internal-link target=_blank}), возможно, многофайловые, вы узнаете как объявить единый параметр `dependencies` для всей группы *операций путей*.

## Глобальный Dependencies

Далее мы увидим, как можно добавить dependencies для всего `FastAPI` приложения, так чтобы они применялись к каждой *операции пути*.
