/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

import jdk.Exported;

@Exported
public class SocketFlow {
    public static final int UNSET = -1;
    public static final int NORMAL_PRIORITY = 1;
    public static final int HIGH_PRIORITY = 2;
    private static final int NO_STATUS_VALUE = 0;
    private static final int OK_VALUE = 1;
    private static final int NO_PERMISSION_VALUE = 2;
    private static final int NOT_CONNECTED_VALUE = 3;
    private static final int NOT_SUPPORTED_VALUE = 4;
    private static final int ALREADY_CREATED_VALUE = 5;
    private static final int IN_PROGRESS_VALUE = 6;
    private static final int OTHER_VALUE = 7;
    private int priority = 1;
    private long bandwidth = -1L;
    private Status status = Status.NO_STATUS;

    private SocketFlow() {
    }

    public static SocketFlow create() {
        return new SocketFlow();
    }

    public SocketFlow priority(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid priority");
        }
        this.priority = n;
        return this;
    }

    public SocketFlow bandwidth(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid bandwidth");
        }
        this.bandwidth = l;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public long bandwidth() {
        return this.bandwidth;
    }

    public Status status() {
        return this.status;
    }

    void status(int n) {
        this.status = Status.from(n);
    }

    @Exported
    public static enum Status {
        NO_STATUS(0),
        OK(1),
        NO_PERMISSION(2),
        NOT_CONNECTED(3),
        NOT_SUPPORTED(4),
        ALREADY_CREATED(5),
        IN_PROGRESS(6),
        OTHER(7);

        private final int value;

        private Status(int n2) {
            this.value = n2;
        }

        static Status from(int n) {
            if (n == Status.NO_STATUS.value) {
                return NO_STATUS;
            }
            if (n == Status.OK.value) {
                return OK;
            }
            if (n == Status.NO_PERMISSION.value) {
                return NO_PERMISSION;
            }
            if (n == Status.NOT_CONNECTED.value) {
                return NOT_CONNECTED;
            }
            if (n == Status.NOT_SUPPORTED.value) {
                return NOT_SUPPORTED;
            }
            if (n == Status.ALREADY_CREATED.value) {
                return ALREADY_CREATED;
            }
            if (n == Status.IN_PROGRESS.value) {
                return IN_PROGRESS;
            }
            if (n == Status.OTHER.value) {
                return OTHER;
            }
            throw new InternalError("Unknown value: " + n);
        }
    }
}

