/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.EncapsulatedContentInfo;
import iaik.cms.SecurityProvider;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.utils.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;

public class SignedData
extends SignedDataStream
implements Content {
    private EncapsulatedContentInfo a;
    byte[] b;

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        AlgorithmID[] algorithmIDArray = ((SignedDataStream)this).a.a();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("DigestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.a != null) {
            Utils.printIndented(this.a.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        if (this.certSet_ != null && !this.certSet_.isEmpty()) {
            stringBuffer.append(this.certSet_);
        }
        if (this.crls_ != null && !this.crls_.isEmpty()) {
            stringBuffer.append(this.crls_);
        }
        stringBuffer.append("SignerInfos: " + this.signerInfos_.size() + "\n");
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("SignerInfo " + n2 + ": {\n");
                Utils.printIndented(((SignerInfo)enumeration.nextElement()).toString(true), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    protected ASN1Object toASN1Object(int n2) throws CMSException {
        if (n2 < 0) {
            n2 = this.blockSize_;
        }
        if (this.mode_ == 1 && this.b != null) {
            this.a = new EncapsulatedContentInfo(this.b, this.contentType_);
            this.a.setBlockSize(n2);
        } else {
            this.a = new EncapsulatedContentInfo(this.contentType_);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
            sEQUENCE.addComponent(ASN.createSetOf((ASN1Type[])((SignedDataStream)this).a.a()));
            sEQUENCE.addComponent(this.a.toASN1Object());
            if (this.certSet_ != null && !this.certSet_.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.certSet_.toASN1Object(), true));
            }
            if (this.crls_ != null && !this.crls_.isEmpty()) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, this.crls_.toASN1Object(), true));
            }
            sEQUENCE.addComponent(ASN.createSetOf((Vector)this.signerInfos_));
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return sEQUENCE;
    }

    private void a() throws NoSuchAlgorithmException {
        ((SignedDataStream)this).a.a(this.b, true);
    }

    public void setInputStream(InputStream inputStream) {
        super.setInputStream(inputStream);
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Utils.copyStream(this.inputStream_, byteArrayOutputStream, null);
                this.b = byteArrayOutputStream.toByteArray();
                return;
            }
            catch (Exception exception) {
                throw new InternalErrorException("Error reading from stream!", exception);
            }
        }
    }

    public void setContent(byte[] byArray) {
        this.b = byArray;
        try {
            ((SignedDataStream)this).a.a(byArray, true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public InputStream getInputStream() {
        if (this.b == null) {
            return null;
        }
        return new ByteArrayInputStream(this.b);
    }

    public byte[] getEncoded() throws CMSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        return this.b;
    }

    public void decode(InputStream inputStream) throws CMSParsingException, IOException {
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_signedData)) {
                throw new CMSParsingException("Content type not SignedData!");
            }
            this.thisObject_ = derInputStream.readContextSpecific().readSequence();
        } else {
            this.thisObject_ = derInputStream;
        }
        this.version_ = this.thisObject_.readInteger().intValue();
        try {
            ((SignedDataStream)this).a.a((AlgorithmID[])ASN.parseSequenceOf((ASN1Object)DerCoder.decode((InputStream)this.thisObject_), (Class)(SignedDataStream.c != null ? SignedDataStream.c : (SignedDataStream.c = SignedDataStream.a("iaik.asn1.structures.AlgorithmID")))));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms!");
        }
        this.a = new EncapsulatedContentInfo((InputStream)this.thisObject_);
        this.contentType_ = this.a.getContentType();
        if (!this.a.hasContent()) {
            this.mode_ = 2;
            this.notifyEOF();
            return;
        }
        this.b = this.a.getContent();
        try {
            this.a();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSParsingException(noSuchAlgorithmException.getMessage());
        }
        this.notifyEOF();
    }

    public void decode(ASN1Object aSN1Object) throws CMSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode((ASN1Object)aSN1Object)));
            return;
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        AlgorithmID algorithmID;
        signerInfo.a(this);
        if (signerInfo.getSecurityProvider() == null) {
            signerInfo.setSecurityProvider(this.securityProvider_);
        }
        if (!((SignedDataStream)this).a.b(algorithmID = signerInfo.getDigestAlgorithm())) {
            if (this.b != null && signerInfo.getSignatureValue() == null) {
                SecurityProvider securityProvider = this.securityProvider_;
                if (securityProvider == null) {
                    securityProvider = SecurityProvider.getSecurityProvider();
                }
                byte[] byArray = securityProvider.getHash(algorithmID, this.b);
                ((SignedDataStream)this).a.a(algorithmID, byArray);
            } else {
                ((SignedDataStream)this).a.a(algorithmID, false);
            }
        }
        if (this.b != null) {
            try {
                signerInfo.a();
            }
            catch (CMSException cMSException) {
                throw new NoSuchAlgorithmException("Error computing signature value: " + cMSException.toString());
            }
        }
        this.signerInfos_.addElement(signerInfo);
        if (this.version_ < 3 && signerInfo.getVersion() == 3) {
            this.version_ = 3;
        }
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray, SecurityProvider securityProvider) throws NoSuchAlgorithmException {
        this();
        this.securityProvider_ = securityProvider;
        this.b = byArray;
        this.mode_ = 2;
        ((SignedDataStream)this).a.a(algorithmIDArray);
        this.a();
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray) throws NoSuchAlgorithmException {
        this(byArray, algorithmIDArray, null);
    }

    public SignedData(byte[] byArray, ObjectID objectID, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.b = byArray;
        this.mode_ = n2;
        this.contentType_ = objectID;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    public SignedData(byte[] byArray, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.b = byArray;
        this.mode_ = n2;
        this.contentType_ = ObjectID.cms_data;
    }

    public SignedData(InputStream inputStream, SecurityProvider securityProvider) throws IOException, CMSParsingException {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public SignedData(InputStream inputStream) throws IOException, CMSParsingException {
        this(inputStream, (SecurityProvider)null);
    }

    public SignedData(ObjectID objectID) {
        super(objectID);
        this.blockSize_ = -1;
    }

    public SignedData(ASN1Object aSN1Object, SecurityProvider securityProvider) throws CMSParsingException {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(aSN1Object);
    }

    public SignedData(ASN1Object aSN1Object) throws CMSParsingException {
        this(aSN1Object, null);
    }

    protected SignedData() {
        this.blockSize_ = -1;
    }
}

