/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.utils;

import it.sogei.rcp.ui.utils.Activator;
import it.sogei.rcp.ui.utils.ParametriVisualizzatoreDocBean;
import it.sogei.rcp.ui.utils.properties.Messages;
import it.sogei.utilities.log4j.LogUtil;
import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class VisualizzatoreDocumentiUtil {
    public static void visualizzaDocumento(URL documentPath) {
        try {
            ParametriVisualizzatoreDocBean paramDocBean = new ParametriVisualizzatoreDocBean();
            paramDocBean.setUrl(documentPath);
            VisualizzatoreDocumentiUtil.visualizzaDocumento(paramDocBean);
        }
        catch (Exception e) {
            LogUtil.log((String)"VisualizzatoreDocumentiUtil", (int)4, (String)Messages.VisualizzatoreDocumentiUtil_errorOpeningVisual, (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.VisualizzatoreDocumentiUtil_error, (String)Messages.VisualizzatoreDocumentiUtil_impossibleVisualizeDocument);
        }
    }

    public static void visualizzaDocumento(URL documentPath, boolean convertiTXT) {
        try {
            ParametriVisualizzatoreDocBean paramDocBean = new ParametriVisualizzatoreDocBean();
            paramDocBean.setUrl(documentPath);
            if (convertiTXT) {
                paramDocBean.setConvertTXT(true);
            }
            VisualizzatoreDocumentiUtil.visualizzaDocumento(paramDocBean);
        }
        catch (Exception e) {
            LogUtil.log((String)"VisualizzatoreDocumentiUtil", (int)4, (String)Messages.VisualizzatoreDocumentiUtil_errorOpeningVisual, (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.VisualizzatoreDocumentiUtil_error, (String)Messages.VisualizzatoreDocumentiUtil_impossibleVisualizeDocument);
        }
    }

    public static void visualizzaDocumento(ParametriVisualizzatoreDocBean paramViewDocBean) {
        try {
            ICommandService commandService = (ICommandService)Activator.getDefault().getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)Activator.getDefault().getWorkbench().getService(IHandlerService.class);
            Command apriVisualizzatore = commandService.getCommand("it.sogei.rcp.ui.utils.commands.apriVisualizzatoreDocumenti");
            IParameter viewIdParm = apriVisualizzatore.getParameter("it.sogei.rcp.ui.utils.commands.url");
            IParameter viewIdTitleParm = apriVisualizzatore.getParameter("it.sogei.rcp.ui.utils.commands.title");
            IParameter convertTxtIdTitleParm = apriVisualizzatore.getParameter("it.sogei.rcp.ui.utils.commands.convertTxt");
            Parameterization parm = null;
            parm = new Parameterization(viewIdParm, paramViewDocBean.getUrl().toExternalForm());
            Parameterization parm2 = new Parameterization(viewIdTitleParm, paramViewDocBean.getTitoloView());
            Parameterization parm3 = new Parameterization(convertTxtIdTitleParm, "" + paramViewDocBean.isConvertTXT());
            ParameterizedCommand parmCommand = new ParameterizedCommand(apriVisualizzatore, new Parameterization[]{parm, parm2, parm3});
            handlerService.executeCommand(parmCommand, null);
        }
        catch (Exception e) {
            LogUtil.log((String)"VisualizzatoreDocumentiUtil", (int)4, (String)Messages.VisualizzatoreDocumentiUtil_errorOpeningVisual, (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.VisualizzatoreDocumentiUtil_error, (String)Messages.VisualizzatoreDocumentiUtil_impossibleVisualizeDocument);
        }
    }
}

