/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DHKeyAgreement
extends KeyAgreementSpi {
    private byte[] a;
    private BigInteger d;
    private BigInteger c;
    private DHPrivateKey b;

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        if (key instanceof DHPrivateKey) {
            this.b = (DHPrivateKey)key;
            this.c = this.b.getParams().getP();
            this.d = this.b.getParams().getG();
            return;
        }
        throw new InvalidKeyException("Only DH private keys are allowed.");
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, null, secureRandom);
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws ShortBufferException, IllegalStateException {
        if (byArray.length - n2 < this.a.length) {
            throw new ShortBufferException("Output buffer is to small for holding the secret.");
        }
        System.arraycopy(this.a, 0, byArray, n2, this.a.length);
        return this.a.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        SecretKey secretKey = null;
        SecretKeySpec secretKeySpec = null;
        try {
            secretKeySpec = new SecretKeySpec(this.a, string);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            secretKey = secretKeyFactory.generateSecret(secretKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Invalid key: " + invalidKeySpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secretKey = secretKeySpec;
        }
        return secretKey;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.a;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws IllegalStateException, InvalidKeyException {
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)key;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            if (!this.c.equals(dHParameterSpec.getP()) && !this.d.equals(dHParameterSpec.getG())) {
                throw new InvalidKeyException("DH parameters are not equal.");
            }
            BigInteger bigInteger = dHPublicKey.getY().modPow(this.b.getX(), this.c);
            if (bl) {
                this.a = bigInteger.toByteArray();
                if (this.a[0] == 0) {
                    byte[] byArray = new byte[this.a.length - 1];
                    System.arraycopy(this.a, 1, byArray, 0, this.a.length - 1);
                    this.a = byArray;
                }
                return null;
            }
            return new DHPublicKey(bigInteger, this.b.getParams());
        }
        throw new InvalidKeyException("DH public key needed.");
    }
}

