/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.actions.ProvisioningAction;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileModificationAction
extends ProvisioningAction {
    public static final int ACTION_NOT_RUN = -1;
    String profileId;
    int result = -1;

    protected ProfileModificationAction(ProvisioningUI ui, String text, ISelectionProvider selectionProvider, String profileId) {
        super(ui, text, selectionProvider);
        this.ui = ui;
        this.profileId = profileId;
        this.init();
    }

    public void run() {
        List<IInstallableUnit> ius = this.getSelectedIUs();
        if (this.isInvalidProfileId() || ius.size() == 0) {
            ProvUI.reportStatus(this.getNoProfileOrSelectionStatus(this.profileId, ius), 4);
            this.runCanceled();
            return;
        }
        this.run(ius, this.profileId);
    }

    protected boolean isInvalidProfileId() {
        return this.profileId == null;
    }

    public IProfile getProfile() {
        String id = this.profileId == null ? this.ui.getProfileId() : this.profileId;
        return ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(id);
    }

    protected IStatus getNoProfileOrSelectionStatus(String id, Collection<IInstallableUnit> ius) {
        return new Status(2, "org.eclipse.equinox.p2.ui", NLS.bind((String)ProvUIMessages.ProfileModificationAction_InvalidSelections, (Object)id, (Object)new Integer(ius.size())));
    }

    protected abstract ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> var1);

    protected void run(final Collection<IInstallableUnit> ius, String id) {
        final ProfileChangeOperation operation = this.getProfileChangeOperation(ius);
        ProvisioningJob job = operation.getResolveJob(null);
        if (job == null) {
            ProvUI.reportStatus(operation.getResolutionResult(), 2);
        } else {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (ProfileModificationAction.this.validateOperation(operation)) {
                                    ProfileModificationAction.this.performAction(operation, ius);
                                }
                            }
                        });
                    }
                }
            });
            this.getProvisioningUI().schedule(job, 1);
        }
        this.result = 0;
    }

    public int getReturnCode() {
        return this.result;
    }

    protected boolean validateOperation(ProfileChangeOperation operation) {
        if (operation != null) {
            return this.getPolicy().continueWorkingWithOperation(operation, this.getShell());
        }
        return false;
    }

    protected abstract int performAction(ProfileChangeOperation var1, Collection<IInstallableUnit> var2);

    protected IInstallableUnit getIU(Object element) {
        return ProvUI.getAdapter(element, IInstallableUnit.class);
    }

    protected List<IInstallableUnit> getSelectedIUs() {
        List elements = this.getStructuredSelection().toList();
        ArrayList<IInstallableUnit> iusList = new ArrayList<IInstallableUnit>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof IIUElement) {
                IIUElement element = (IIUElement)elements.get(i);
                if (this.isSelectable(element)) {
                    iusList.add(this.getIU(element));
                }
            } else {
                IInstallableUnit iu = ProvUI.getAdapter(elements.get(i), IInstallableUnit.class);
                if (iu != null && this.isSelectable(iu)) {
                    iusList.add(iu);
                }
            }
            ++i;
        }
        return iusList;
    }

    protected boolean isSelectable(IIUElement element) {
        return !(element instanceof CategoryElement);
    }

    protected boolean isSelectable(IInstallableUnit iu) {
        return !ProvUI.isCategory(iu);
    }

    protected LicenseManager getLicenseManager() {
        return this.getProvisioningUI().getLicenseManager();
    }

    @Override
    protected final void checkEnablement(Object[] selections) {
        if (this.isEnabledFor(selections)) {
            this.setEnabled(!this.getProvisioningUI().hasScheduledOperations());
        } else {
            this.setEnabled(false);
        }
    }

    protected abstract boolean isEnabledFor(Object[] var1);

    protected int getLock(IProfile profile, IInstallableUnit iu) {
        if (profile == null) {
            return 0;
        }
        try {
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    protected String getProfileProperty(IProfile profile, IInstallableUnit iu, String propertyName) {
        if (profile == null || iu == null) {
            return null;
        }
        return profile.getInstallableUnitProperty(iu, propertyName);
    }

    protected void runCanceled() {
        this.result = 1;
    }
}

