/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary;
import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.ref.DTMAxisIteratorBase;

public abstract class MultiValuedNodeHeapIterator
extends DTMAxisIteratorBase {
    private static final int InitSize = 8;
    private int _heapSize = 0;
    private int _size = 8;
    private HeapNode[] _heap = new HeapNode[8];
    private int _free = 0;
    private int _returnedLast;
    private int _cachedReturnedLast = -1;
    private int _cachedHeapSize;

    @Override
    public DTMAxisIterator cloneIterator() {
        this._isRestartable = false;
        HeapNode[] heapNodeArray = new HeapNode[this._heap.length];
        try {
            MultiValuedNodeHeapIterator multiValuedNodeHeapIterator = (MultiValuedNodeHeapIterator)super.clone();
            for (int i = 0; i < this._free; ++i) {
                heapNodeArray[i] = this._heap[i].cloneHeapNode();
            }
            multiValuedNodeHeapIterator.setRestartable(false);
            multiValuedNodeHeapIterator._heap = heapNodeArray;
            return multiValuedNodeHeapIterator.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", cloneNotSupportedException.toString());
            return null;
        }
    }

    protected void addHeapNode(HeapNode heapNode) {
        if (this._free == this._size) {
            HeapNode[] heapNodeArray = new HeapNode[this._size *= 2];
            System.arraycopy(this._heap, 0, heapNodeArray, 0, this._free);
            this._heap = heapNodeArray;
        }
        ++this._heapSize;
        this._heap[this._free++] = heapNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int next() {
        while (this._heapSize > 0) {
            int n = this._heap[0]._node;
            if (n == -1) {
                if (this._heapSize <= 1) return -1;
                HeapNode heapNode = this._heap[0];
                this._heap[0] = this._heap[--this._heapSize];
                this._heap[this._heapSize] = heapNode;
            } else if (n == this._returnedLast) {
                this._heap[0].step();
            } else {
                this._heap[0].step();
                this.heapify(0);
                this._returnedLast = n;
                return this.returnNode(this._returnedLast);
            }
            this.heapify(0);
        }
        return -1;
    }

    @Override
    public DTMAxisIterator setStartNode(int n) {
        if (this._isRestartable) {
            int n2;
            this._startNode = n;
            for (n2 = 0; n2 < this._free; ++n2) {
                if (this._heap[n2]._isStartSet) continue;
                this._heap[n2].setStartNode(n);
                this._heap[n2].step();
                this._heap[n2]._isStartSet = true;
            }
            this._heapSize = this._free;
            for (n2 = this._heapSize / 2; n2 >= 0; --n2) {
                this.heapify(n2);
            }
            this._returnedLast = -1;
            return this.resetPosition();
        }
        return this;
    }

    protected void init() {
        for (int i = 0; i < this._free; ++i) {
            this._heap[i] = null;
        }
        this._heapSize = 0;
        this._free = 0;
    }

    private void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5 = n4 = (n3 = (n2 = n + 1 << 1) - 1) < this._heapSize && this._heap[n3].isLessThan(this._heap[n]) ? n3 : n;
            if (n2 < this._heapSize && this._heap[n2].isLessThan(this._heap[n4])) {
                n4 = n2;
            }
            if (n4 == n) break;
            HeapNode heapNode = this._heap[n4];
            this._heap[n4] = this._heap[n];
            this._heap[n] = heapNode;
            n = n4;
        }
    }

    @Override
    public void setMark() {
        for (int i = 0; i < this._free; ++i) {
            this._heap[i].setMark();
        }
        this._cachedReturnedLast = this._returnedLast;
        this._cachedHeapSize = this._heapSize;
    }

    @Override
    public void gotoMark() {
        int n;
        for (n = 0; n < this._free; ++n) {
            this._heap[n].gotoMark();
        }
        this._heapSize = this._cachedHeapSize;
        for (n = this._heapSize / 2; n >= 0; --n) {
            this.heapify(n);
        }
        this._returnedLast = this._cachedReturnedLast;
    }

    @Override
    public DTMAxisIterator reset() {
        int n;
        for (n = 0; n < this._free; ++n) {
            this._heap[n].reset();
            this._heap[n].step();
        }
        this._heapSize = this._free;
        for (n = this._heapSize / 2; n >= 0; --n) {
            this.heapify(n);
        }
        this._returnedLast = -1;
        return this.resetPosition();
    }

    public abstract class HeapNode
    implements Cloneable {
        protected int _node;
        protected int _markedNode;
        protected boolean _isStartSet = false;

        public abstract int step();

        public HeapNode cloneHeapNode() {
            HeapNode heapNode;
            try {
                heapNode = (HeapNode)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", cloneNotSupportedException.toString());
                return null;
            }
            heapNode._node = this._node;
            heapNode._markedNode = this._node;
            return heapNode;
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }

        public abstract boolean isLessThan(HeapNode var1);

        public abstract HeapNode setStartNode(int var1);

        public abstract HeapNode reset();
    }
}

