/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JNLPSignedResourcesHelper {
    LaunchDesc mainDesc = null;
    private Thread warmupValidationThread = null;

    public JNLPSignedResourcesHelper(LaunchDesc launchDesc) {
        this.mainDesc = launchDesc;
    }

    public synchronized void warmup() {
        WarmupValidator warmupValidator = new WarmupValidator();
        this.warmupValidationThread = new Thread(warmupValidator);
        this.warmupValidationThread.setDaemon(true);
        this.warmupValidationThread.start();
    }

    public void checkSignedLaunchDesc() throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        this.addExtensions(arrayList, this.mainDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
            this.checkSignedLaunchDescHelper(launchDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSignedResources(Preloader preloader) throws IOException, JNLPException, ExitException {
        ArrayList arrayList = new ArrayList();
        this.addExtensions(arrayList, this.mainDesc);
        boolean bl = true;
        JNLPSignedResourcesHelper jNLPSignedResourcesHelper = this;
        synchronized (jNLPSignedResourcesHelper) {
            if (this.warmupValidationThread != null) {
                try {
                    this.warmupValidationThread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.warmupValidationThread = null;
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
            bl = JNLPSignedResourcesHelper.checkSignedResourcesHelper(launchDesc, preloader) && bl;
        }
        return bl;
    }

    private void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        JNLPSignedResourcesHelper.this.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private void checkSignedLaunchDescHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        block11: {
            boolean bl = launchDesc.isApplicationDescriptor();
            byte[] byArray = null;
            byte[] byArray2 = null;
            JNLPSigningException jNLPSigningException = null;
            try {
                byArray2 = JNLPSignedResourcesHelper.getSignedJNLPFile(launchDesc, bl, true);
                if (byArray2 != null) {
                    try {
                        launchDesc.checkSigningTemplate(byArray2);
                        Trace.println((String)"Signed JNLP Template matches LaunchDesc", (TraceLevel)TraceLevel.SECURITY);
                        return;
                    }
                    catch (JNLPSigningException jNLPSigningException2) {
                        Trace.println((String)"Signed JNLP Template fails to match ld", (TraceLevel)TraceLevel.SECURITY);
                        jNLPSigningException = jNLPSigningException2;
                    }
                }
                if ((byArray = JNLPSignedResourcesHelper.getSignedJNLPFile(launchDesc, bl, false)) == null) {
                    if (jNLPSigningException != null) {
                        throw jNLPSigningException;
                    }
                    break block11;
                }
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray, null, launchDesc.getLocation(), launchDesc.getLocation());
                if (Trace.isEnabled((TraceLevel)TraceLevel.SECURITY)) {
                    Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)launchDesc2.toString(), (TraceLevel)TraceLevel.SECURITY);
                }
                launchDesc.checkSigning(launchDesc2);
                return;
            }
            catch (LaunchDescException launchDescException) {
                launchDescException.setIsSignedLaunchDesc();
                throw launchDescException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (JNLPException jNLPException) {
                throw jNLPException;
            }
        }
        if (launchDesc.getCachedCertificates() != null && launchDesc.getCachedCertificates()[0].isSignedJNLP()) {
            throw new JNLPSigningException(launchDesc, null);
        }
    }

    static boolean checkSignedResourcesHelper(LaunchDesc launchDesc, Preloader preloader) throws IOException, JNLPException, ExitException {
        Object object;
        Object object2;
        int n;
        boolean bl;
        Object object3;
        if (launchDesc.isSecure()) {
            return launchDesc.isSecureJVMArgs();
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = true;
        List list = null;
        URL uRL = launchDesc.getCanonicalHome();
        int n2 = 0;
        URL uRL2 = null;
        SigningInfo signingInfo = null;
        Map map = null;
        Trace.println((String)("Validating signatures for " + launchDesc.getLocation() + " " + launchDesc.getSourceURL()), (TraceLevel)TraceLevel.SECURITY);
        if (launchDesc.getLocation() != null) {
            object3 = launchDesc.getSourceURL();
            if (object3 == null) {
                object3 = launchDesc.getLocation();
            }
            signingInfo = new SigningInfo((URL)object3, launchDesc.getVersion());
            map = signingInfo.getTrustedEntries();
            Trace.println((String)("TustedSet " + (map != null ? Integer.toString(map.size()) : "null")), (TraceLevel)TraceLevel.SECURITY);
        }
        object3 = new SigningInfo[jARDescArray.length];
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        boolean bl5 = false;
        if (map == null) {
            bl = false;
            Trace.println((String)("Empty trusted set for [" + uRL + "]"), (TraceLevel)TraceLevel.SECURITY);
        } else {
            bl = true;
        }
        for (n = 0; !bl5 && n < jARDescArray.length; ++n) {
            object2 = jARDescArray[n];
            object3[n] = new SigningInfo(((JARDesc)object2).getLocation(), ((JARDesc)object2).getVersion());
            Trace.println((String)("Round 1 (" + n + " out of " + jARDescArray.length + "):" + ((JARDesc)object2).getLocation()), (TraceLevel)TraceLevel.SECURITY);
            if (object3[n].isFileKnownToBeNotCached()) {
                Trace.println((String)("    Skip: " + ((JARDesc)object2).getLocation()), (TraceLevel)TraceLevel.SECURITY);
                bl3 = true;
                continue;
            }
            if (object3[n].isKnownToBeValidated()) {
                long l = object3[n].getCachedVerificationTimestampt();
                String string = ((JARDesc)object2).getLocation().toString();
                if (!object3[n].isKnownToBeSigned()) {
                    throw new UnsignedAccessViolationException(launchDesc, ((JARDesc)object2).getLocation(), true);
                }
                if (bl && ((object = (Long)map.get(string)) == null || (Long)object != l)) {
                    Trace.println((String)("Entry [" + string + ", " + object + "] does not match trusted set. Revert to full validation of JNLP."), (TraceLevel)TraceLevel.SECURITY);
                    bl = false;
                }
                hashMap.put(string, new Long(l));
                continue;
            }
            bl5 = true;
            bl = false;
            Trace.println((String)("Entry [" + ((JARDesc)object2).getLocation().toString() + "] is not prevalidated. Revert to full validation of this JAR."), (TraceLevel)TraceLevel.SECURITY);
        }
        if (!bl) {
            for (n = 0; n < jARDescArray.length && bl4; ++n) {
                object2 = jARDescArray[n];
                Trace.println((String)("Round 2 (" + n + " out of " + jARDescArray.length + "):" + ((JARDesc)object2).getLocation()), (TraceLevel)TraceLevel.SECURITY);
                if (object3[n] == null) {
                    object3[n] = new SigningInfo(((JARDesc)object2).getLocation(), ((JARDesc)object2).getVersion());
                }
                if (object3[n].isFileKnownToBeNotCached()) {
                    Trace.println((String)("    Skip " + ((JARDesc)object2).getLocation()), (TraceLevel)TraceLevel.SECURITY);
                    bl3 = true;
                    continue;
                }
                List list2 = null;
                list2 = object3[n].isKnownToBeValidated() ? object3[n].getCertificates() : object3[n].check();
                if (object3[n].isJarKnownToBeEmpty()) continue;
                if (list2 == null) {
                    bl2 = false;
                    uRL2 = ((JARDesc)object2).getLocation();
                    if (launchDesc.getSecurityModel() == 0) break;
                    DownloadEngine.removeCachedResource((URL)((JARDesc)object2).getLocation(), null, (String)((JARDesc)object2).getVersion());
                    break;
                }
                if (list == null) {
                    list = list2;
                } else {
                    list = SigningInfo.overlapChainLists(list2, list);
                    Trace.println((String)("Have " + (list == null ? 0 : list.size()) + " common certificates after processing " + ((JARDesc)object2).getLocation()), (TraceLevel)TraceLevel.SECURITY);
                    if (list == null) {
                        bl4 = false;
                        if (launchDesc.getSecurityModel() != 0) {
                            DownloadEngine.removeCachedResource((URL)((JARDesc)object2).getLocation(), null, (String)((JARDesc)object2).getVersion());
                        }
                    }
                }
                long l = object3[n].getCachedVerificationTimestampt();
                object = ((JARDesc)object2).getLocation().toString();
                hashMap.put(object, new Long(l));
                ++n2;
            }
            if (!launchDesc.isSecure()) {
                CachedCertificatesHelper[] cachedCertificatesHelperArray;
                if (!bl2) {
                    throw new UnsignedAccessViolationException(launchDesc, uRL2, true);
                }
                if (!bl4) {
                    throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
                }
                if (launchDesc.getCachedCertificates() != null && !list.contains((object2 = (cachedCertificatesHelperArray = launchDesc.getCachedCertificates())[0].getCertPath().getCertificates()).get(0))) {
                    throw new LaunchDescException(launchDesc, "Cached certificates do not match real certificates used to sign jars", null);
                }
                if (n2 > 0) {
                    CodeSource codeSource = null;
                    object2 = launchDesc.getLocation() == null ? launchDesc.getSourceURL() : launchDesc.getLocation();
                    codeSource = Config.isJavaVersionAtLeast15() ? new CodeSource((URL)object2, list.toArray(new CodeSigner[0])) : new CodeSource((URL)object2, SigningInfo.toCertificateArray(list));
                    long l = AppPolicy.getInstance().grantUnrestrictedAccess(launchDesc, codeSource, preloader);
                    if (l > 0L) {
                        long l2 = System.currentTimeMillis();
                        for (int i = 0; i < ((SigningInfo[])object3).length; ++i) {
                            object3[i].updateCacheIfNeeded(true, null, l2, l);
                            String string = jARDescArray[i].getLocation().toString();
                            if (!hashMap.containsKey(string)) continue;
                            hashMap.put(string, new Long(object3[i].getCachedVerificationTimestampt()));
                        }
                        if (signingInfo != null) {
                            signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), l);
                        }
                    }
                    bl = true;
                } else {
                    if (signingInfo != null) {
                        signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), Long.MAX_VALUE);
                    }
                    bl = true;
                }
            }
        }
        if (bl && !bl3) {
            launchDesc.setTrusted();
        }
        Trace.println((String)("LD - All JAR files signed: " + uRL), (TraceLevel)TraceLevel.BASIC);
        return bl2;
    }

    static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl, boolean bl2) throws IOException, JNLPException {
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        return Cache.getSignedJNLPBits((URL)jARDesc.getLocation(), (String)jARDesc.getVersion(), (boolean)bl2);
    }

    class WarmupValidator
    implements Runnable {
        WarmupValidator() {
        }

        public void run() {
            Trace.println((String)"Staring warmup validation", (TraceLevel)TraceLevel.SECURITY);
            ArrayList arrayList = new ArrayList();
            JNLPSignedResourcesHelper.this.addExtensions(arrayList, JNLPSignedResourcesHelper.this.mainDesc);
            for (int i = 0; i < arrayList.size(); ++i) {
                LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
                try {
                    this.processSingleDesc(launchDesc);
                    continue;
                }
                catch (Exception exception) {
                    Trace.ignored((Throwable)exception);
                }
            }
        }

        private void processSingleDesc(LaunchDesc launchDesc) throws GeneralSecurityException, IOException {
            if (launchDesc.isSecure()) {
                return;
            }
            CachedCertificatesHelper[] cachedCertificatesHelperArray = launchDesc.getCachedCertificates();
            if (cachedCertificatesHelperArray != null) {
                for (int i = 0; i < cachedCertificatesHelperArray.length; ++i) {
                    Certificate[] certificateArray = cachedCertificatesHelperArray[i].getCertPath().getCertificates().toArray(new X509Certificate[0]);
                    CodeSource codeSource = new CodeSource(launchDesc.getLocation(), certificateArray);
                    TrustDecider.validateChainForWarmup((X509Certificate[])certificateArray, (CodeSource)codeSource, (int)i, (AppInfo)launchDesc.getAppInfo(), (boolean)cachedCertificatesHelperArray[i].isSignedJNLP());
                }
            }
        }
    }
}

