/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.BasicDialog;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.resources.ResourceManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class SettingsDialog
extends BasicDialog {
    private RadioGroup secureJre;
    private RadioGroup insecureJre;
    private RadioGroup localApplet;
    private static final RadioButtonSaveAction SaveAction = new RadioButtonSaveAction();

    public SettingsDialog(JFrame jFrame, boolean bl) {
        super(jFrame, SettingsDialog.getMessage("deployment.security.custom.title"), false);
    }

    protected JComponent createContentPanel() {
        Box box = Box.createVerticalBox();
        this.secureJre = this.createRadioGroup(box, "deployment.security.run.untrusted", false, "ALWAYS");
        this.insecureJre = this.createRadioGroup(box, "deployment.insecure.jres", true, "PROMPT");
        this.localApplet = this.createRadioGroup(box, "deployment.security.local.applets", false, "ALWAYS");
        return box;
    }

    private RadioGroup createRadioGroup(Box box, String string, boolean bl, String string2) {
        RadioGroup radioGroup = new RadioGroup(string);
        RadioButton radioButton = null;
        RadioButton radioButton2 = new RadioButton(string, "ALWAYS", radioGroup);
        radioButton2.addActionListener(SaveAction);
        RadioButton radioButton3 = new RadioButton(string, "PROMPT", radioGroup);
        radioButton3.addActionListener(SaveAction);
        if (bl) {
            radioButton = new RadioButton(string, "PROMPT_MULTI", radioGroup);
            radioButton.addActionListener(SaveAction);
        }
        RadioButton radioButton4 = new RadioButton(string, "NEVER", radioGroup);
        radioButton4.addActionListener(SaveAction);
        radioGroup.add(radioButton2);
        radioGroup.add(radioButton3);
        if (bl) {
            radioGroup.add(radioButton);
        }
        radioGroup.add(radioButton4);
        String string3 = SecurityProperties.getCustomProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        if (string3.equals("ALWAYS")) {
            radioButton2.setSelected(true);
        } else if (string3.equals("PROMPT")) {
            radioButton3.setSelected(true);
        } else if (string3.equals("NEVER")) {
            radioButton4.setSelected(true);
        } else if (string3.equals("PROMPT_MULTI") && radioButton != null) {
            radioButton.setSelected(true);
        }
        radioGroup.setActiveValue(string3);
        boolean bl2 = !Config.get().isPropertyLocked(string);
        box.add(new JLabel(ResourceManager.getMessage(string)));
        box.add(radioButton2);
        radioButton2.setEnabled(bl2);
        box.add(radioButton3);
        radioButton3.setEnabled(bl2);
        if (bl) {
            box.add(radioButton);
            radioButton.setEnabled(bl2);
        }
        box.add(radioButton4);
        radioButton4.setEnabled(bl2);
        return radioGroup;
    }

    protected void okAction() {
        this.secureJre.save();
        this.insecureJre.save();
        this.localApplet.save();
        this.closeDialog();
    }

    private static class RadioButton
    extends JRadioButton {
        private final String command;
        private final RadioGroup group;

        RadioButton(String string, String string2, RadioGroup radioGroup) {
            super(ResourceManager.getMessage(string + "." + string2));
            this.command = string2;
            this.group = radioGroup;
        }

        public void setValue() {
            this.group.setActiveValue(this.command);
        }
    }

    private static class RadioButtonSaveAction
    extends AbstractAction {
        private RadioButtonSaveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RadioButton radioButton = (RadioButton)actionEvent.getSource();
            radioButton.setValue();
        }
    }

    private class RadioGroup
    extends ButtonGroup {
        private String value;
        private final String property;

        RadioGroup(String string) {
            this.property = string;
        }

        public void setActiveValue(String string) {
            this.value = string;
        }

        public void save() {
            SecurityProperties.setCustomProperty(this.property, this.value);
        }
    }
}

