/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.keystore;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.cipher.SecretKey;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;

public final class IAIKKeyStore
extends KeyStoreSpi {
    private Hashtable d;
    private SecureRandom b = SecRandom.getDefault();
    private int a = 16;
    private int c = 1000;
    private int e = 32;
    private static final int o = 15;
    private static final int k = 14;
    private static final int g = 13;
    private static final int f = 12;
    private static final int i = 11;
    private static final int j = 10;
    private static final int m = 1;
    private static final int l = 0;
    private static final String h = "1.2.840.113549.1.5.9";
    private static final boolean n = false;

    private byte[] a(int n2, Key key, byte[] byArray) throws KeyStoreException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, 24, 8);
            SecretKey secretKey = new SecretKey(byArray, 0, 24, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "IAIK");
            int n3 = n2 == 0 ? 1 : 2;
            cipher.init(n3, (Key)secretKey, ivParameterSpec, null);
            byte[] byArray2 = key.getEncoded();
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (Exception exception) {
            throw new KeyStoreException("Crypt failed: " + exception.toString());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecretKey a(char[] var1_1, byte[] var2_2) {
        var3_3 = null;
        var4_4 = IAIKKeyStore.a(var1_1);
        try {
            try {
                var8_5 = null;
                var8_5 = KeyGenerator.getInstance("PBKDF2", "IAIK");
                var3_3 = new PBEKeyAndParameterSpec(var4_4, var2_2, this.c, this.e);
                var8_5.init(var3_3, null);
                var5_10 = var9_9 = (SecretKey)var8_5.generateKey();
                var7_11 = null;
                if (var3_3 == null) return var5_10;
                var4_4 = var3_3.getPassword();
                var8_6 = 0;
                ** GOTO lbl18
            }
            catch (Exception var8_7) {
                throw new InternalErrorException("Could not generate key: " + var8_7.toString());
lbl18:
                // 1 sources

                if (true) ** GOTO lbl29
            }
        }
        catch (Throwable var6_13) {
            var7_12 = null;
            if (var3_3 == null) throw var6_13;
            var4_4 = var3_3.getPassword();
            var8_8 = 0;
            if (true) ** GOTO lbl34
        }
        do {
            var4_4[var8_6] = 0;
            ++var8_6;
lbl29:
            // 2 sources

        } while (var8_6 < var4_4.length);
        return var5_10;
        do {
            var4_4[var8_8] = 0;
            ++var8_8;
lbl34:
            // 2 sources

        } while (var8_8 < var4_4.length);
        throw var6_13;
    }

    private int a(SEQUENCE sEQUENCE) {
        if (sEQUENCE == null) {
            return 10;
        }
        int n2 = sEQUENCE.countComponents();
        if (n2 > 3 || n2 < 1) {
            return 10;
        }
        int n3 = -1;
        try {
            sEQUENCE.getComponentAt(0);
            if (n2 == 1) {
                return 11;
            }
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
            n3 = cON_SPEC.getAsnType().getTag();
        }
        catch (Exception exception) {
            return 10;
        }
        switch (n3) {
            case 0: {
                return 12;
            }
            case 1: {
                return 13;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
        }
        return 10;
    }

    private byte[] b() {
        byte[] byArray = new byte[this.a];
        this.b.nextBytes(byArray);
        return byArray;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws CertificateException, NoSuchAlgorithmException, IOException {
        SEQUENCE sEQUENCE;
        Object object;
        Object object2;
        Mac mac;
        if (cArray == null || cArray.length == 0) {
            throw new IOException("Password must be specified.");
        }
        byte[] byArray = this.b();
        SecretKey secretKey = this.a(cArray, byArray);
        try {
            mac = Mac.getInstance("HMAC/SHA", "IAIK");
            mac.init(secretKey);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not initialize HMAC. ");
        }
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        Enumeration enumeration = this.d.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = new OCTET_STRING(IAIKKeyStore.a((String)object2));
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent((ASN1Object)this.d.get(object2));
            sEQUENCE2.addComponent(sEQUENCE);
        }
        mac.update(DerCoder.encode(sEQUENCE2));
        object2 = this.a(byArray);
        object = mac.doFinal(DerCoder.encode((ASN1Object)object2));
        sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(sEQUENCE2);
        sEQUENCE.addComponent((ASN1Object)object2);
        sEQUENCE.addComponent(new OCTET_STRING((byte[])object));
        outputStream.write(DerCoder.encode(sEQUENCE));
    }

    public int engineSize() {
        return this.d.size();
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified. ");
        }
        if (byArray == null || byArray.length == 0) {
            throw new KeyStoreException("Key has to be specified. ");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a());
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            sEQUENCE.addComponent(new CON_SPEC(2, encryptedPrivateKeyInfo.toASN1Object(), false));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException("Key is not a PKCS#8-EncryptedPrivateKeyInfo. ");
        }
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        if (certificateArray != null && certificateArray[0] != null) {
            int n2 = 0;
            while (n2 < certificateArray.length) {
                try {
                    ASN1Object aSN1Object = DerCoder.decode(certificateArray[n2].getEncoded());
                    sEQUENCE2.addComponent(aSN1Object);
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Could not decode certificate: " + exception.toString());
                }
                ++n2;
            }
            sEQUENCE.addComponent(new CON_SPEC(3, sEQUENCE2, false));
        }
        this.d.put(string, sEQUENCE);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Object object;
        Object object2;
        int n2;
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified.");
        }
        if (key == null) {
            throw new KeyStoreException("Key has to be specified.");
        }
        if (key instanceof EncryptedPrivateKeyInfo) {
            n2 = 14;
        } else {
            if (cArray == null) {
                throw new KeyStoreException("Password has to be specified.");
            }
            if (key instanceof javax.crypto.SecretKey) {
                n2 = 12;
            } else {
                try {
                    PrivateKeyInfo.getPrivateKey(key.getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new KeyStoreException("Unknown private key type.");
                }
                n2 = 13;
            }
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a());
        if (n2 == 14) {
            sEQUENCE.addComponent(new CON_SPEC(2, ((EncryptedPrivateKeyInfo)key).toASN1Object(), false));
        } else {
            object2 = this.b();
            SecretKey secretKey = this.a(cArray, (byte[])object2);
            object = this.a(0, key, secretKey.getEncoded());
            ASN1Object aSN1Object = this.a((byte[])object2);
            OCTET_STRING oCTET_STRING = new OCTET_STRING((byte[])object);
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(aSN1Object);
            sEQUENCE2.addComponent(oCTET_STRING);
            if (n2 == 12) {
                sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2, false));
            }
            if (n2 == 13) {
                sEQUENCE.addComponent(new CON_SPEC(1, sEQUENCE2, false));
            }
        }
        if (certificateArray != null && certificateArray[0] != null) {
            object2 = new SEQUENCE();
            int n3 = 0;
            while (n3 < certificateArray.length) {
                try {
                    object = DerCoder.decode(certificateArray[n3].getEncoded());
                    ((ConstructedType)object2).addComponent((ASN1Object)object);
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Could not encode certificate: " + exception.toString());
                }
                ++n3;
            }
            sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object2, false));
        }
        this.d.put(string, sEQUENCE);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        ASN1Object aSN1Object;
        if (string == null) {
            throw new KeyStoreException("Alias has to be specified.");
        }
        if (certificate == null) {
            throw new KeyStoreException("Certificate has to be specified.");
        }
        if (this.engineIsKeyEntry(string)) {
            throw new KeyStoreException("This alias is already used by a key.");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a());
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        try {
            aSN1Object = DerCoder.decode(certificate.getEncoded());
        }
        catch (Exception exception) {
            throw new InternalErrorException("Could not encoding certificate: " + exception.toString());
        }
        sEQUENCE2.addComponent(aSN1Object);
        sEQUENCE.addComponent(new CON_SPEC(3, sEQUENCE2, false));
        this.d.put(string, sEQUENCE);
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws CertificateException, NoSuchAlgorithmException, IOException {
        if (inputStream == null) {
            return;
        }
        try {
            Object object;
            OCTET_STRING oCTET_STRING;
            ConstructedType constructedType;
            ASN1 aSN1 = new ASN1(inputStream);
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1.getComponentAt(0);
            if (cArray != null && cArray.length > 0) {
                Mac mac;
                SEQUENCE sEQUENCE2 = (SEQUENCE)aSN1.getComponentAt(1);
                constructedType = (OCTET_STRING)sEQUENCE2.getComponentAt(1);
                oCTET_STRING = (OCTET_STRING)aSN1.getComponentAt(2);
                object = (byte[])((OCTET_STRING)constructedType).getValue();
                SecretKey secretKey = this.a(cArray, (byte[])object);
                try {
                    mac = Mac.getInstance("HMAC/SHA", "IAIK");
                    mac.init(secretKey);
                }
                catch (Exception exception) {
                    throw new NoSuchAlgorithmException("Could not initialize HMAC: " + exception.toString());
                }
                mac.update(aSN1.getFirstObject());
                byte[] byArray = mac.doFinal(DerCoder.encode(sEQUENCE2));
                if (!CryptoUtils.equalsBlock((byte[])oCTET_STRING.getValue(), byArray)) {
                    throw new IOException("Integrity verification failed! HMAC not valid. ");
                }
            }
            int n2 = 0;
            while (n2 < sEQUENCE.countComponents()) {
                constructedType = (SEQUENCE)sEQUENCE.getComponentAt(n2);
                oCTET_STRING = (OCTET_STRING)constructedType.getComponentAt(0);
                object = (SEQUENCE)constructedType.getComponentAt(1);
                this.d.put(IAIKKeyStore.b((byte[])oCTET_STRING.getValue()), object);
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("CodingException: " + codingException.getMessage());
        }
    }

    public boolean engineIsKeyEntry(String string) {
        if (string == null) {
            return false;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.d.get(string);
        int n2 = this.a(sEQUENCE);
        switch (n2) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (string == null) {
            return false;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.d.get(string);
        int n2 = this.a(sEQUENCE);
        return n2 == 15;
    }

    public Key engineGetKey(String string, char[] cArray) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        byte[] byArray;
        byte[] byArray2;
        OCTET_STRING oCTET_STRING;
        Object object;
        if (string == null) {
            throw new UnrecoverableKeyException("Alias has to be specified.");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.d.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = this.a(sEQUENCE);
        if (n2 == 10) {
            throw new UnrecoverableKeyException("Invalid keystore record.");
        }
        if (n2 == 15) {
            throw new UnrecoverableKeyException("This alias specifies a certificate entry.");
        }
        if (n2 == 11) {
            throw new UnrecoverableKeyException("This alias specifies a date entry.");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        int n3 = cON_SPEC.getAsnType().getTag();
        if (n3 == 2) {
            ASN1Object aSN1Object = cON_SPEC.getComponentAt(0);
            try {
                if (cArray == null || cArray.length == 0) {
                    return new EncryptedPrivateKeyInfo(aSN1Object);
                }
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(aSN1Object);
                return encryptedPrivateKeyInfo.decrypt(cArray);
            }
            catch (Exception exception) {
                throw new UnrecoverableKeyException("Wrong password: " + exception.toString());
            }
        }
        if (cArray == null || cArray.length == 0) {
            throw new UnrecoverableKeyException("Password has to be specified!");
        }
        SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
        SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(0);
        byte[] byArray3 = null;
        try {
            object = (ObjectID)sEQUENCE3.getComponentAt(0);
            if (!((ObjectID)object).getID().equals(h)) {
                throw new UnrecoverableKeyException("Unknown OID: " + object);
            }
            oCTET_STRING = (OCTET_STRING)sEQUENCE3.getComponentAt(1);
            byArray3 = oCTET_STRING.getWholeValue();
            if (byArray3.length != this.a) {
                throw new UnrecoverableKeyException("Invalid salt");
            }
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("Cannot parse key: " + exception.toString());
        }
        object = this.a(cArray, byArray3);
        oCTET_STRING = (OCTET_STRING)sEQUENCE2.getComponentAt(1);
        try {
            byArray2 = oCTET_STRING.getWholeValue();
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Cannot parse key: " + iOException.toString());
        }
        SecretKey secretKey = new SecretKey(byArray2, "RAW");
        try {
            byArray = this.a(1, secretKey, ((SecretKey)object).getEncoded());
        }
        catch (KeyStoreException keyStoreException) {
            throw new UnrecoverableKeyException(keyStoreException.getMessage());
        }
        if (n3 == 0) {
            return new SecretKey(byArray, "RAW");
        }
        try {
            return PrivateKeyInfo.getPrivateKey(byArray);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    public Date engineGetCreationDate(String string) {
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.d.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = this.a(sEQUENCE);
        if (n2 == 10) {
            return null;
        }
        INTEGER iNTEGER = (INTEGER)sEQUENCE.getComponentAt(0);
        return this.a(iNTEGER);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.d.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = sEQUENCE.countComponents();
        if (n2 != 3) {
            return null;
        }
        int n3 = this.a(sEQUENCE);
        if (n3 == 13 || n3 == 14) {
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(2);
            SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
            int n4 = sEQUENCE2.countComponents();
            Certificate[] certificateArray = new X509Certificate[n4];
            try {
                int n5 = 0;
                while (n5 < n4) {
                    ASN1Object aSN1Object = sEQUENCE2.getComponentAt(n5);
                    X509Certificate x509Certificate = new X509Certificate();
                    x509Certificate.decode(aSN1Object);
                    certificateArray[n5] = x509Certificate;
                    ++n5;
                }
            }
            catch (CodingException codingException) {
                return null;
            }
            return certificateArray;
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        try {
            byte[] byArray = certificate.getEncoded();
            Enumeration enumeration = this.engineAliases();
            while (enumeration.hasMoreElements()) {
                byte[] byArray2;
                String string = (String)enumeration.nextElement();
                Certificate certificate2 = this.engineGetCertificate(string);
                if (certificate2 == null || !CryptoUtils.equalsBlock(byArray, byArray2 = certificate2.getEncoded())) continue;
                return string;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        CON_SPEC cON_SPEC;
        if (string == null) {
            return null;
        }
        SEQUENCE sEQUENCE = (SEQUENCE)this.d.get(string);
        if (sEQUENCE == null) {
            return null;
        }
        int n2 = sEQUENCE.countComponents();
        int n3 = this.a(sEQUENCE);
        if (n3 == 15) {
            cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        } else if (n2 == 3) {
            cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(2);
        } else {
            return null;
        }
        SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getComponentAt(0);
        ASN1Object aSN1Object = sEQUENCE2.getComponentAt(0);
        X509Certificate x509Certificate = new X509Certificate();
        try {
            x509Certificate.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException.getMessage());
        }
        return x509Certificate;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string != null) {
            this.d.remove(string);
        }
    }

    public boolean engineContainsAlias(String string) {
        if (string == null) {
            return false;
        }
        return this.d.containsKey(string);
    }

    public Enumeration engineAliases() {
        return this.d.keys();
    }

    private static byte[] a(String string) {
        try {
            return UTF8String.getUTF8EncodingFromString(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private static byte[] a(char[] cArray) {
        try {
            return UTF8String.getUTF8EncodingFromCharArray(cArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private static String b(byte[] byArray) {
        try {
            return UTF8String.getStringFromUTF8Encoding(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in UTF8 decoding");
        }
    }

    private INTEGER a() {
        Date date = new Date();
        BigInteger bigInteger = BigInteger.valueOf(date.getTime());
        return new INTEGER(bigInteger);
    }

    private ASN1Object a(byte[] byArray) {
        OCTET_STRING oCTET_STRING = new OCTET_STRING(byArray);
        ObjectID objectID = new ObjectID(h);
        AlgorithmID algorithmID = new AlgorithmID(objectID, oCTET_STRING);
        return algorithmID.toASN1Object();
    }

    private Date a(INTEGER iNTEGER) {
        BigInteger bigInteger = (BigInteger)iNTEGER.getValue();
        return new Date(bigInteger.longValue());
    }

    public IAIKKeyStore() {
        this.d = new Hashtable();
    }
}

