/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.asn1.OCTET_STRING;
import iaik.security.ecc.ECCException;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.ecgroup.FastPrimeCurve;
import iaik.security.ecc.util.PointFormatter;
import java.math.BigInteger;

public class ECPoint
implements Cloneable {
    private Coordinate coordinates_;
    protected boolean isInfinity_ = false;
    protected EllipticCurve curve_;

    public void setCoordinates(Coordinate coordinate) {
        this.coordinates_ = coordinate;
    }

    public void unsetInfinity() {
        this.isInfinity_ = false;
    }

    public String toString() {
        if (this.isInfinity_) {
            return "Infinity";
        }
        return this.coordinates_.toString();
    }

    public OCTET_STRING toASN1Object() {
        if (this.isInfinity_) {
            byte[] byArray = new byte[]{0};
            return new OCTET_STRING(byArray);
        }
        return this.coordinates_.toASN1Object();
    }

    public void setInfinity() {
        this.isInfinity_ = true;
    }

    public void precomputePoints() {
        ((FastPrimeCurve)this.curve_).precomputePoints(this);
    }

    public void multiply2(BigInteger bigInteger, ECPoint eCPoint, BigInteger bigInteger2) {
        this.curve_.multiply2(this, bigInteger, eCPoint, bigInteger2);
    }

    public void multiply(BigInteger bigInteger) {
        this.curve_.multiply(this, bigInteger);
    }

    public boolean isInfinity() {
        return this.isInfinity_;
    }

    public void invert() {
        this.curve_.invert(this);
    }

    public int hashCode() {
        return (this.isInfinity_ ? 1 : this.coordinates_.hashCode()) + this.curve_.hashCode();
    }

    public EllipticCurve getCurve() {
        return this.curve_;
    }

    public Coordinate getCoordinates() {
        return this.coordinates_;
    }

    public boolean equals(Object object) {
        if (object instanceof ECPoint) {
            ECPoint eCPoint = (ECPoint)object;
            if (eCPoint.isInfinity()) {
                return this.isInfinity_;
            }
            if (this.isInfinity_) {
                return false;
            }
            if (!this.curve_.equals(eCPoint.curve_)) {
                return false;
            }
            if (this.coordinates_.getClass().equals(eCPoint.getCoordinates().getClass())) {
                return this.coordinates_.equals(eCPoint.getCoordinates());
            }
            return this.coordinates_.toAffine().equals(eCPoint.coordinates_.toAffine());
        }
        return false;
    }

    public void doublePoint() {
        this.curve_.doublePoint(this);
    }

    public Object clone() {
        try {
            ECPoint eCPoint = (ECPoint)super.clone();
            if (!this.isInfinity_) {
                eCPoint.coordinates_ = (Coordinate)this.coordinates_.clone();
            }
            return eCPoint;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void addPoint(ECPoint eCPoint) {
        this.curve_.addPoint(this, eCPoint);
    }

    ECPoint(EllipticCurve ellipticCurve) {
        this.isInfinity_ = true;
        this.curve_ = ellipticCurve;
    }

    ECPoint(Coordinate coordinate, EllipticCurve ellipticCurve) {
        this.coordinates_ = coordinate;
        this.curve_ = ellipticCurve;
        this.isInfinity_ = false;
    }

    public ECPoint(byte[] byArray, EllipticCurve ellipticCurve) throws ECCException {
        this.curve_ = ellipticCurve;
        this.coordinates_ = PointFormatter.getInstance().getPointCodec().decodePoint(byArray, ellipticCurve);
        if (this.coordinates_ == null) {
            this.isInfinity_ = true;
        } else {
            this.isInfinity_ = false;
            if (!ellipticCurve.useAffine()) {
                this.coordinates_ = ((AffineCoordinate)this.coordinates_).toProjective();
            }
        }
    }
}

