/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.NodeFilterImpl;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    NodeIteratorImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static NodeIterator create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new NodeIteratorImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(NodeIterator arg) {
        return arg == null ? 0L : ((NodeIteratorImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof NodeIteratorImpl && this.peer == ((NodeIteratorImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static NodeIterator getImpl(long peer, long contextPeer, long rootPeer) {
        return NodeIteratorImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public Node getRoot() {
        return NodeImpl.getImpl(NodeIteratorImpl.getRootImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getRootImpl(long var0);

    @Override
    public int getWhatToShow() {
        return NodeIteratorImpl.getWhatToShowImpl(this.getPeer());
    }

    static native int getWhatToShowImpl(long var0);

    @Override
    public NodeFilter getFilter() {
        return NodeFilterImpl.getImpl(NodeIteratorImpl.getFilterImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getFilterImpl(long var0);

    @Override
    public boolean getExpandEntityReferences() {
        return NodeIteratorImpl.getExpandEntityReferencesImpl(this.getPeer());
    }

    static native boolean getExpandEntityReferencesImpl(long var0);

    public Node getReferenceNode() {
        return NodeImpl.getImpl(NodeIteratorImpl.getReferenceNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getReferenceNodeImpl(long var0);

    public boolean getPointerBeforeReferenceNode() {
        return NodeIteratorImpl.getPointerBeforeReferenceNodeImpl(this.getPeer());
    }

    static native boolean getPointerBeforeReferenceNodeImpl(long var0);

    @Override
    public Node nextNode() throws DOMException {
        return NodeImpl.getImpl(NodeIteratorImpl.nextNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long nextNodeImpl(long var0);

    @Override
    public Node previousNode() throws DOMException {
        return NodeImpl.getImpl(NodeIteratorImpl.previousNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long previousNodeImpl(long var0);

    @Override
    public void detach() {
        NodeIteratorImpl.detachImpl(this.getPeer());
    }

    static native void detachImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            NodeIteratorImpl.dispose(this.peer);
        }
    }
}

