/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.CompoundTexture;
import com.sun.prism.image.Coords;
import com.sun.prism.image.ViewPort;
import com.sun.webpane.platform.ConfigManager;
import com.sun.webpane.sg.prism.PrismImage;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCImageImpl
extends PrismImage {
    private static final Logger log = Logger.getLogger(WCImageImpl.class.getName());
    public static final int INT_ARGB_PRE = 0;
    public static final int BYTE_BGRA_PRE = 1;
    public static int defaultType = ConfigManager.getProperty("USE_BGRA") != null ? 1 : 0;
    Image img;
    Texture texture;
    CompoundTexture compoundTexture;

    public WCImageImpl(int n, int n2) {
        this(n, n2, defaultType);
    }

    public WCImageImpl(int n, int n2, int n3) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating empty image({0},{1},{2})", new Object[]{n, n2, n3});
        }
        switch (n3) {
            case 0: {
                this.img = Image.fromIntArgbPreData(new int[n * n2], n, n2);
                break;
            }
            case 1: {
                this.img = Image.fromByteBgraPreData(new byte[n * n2 * 4], n, n2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown image type: " + n3);
            }
        }
    }

    public WCImageImpl(int[] nArray, int n, int n2) {
        this(nArray, n, n2, defaultType);
    }

    public WCImageImpl(int[] nArray, int n, int n2, int n3) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating image({0},{1},{2}) from buffer", new Object[]{n, n2, n3});
        }
        switch (n3) {
            case 0: {
                this.img = Image.fromIntArgbPreData(nArray, n, n2);
                break;
            }
            case 1: {
                byte[] byArray = new byte[nArray.length * 4];
                for (int i = 0; i < nArray.length; ++i) {
                    int n4 = i * 4;
                    byArray[n4++] = (byte)nArray[i];
                    byArray[n4++] = (byte)(nArray[i] >> 8);
                    byArray[n4++] = (byte)(nArray[i] >> 16);
                    byArray[n4++] = (byte)(nArray[i] >> 24);
                }
                this.img = Image.fromByteBgraPreData(byArray, n, n2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown image type: " + n3);
            }
        }
    }

    public WCImageImpl(IntBuffer intBuffer, int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Creating image %dx%d from buffer", n, n2));
        }
        this.img = Image.fromIntArgbPreData(intBuffer, n, n2);
    }

    public WCImageImpl(ImageFrame imageFrame) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating image {0}x{1} of type {2} from buffer", new Object[]{imageFrame.getWidth(), imageFrame.getHeight(), imageFrame.getImageType()});
        }
        this.img = Image.convertImageFrame(imageFrame);
    }

    public WCImageImpl(Image image) {
        this.img = image;
    }

    @Override
    public Image getImage() {
        return this.img;
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Object object;
        if (this.texture == null && this.compoundTexture == null) {
            object = graphics.getResourceFactory();
            int n9 = object.getMaximumTextureSize();
            if (this.img.getWidth() <= n9 && this.img.getHeight() <= n9) {
                this.texture = object.createTexture(this.img);
                assert (this.texture != null);
            } else {
                this.compoundTexture = new CompoundTexture(this.img, n9);
            }
        }
        if (this.texture != null) {
            assert (this.compoundTexture == null);
            graphics.drawTexture(this.texture, n, n2, n3, n4, n5, n6, n7, n8);
        } else {
            assert (this.compoundTexture != null);
            object = new ViewPort(n5, n6, n7 - n5, n8 - n6);
            Coords coords = new Coords(n3 - n, n4 - n2, (ViewPort)object);
            CompoundCoords compoundCoords = new CompoundCoords(this.compoundTexture, coords);
            compoundCoords.draw(graphics, this.compoundTexture, n, n2);
        }
    }

    @Override
    public void dispose() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
        if (this.compoundTexture != null) {
            this.compoundTexture.dispose();
            this.compoundTexture = null;
        }
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }
}

