/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.framelist;

import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.framelist.Frame;
import org.eclipse.ui.internal.navigator.framelist.FrameAction;
import org.eclipse.ui.internal.navigator.framelist.FrameList;
import org.eclipse.ui.internal.navigator.framelist.FrameListMessages;

public class BackAction
extends FrameAction {
    private static final String ID = "org.eclipse.ui.framelist.back";

    public BackAction(FrameList frameList) {
        super(frameList);
        this.setId(ID);
        this.setText(FrameListMessages.Back_text);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.back_action_context");
        this.update();
    }

    private Frame getPreviousFrame() {
        FrameList list = this.getFrameList();
        return list.getFrame(list.getCurrentIndex() - 1);
    }

    private String getToolTipText(Frame previousFrame) {
        String text;
        if (previousFrame != null && (text = previousFrame.getToolTipText()) != null && text.length() > 0) {
            return NLS.bind((String)FrameListMessages.Back_toolTipOneArg, (Object)text);
        }
        return FrameListMessages.Back_toolTip;
    }

    public void run() {
        this.getFrameList().back();
    }

    public void update() {
        super.update();
        Frame previousFrame = this.getPreviousFrame();
        this.setEnabled(previousFrame != null);
        this.setToolTipText(this.getToolTipText(previousFrame));
    }
}

