/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;

public class Accuracy {
    private int c;
    private int b;
    private int a;
    private static final int e = 3;
    private static final int d = 0;
    private static final boolean m = true;
    private static final boolean k = true;
    private static final int l = 1;
    private static final int j = 0;
    private static final int o = 999;
    private static final int i = 1;
    private static final int n = 999;
    private static final int h = 1;
    private static final int g = 0;

    private void a(ASN1Object aSN1Object) throws CodingException {
        int n;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No Accuracy!");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        if (sEQUENCE.countComponents() < 0) {
            throw new CodingException("Too few elements.");
        }
        if (sEQUENCE.countComponents() > 3) {
            throw new CodingException("Too many elements.");
        }
        int n2 = 0;
        if (n2 == sEQUENCE.countComponents()) {
            return;
        }
        if (sEQUENCE.getComponentAt(n2).isA(ASN.INTEGER)) {
            int n3 = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(n2)).getValue()).intValue();
            try {
                this.checkRangeOfSeconds(n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CodingException("Wrong seconds format");
            }
            this.a = n3;
            if (++n2 == sEQUENCE.countComponents()) {
                return;
            }
        }
        if (sEQUENCE.getComponentAt(n2).isA(ASN.CON_SPEC)) {
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(n2);
            if (cON_SPEC.isImplicitlyTagged()) {
                cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
            }
            if (cON_SPEC.getAsnType().getTag() == 0) {
                n = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                try {
                    this.checkRangeOfMillis(n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CodingException("Wrong millis format");
                }
                this.b = n;
                if (++n2 == sEQUENCE.countComponents()) {
                    return;
                }
            }
        }
        if (sEQUENCE.getComponentAt(n2).isA(ASN.CON_SPEC)) {
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(n2);
            if (cON_SPEC.isImplicitlyTagged()) {
                cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
            }
            if (cON_SPEC.getAsnType().getTag() != 1) {
                throw new CodingException("Wrong millis tag " + String.valueOf(cON_SPEC.getAsnType().getTag()));
            }
            n = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
            try {
                this.checkRangeOfMillis(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CodingException("Wrong micros format");
            }
            this.c = n;
            ++n2;
        }
        if (n2 != sEQUENCE.countComponents()) {
            new CodingException("No Accuracy!");
        }
    }

    protected void checkRangeOfMicros(int n) throws IllegalArgumentException {
        if (n < 1 || n > 999) {
            throw new IllegalArgumentException("Micros " + String.valueOf(1) + ".." + String.valueOf(999));
        }
    }

    protected void checkRangeOfMillis(int n) throws IllegalArgumentException {
        if (n < 1 || n > 999) {
            throw new IllegalArgumentException("Millis " + String.valueOf(1) + ".." + String.valueOf(999));
        }
    }

    protected void checkRangeOfSeconds(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Seconds >= " + String.valueOf(0));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Accuracy>\n");
        stringBuffer.append("\tSeconds: " + String.valueOf(this.a) + "\n");
        stringBuffer.append("\tMillis: " + String.valueOf(this.b) + "\n");
        stringBuffer.append("\tMicros: " + String.valueOf(this.c) + "\n");
        stringBuffer.append("</Accuracy>");
        return stringBuffer.toString();
    }

    public int getMicros() {
        return this.c;
    }

    public int getMillis() {
        return this.b;
    }

    public int getSeconds() {
        return this.a;
    }

    public void setMicros(int n) throws IllegalArgumentException {
        this.checkRangeOfMicros(n);
        this.c = n;
    }

    public void setMillis(int n) throws IllegalArgumentException {
        this.checkRangeOfMillis(n);
        this.b = n;
    }

    public void setSeconds(int n) throws IllegalArgumentException {
        this.checkRangeOfSeconds(n);
        this.a = n;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.a));
        if (this.b > 0) {
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new INTEGER(this.b), true));
        }
        if (this.c > 0) {
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)new INTEGER(this.c), true));
        }
        return sEQUENCE;
    }

    public byte[] getEncoded() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public Accuracy(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public Accuracy() {
    }
}

