/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal;

import com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigesterOutputStream
extends OutputStream {
    private boolean buffer = false;
    private UnsyncByteArrayOutputStream bos;
    private final MessageDigest md;
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal");

    public DigesterOutputStream(MessageDigest messageDigest) {
        this(messageDigest, false);
    }

    public DigesterOutputStream(MessageDigest messageDigest, boolean bl) {
        this.md = messageDigest;
        this.buffer = bl;
        if (bl) {
            this.bos = new UnsyncByteArrayOutputStream();
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) {
        if (this.buffer) {
            this.bos.write(n);
        }
        this.md.update((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (this.buffer) {
            this.bos.write(byArray, n, n2);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Pre-digested input:");
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            log.log(Level.FINER, stringBuffer.toString());
        }
        this.md.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.md.digest();
    }

    public InputStream getInputStream() {
        if (this.buffer) {
            return new ByteArrayInputStream(this.bos.toByteArray());
        }
        return null;
    }
}

