/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayBuffer
extends OutputStream {
    protected byte[] buf;
    private int count;
    private static final int CHUNK_SIZE = 4096;

    public ByteArrayBuffer() {
        this(32);
    }

    public ByteArrayBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
    }

    public ByteArrayBuffer(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public ByteArrayBuffer(byte[] byArray, int n) {
        this.buf = byArray;
        this.count = n;
    }

    public final void write(InputStream inputStream) throws IOException {
        int n;
        int n2;
        while ((n2 = inputStream.read(this.buf, this.count, n = this.buf.length - this.count)) >= 0) {
            this.count += n2;
            if (n != n2) continue;
            this.ensureCapacity(this.buf.length * 2);
        }
        return;
    }

    @Override
    public final void write(int n) {
        int n2 = this.count + 1;
        this.ensureCapacity(n2);
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        this.ensureCapacity(n3);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    private void ensureCapacity(int n) {
        if (n > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        int n = this.count;
        int n2 = 0;
        while (n > 0) {
            int n3 = n > 4096 ? 4096 : n;
            outputStream.write(this.buf, n2, n3);
            n -= n3;
            n2 += n3;
        }
    }

    public final void reset() {
        this.count = 0;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public final int size() {
        return this.count;
    }

    public final byte[] getRawData() {
        return this.buf;
    }

    @Override
    public void close() throws IOException {
    }

    public final InputStream newInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public final InputStream newInputStream(int n, int n2) {
        return new ByteArrayInputStream(this.buf, n, n2);
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }
}

