/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.api;

import com.sun.xml.internal.bind.api.Messages;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.xml.namespace.QName;

public final class TypeReference {
    public final QName tagName;
    public final Type type;
    public final Annotation[] annotations;

    public TypeReference(QName qName, Type type, Annotation ... annotationArray) {
        if (qName == null || type == null || annotationArray == null) {
            String string = "";
            if (qName == null) {
                string = "tagName";
            }
            if (type == null) {
                string = string + (string.length() > 0 ? ", type" : "type");
            }
            if (annotationArray == null) {
                string = string + (string.length() > 0 ? ", annotations" : "annotations");
            }
            Messages.ARGUMENT_CANT_BE_NULL.format(string);
            throw new IllegalArgumentException(Messages.ARGUMENT_CANT_BE_NULL.format(string));
        }
        this.tagName = new QName(qName.getNamespaceURI().intern(), qName.getLocalPart().intern(), qName.getPrefix());
        this.type = type;
        this.annotations = annotationArray;
    }

    public <A extends Annotation> A get(Class<A> clazz) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != clazz) continue;
            return (A)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    public TypeReference toItemType() {
        Type type = Navigator.REFLECTION.getBaseClass(this.type, Collection.class);
        if (type == null) {
            return this;
        }
        return new TypeReference(this.tagName, Navigator.REFLECTION.getTypeArgument(type, 0), new Annotation[0]);
    }
}

