/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import Outrun_Cluster 1.0

Item {
    width: Constants.width
    height: Constants.height

    property alias fakeReflections: mainScreen.fakeReflections
    property alias carDistance: mainScreen.carpositionAlias

    focus: true

    Screen01 {
        id: mainScreen
    }

    Keys.onPressed:
        (event)=> {
            executeCommand(event.key)
            event.accepted = true;
        }

    function executeCommand(command, force) {
        if (command == Qt.Key_S) {
            // Switch simulation on / off
            simulation.running = !simulation.running;
        } else if (!simulation.running || force) {
            if (command == Qt.Key_F12) {
                // Debugview
                mainScreen.debugViewEnabled = !mainScreen.debugViewEnabled;
            } else if (command == Qt.Key_0) {
                // Intro (TODO: Does not work correctly)
                mainScreen.globalSportmode = false;
                mainScreen.state = "Intro";
            } else if (command == Qt.Key_1) {
                // Sport mode
                mainScreen.globalSportmode = true;
                mainScreen.state = "Sport";
            } else if (command == Qt.Key_2) {
                // Adas 1 mode
                mainScreen.globalSportmode = false;
                mainScreen.state = "Adas1";
            } else if (command == Qt.Key_3) {
                // Adas 2 mode
                mainScreen.globalSportmode = false;
                mainScreen.state = "Adas2";
            } else if (command == Qt.Key_4) {
                // Drive mode
                mainScreen.globalSportmode = false;
                mainScreen.state = "drive";
            } else if (command == Qt.Key_5) {
                // Charge Behind mode
                mainScreen.globalSportmode = false;
                mainScreen.state = "chargeBehind";
            } else if (command == Qt.Key_6) {
                // Charge Side mode
                mainScreen.globalSportmode = false;
                mainScreen.state = "chargeSide";
            } else if (command == Qt.Key_7) {
                // Charge Up mode
                mainScreen.globalSportmode = false;
                mainScreen.state = "chargeUp";
            } else  if (command == Qt.Key_Plus) {
                // Increase speed
                if (mainScreen.globalDrivespeed <= 239)
                    mainScreen.globalDrivespeed += 1;
            } else if (command == Qt.Key_Minus) {
                // Decrease speed
                if (mainScreen.globalDrivespeed >= 1)
                    mainScreen.globalDrivespeed -= 1;
            } else  if (command == Qt.Key_X) {
                // Increase battery
                if (mainScreen.globalBattery <= 95)
                    mainScreen.globalBattery += 5;
            } else if (command == Qt.Key_Z) {
                // Decrease battery
                if (mainScreen.globalBattery >= 5)
                    mainScreen.globalBattery -= 5;
            } else if (command == Qt.Key_Escape) {
                // Night / day mode toggle
                mainScreen.preventTransitionPause = true;
                mainScreen.globalNightMode = !mainScreen.globalNightMode;
                mainScreen.preventTransitionPause = false;
            } else if (command == Qt.Key_Q) {
                // Hills / city mode toggle
                mainScreen.globalCitymode = !mainScreen.globalCitymode;
            } else if (command == Qt.Key_W) {
                // LKAS mode toggle
                mainScreen.preventTransitionPause = true;
                mainScreen.globalLKASmode = !mainScreen.globalLKASmode;
                mainScreen.preventTransitionPause = false;
            } else if (command == Qt.Key_Up) {
                // Decrease distance to other car
                if (carDistance > -100 && !carMoving.running)
                    carDistance -= 30;
            } else if (command == Qt.Key_Down) {
                // Increase distance to other car
                if (carDistance < 100 && !carMoving.running)
                    carDistance += 30;		
            } else if (command == Qt.Key_N && !mainScreen.blockLaneChange && mainScreen.globalCurrentlane == 1) {
                // Overtake
                if (mainScreen.globalCurrentlane > 0)
                    mainScreen.globalCurrentlane--;
                mainScreen.globalLeftturnsignal = true;
				mainScreen.overtaking = true;
                overtakeStarter.running = true;
                mainScreen.leftAnimation = true;			
            } else if (command == Qt.Key_Left && !mainScreen.blockLaneChange) {
                // Change lane left
                if (mainScreen.globalCurrentlane > 0)
                    mainScreen.globalCurrentlane--;
                mainScreen.globalLeftturnsignal = true;
                turnLeftTimer.running = true;
                mainScreen.leftAnimation = true;
            } else if (command == Qt.Key_Right && !mainScreen.blockLaneChange) {
                // Change lane right
                if (mainScreen.globalCurrentlane < 2)
                    mainScreen.globalCurrentlane++;
                mainScreen.globalRightturnsignal = true;
                turnRightTimer.running = true;
                mainScreen.rightAnimation = true;
            } else if (command == Qt.Key_E) {
                // Switch upbar visibility
                mainScreen.showUpBar = !mainScreen.showUpBar;
            } else if (command == Qt.Key_R) {
                // Switch navigator visibility
                mainScreen.showNavigator = !mainScreen.showNavigator;
            } else if (command == Qt.Key_T) {
                // Switch main mask visibility
                mainScreen.showPanel = !mainScreen.showPanel;
            } else if (command == Qt.Key_Y) {
                // Switch navigator background blurring
                mainScreen.showNavigatorBlur = !mainScreen.showNavigatorBlur;
            } else if (command == Qt.Key_U) {
                // Switch main car headlights
                mainScreen.showHeadLights = !mainScreen.showHeadLights;
            }
        }
    }

    Behavior on carDistance {
        NumberAnimation {
            id: carMoving
            duration: 1000
            easing.type: Easing.InOutQuad
        }
    }

    Timer {
        id: turnLeftTimer
        interval: 7000
        running: false
        onTriggered: mainScreen.globalLeftturnsignal = false;
    }

    Timer {
        id: turnRightTimer
        interval: 7000
        running: false
        onTriggered: mainScreen.globalRightturnsignal = false;	
    }
	Timer {
        id: overtakeEnder
        interval: 7000
        running: false
        onTriggered: {
			mainScreen.globalRightturnsignal = false;
			mainScreen.overtaking = false;
			mainScreen.overtakeFinished = true;
		}
    }
	Timer {
        id: overtakeStarter
        interval: 7000
        running: false
        onTriggered: {
			mainScreen.globalLeftturnsignal = false;
			if (mainScreen.globalCurrentlane < 2)
                    mainScreen.globalCurrentlane++;
                mainScreen.globalRightturnsignal = true;
                overtakeEnder.running = true;
                mainScreen.rightAnimation = true;
				mainScreen.overtakeFinished = false;
		}
    }
    Timer {
        running: mainScreen.overtaking
        interval: 100
        repeat: true
        property int increase: 0
        onTriggered: {
            if (++increase <= 20)
                mainScreen.globalDrivespeed++;
        }
        onRunningChanged: {
            if (!running)
                increase = 0;
        }
    }
    Timer {
        running: !mainScreen.overtakeFinished
        interval: 300
        repeat: true
        property int decrease: 0
        onTriggered: {
            if (++decrease <= 20)
                mainScreen.globalDrivespeed--;
        }
        onRunningChanged: {
            if (!running)
                decrease = 0;
        }
    }

    SimuData {
        id: simulation
        running: false

        onSpeedChanged: {
            mainScreen.globalDrivespeed = speed;
        }

        onKeypressChanged: {
            executeCommand(keypress, true);
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:0.33}
}
##^##*/
