import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
Node {
    id: rootNode
    Model {
        id: hyperDrive
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/hyperDrive.mesh"

        DefaultMaterial {
            id: defaultMaterial_material
            lighting: DefaultMaterial.NoLighting
            diffuseMap: texture1
            diffuseColor: "#ffcccccc"

            Texture {
                id: texture1
                source: "../../../images/hyperdrive.png"
                positionV: -1
                scaleV: 20
            }
        }
        materials: [
            defaultMaterial_material
        ]
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 1000
                running: true
                loops: -1
                to: 1000
                from: 0
            }
        ]
        endFrame: 1000
        enabled: true
        startFrame: 0

        KeyframeGroup {
            target: texture1
            property: "positionV"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 1000
                value: -1
            }
        }
    }
}
