import QtQuick
import QtQuick3D
Model {
    id: adasBase
    property bool night: false
    property color nightColor: "#0d5812"
    property color dayColor: "#63c173"
    rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
    scale.x: 100
    scale.y: 100
    scale.z: 100
    source: "../AdasPlane2/meshes/plane.mesh"

    DefaultMaterial {
        id: green_material
        opacity: 0.7

        lighting: DefaultMaterial.FragmentLighting
        diffuseColor: "#2fc74a"
    }

    DefaultMaterial {
        id: white_material

        lighting: DefaultMaterial.FragmentLighting
        diffuseColor: "white"
        opacity: mainScreen.state == "Adas2" ? 1.0 : 0.0
        Behavior on opacity { NumberAnimation { duration: 1000 } }
    }
    materials: [
        green_material,
        white_material
    ]
    states: [
        State {
            name: "night"
            when: night == true

            PropertyChanges {
                target: green_material
                diffuseColor: nightColor
            }
        },
        State {
            name: "day"
            when: night == false

            PropertyChanges {
                target: green_material
                diffuseColor: dayColor
            }

            PropertyChanges {
                target: white_material
                diffuseColor: "#000000"
            }
        }
    ]
    transitions: Transition {
                    ColorAnimation {
                        properties: "diffuseColor"
                        easing.type: Easing.InOutQuad
                        duration: 1500
                    }
                }
}
