# Вступ до типів Python { #python-types-intro }

Python підтримує додаткові «підказки типів» (також звані «анотаціями типів»).

Ці **«підказки типів»** або анотації — це спеціальний синтаксис, що дозволяє оголошувати <dfn title="наприклад: str, int, float, bool">тип</dfn> змінної.

За допомогою оголошення типів для ваших змінних редактори та інструменти можуть надати вам кращу підтримку.

Це лише **швидкий навчальний посібник / нагадування** про підказки типів у Python. Він покриває лише мінімум, необхідний щоб використовувати їх з **FastAPI**... що насправді дуже мало.

**FastAPI** повністю базується на цих підказках типів, вони дають йому багато переваг і користі.

Але навіть якщо ви ніколи не використаєте **FastAPI**, вам буде корисно дізнатись трохи про них.

/// note | Примітка

Якщо ви експерт у Python і ви вже знаєте все про підказки типів, перейдіть до наступного розділу.

///

## Мотивація { #motivation }

Давайте почнемо з простого прикладу:

{* ../../docs_src/python_types/tutorial001_py310.py *}

Виклик цієї програми виводить:

```
John Doe
```

Функція виконує наступне:

* Бере `first_name` та `last_name`.
* Перетворює першу літеру кожного з них у верхній регістр за допомогою `title()`.
* <dfn title="Об’єднує їх разом, як одне ціле. З вмістом одного після іншого.">Конкатенує</dfn> їх разом із пробілом по середині.

{* ../../docs_src/python_types/tutorial001_py310.py hl[2] *}

### Редагуйте це { #edit-it }

Це дуже проста програма.

Але тепер уявіть, що ви писали це з нуля.

У певний момент ви розпочали б визначення функції, у вас були б готові параметри...

Але тоді вам потрібно викликати «той метод, який перетворює першу літеру у верхній регістр».

Це буде `upper`? Чи `uppercase`? `first_uppercase`? `capitalize`?

Тоді ви спробуєте давнього друга програміста — автозаповнення редактора коду.

Ви надрукуєте перший параметр функції, `first_name`, тоді крапку (`.`), а тоді натиснете `Ctrl+Space`, щоб запустити автозаповнення.

Але, на жаль, ви не отримаєте нічого корисного:

<img src="/img/python-types/image01.png">

### Додайте типи { #add-types }

Давайте змінимо один рядок з попередньої версії.

Ми змінимо саме цей фрагмент, параметри функції, з:

```Python
    first_name, last_name
```

на:

```Python
    first_name: str, last_name: str
```

Ось і все.

Це «підказки типів»:

{* ../../docs_src/python_types/tutorial002_py310.py hl[1] *}

Це не те саме, що оголошення значень за замовчуванням, як це було б з:

```Python
    first_name="john", last_name="doe"
```

Це зовсім інше.

Ми використовуємо двокрапку (`:`), не знак дорівнює (`=`).

І додавання підказок типів зазвичай не змінює того, що відбувається, порівняно з тим, що відбувалося б без них.

Але тепер уявіть, що ви знову посеред процесу створення функції, але з підказками типів.

У той самий момент ви спробуєте викликати автозаповнення за допомогою `Ctrl+Space` і побачите:

<img src="/img/python-types/image02.png">

Разом з цим ви можете прокручувати, переглядаючи опції, допоки не знайдете ту, що «щось вам підказує»:

<img src="/img/python-types/image03.png">

## Більше мотивації { #more-motivation }

Перевірте цю функцію, вона вже має підказки типів:

{* ../../docs_src/python_types/tutorial003_py310.py hl[1] *}

Оскільки редактор знає типи змінних, ви не тільки отримаєте автозаповнення, ви також отримаєте перевірку помилок:

<img src="/img/python-types/image04.png">

Тепер ви знаєте, щоб виправити це, вам потрібно перетворити `age` у строку за допомогою `str(age)`:

{* ../../docs_src/python_types/tutorial004_py310.py hl[2] *}

## Оголошення типів { #declaring-types }

Щойно ви побачили основне місце для оголошення підказок типів. Як параметри функції.

Це також основне місце, де ви б їх використовували у **FastAPI**.

### Прості типи { #simple-types }

Ви можете оголошувати усі стандартні типи у Python, не тільки `str`.

Ви можете використовувати, наприклад:

* `int`
* `float`
* `bool`
* `bytes`

{* ../../docs_src/python_types/tutorial005_py310.py hl[1] *}

### Модуль `typing` { #typing-module }

Для деяких додаткових випадків використання може знадобитися імпортувати елементи зі стандартної бібліотеки, модуля `typing`. Наприклад, коли ви хочете оголосити, що щось має «будь-який тип», ви можете використати `Any` з `typing`:

```python
from typing import Any


def some_function(data: Any):
    print(data)
```

### Generic типи { #generic-types }

Деякі типи можуть приймати «параметри типів» у квадратних дужках, щоб визначити їх внутрішні типи. Наприклад, «list строк» буде оголошений як `list[str]`.

Ці типи, які можуть приймати параметри типів, називаються **generic типами** або **generics**.

Ви можете використовувати ті самі вбудовані типи як generics (з квадратними дужками та типами всередині):

* `list`
* `tuple`
* `set`
* `dict`

#### List { #list }

Наприклад, давайте визначимо змінну, яка буде `list` із `str`.

Оголосіть змінну з тим самим синтаксисом двокрапки (`:`).

Як тип вкажіть `list`.

Оскільки список є типом, який містить деякі внутрішні типи, ви поміщаєте їх у квадратні дужки:

{* ../../docs_src/python_types/tutorial006_py310.py hl[1] *}

/// info | Інформація

Ці внутрішні типи в квадратних дужках називаються «параметрами типу».

У цьому випадку `str` — це параметр типу, переданий у `list`.

///

Це означає: «змінна `items` — це `list`, і кожен з елементів у цьому списку — `str`».

Зробивши це, ваш редактор може надати підтримку навіть під час обробки елементів зі списку:

<img src="/img/python-types/image05.png">

Без типів цього майже неможливо досягти.

Зверніть увагу, що змінна `item` є одним із елементів у списку `items`.

І все ж редактор знає, що це `str`, і надає підтримку для цього.

#### Tuple and Set { #tuple-and-set }

Ви повинні зробити те ж саме, щоб оголосити `tuple` і `set`:

{* ../../docs_src/python_types/tutorial007_py310.py hl[1] *}

Це означає:

* Змінна `items_t` — це `tuple` з 3 елементами: `int`, ще `int`, та `str`.
* Змінна `items_s` — це `set`, і кожен його елемент має тип `bytes`.

#### Dict { #dict }

Щоб оголосити `dict`, вам потрібно передати 2 параметри типу, розділені комами.

Перший параметр типу для ключів у `dict`.

Другий параметр типу для значень у `dict`:

{* ../../docs_src/python_types/tutorial008_py310.py hl[1] *}

Це означає:

* Змінна `prices` — це `dict`:
    * Ключі цього `dict` мають тип `str` (скажімо, назва кожного предмета).
    * Значення цього `dict` мають тип `float` (скажімо, ціна кожного предмета).

#### Union { #union }

Ви можете оголосити, що змінна може бути будь-яким із **кількох типів**, наприклад `int` або `str`.

Щоб визначити це, використовуйте <dfn title='також називають «побітовим оператором "або"», але це значення тут не актуальне'>вертикальну риску (`|`)</dfn>, щоб розділити обидва типи.

Це називається «union», тому що змінна може бути чимось із об’єднання цих двох множин типів.

```Python hl_lines="1"
{!> ../../docs_src/python_types/tutorial008b_py310.py!}
```

Це означає, що `item` може бути `int` або `str`.

#### Можливо `None` { #possibly-none }

Ви можете оголосити, що значення може мати тип, наприклад `str`, але також може бути `None`.

//// tab | Python 3.10+

```Python hl_lines="1"
{!> ../../docs_src/python_types/tutorial009_py310.py!}
```

////

Використання `str | None` замість просто `str` дозволить редактору допомогти вам виявити помилки, коли ви могли б вважати, що значенням завжди є `str`, хоча насправді воно також може бути `None`.

### Класи як типи { #classes-as-types }

Ви також можете оголосити клас як тип змінної.

Скажімо, у вас є клас `Person` з імʼям:

{* ../../docs_src/python_types/tutorial010_py310.py hl[1:3] *}

Потім ви можете оголосити змінну типу `Person`:

{* ../../docs_src/python_types/tutorial010_py310.py hl[6] *}

І знову ж таки, ви отримуєте всю підтримку редактора:

<img src="/img/python-types/image06.png">

Зверніть увагу, що це означає: «`one_person` — це **екземпляр** класу `Person`».

Це не означає: «`one_person` — це **клас** з назвою `Person`».

## Pydantic моделі { #pydantic-models }

<a href="https://docs.pydantic.dev/" class="external-link" target="_blank">Pydantic</a> — це бібліотека Python для валідації даних.

Ви оголошуєте «форму» даних як класи з атрибутами.

І кожен атрибут має тип.

Потім ви створюєте екземпляр цього класу з деякими значеннями, і він перевірить ці значення, перетворить їх у відповідний тип (якщо є потреба) і надасть вам об’єкт з усіма даними.

І ви отримуєте всю підтримку редактора з цим отриманим об’єктом.

Приклад з офіційної документації Pydantic:

{* ../../docs_src/python_types/tutorial011_py310.py *}

/// info | Інформація

Щоб дізнатись більше про <a href="https://docs.pydantic.dev/" class="external-link" target="_blank">Pydantic, перегляньте його документацію</a>.

///

**FastAPI** повністю базується на Pydantic.

Ви побачите набагато більше цього всього на практиці в [Навчальний посібник - Посібник користувача](tutorial/index.md){.internal-link target=_blank}.

## Підказки типів з анотаціями метаданих { #type-hints-with-metadata-annotations }

У Python також є можливість додавати **додаткові <dfn title="Дані про дані, у цьому випадку — інформація про тип, наприклад опис.">метадані</dfn>** до цих підказок типів за допомогою `Annotated`.

Ви можете імпортувати `Annotated` з `typing`.

{* ../../docs_src/python_types/tutorial013_py310.py hl[1,4] *}

Сам Python нічого не робить із цим `Annotated`. А для редакторів та інших інструментів тип усе ще є `str`.

Але ви можете використати це місце в `Annotated`, щоб надати **FastAPI** додаткові метадані про те, як ви хочете, щоб ваш застосунок поводився.

Важливо пам’ятати, що **перший *параметр типу***, який ви передаєте в `Annotated`, — це **фактичний тип**. Решта — це лише метадані для інших інструментів.

Наразі вам просто потрібно знати, що `Annotated` існує і що це стандартний Python. 😎

Пізніше ви побачите, наскільки **потужним** це може бути.

/// tip | Порада

Той факт, що це **стандартний Python**, означає, що ви й надалі отримуватимете **найкращий можливий досвід розробки** у вашому редакторі, з інструментами, які ви використовуєте для аналізу та рефакторингу коду тощо. ✨

А також те, що ваш код буде дуже сумісним із багатьма іншими інструментами та бібліотеками Python. 🚀

///

## Підказки типів у **FastAPI** { #type-hints-in-fastapi }

**FastAPI** використовує ці підказки типів для виконання кількох речей.

З **FastAPI** ви оголошуєте параметри з підказками типів, і отримуєте:

* **Підтримку редактора**.
* **Перевірку типів**.

...і **FastAPI** використовує ті самі оголошення для:

* **Визначення вимог**: з параметрів шляху запиту, параметрів запиту, заголовків, тіл, залежностей тощо.
* **Перетворення даних**: із запиту в необхідний тип.
* **Перевірки даних**: що надходять від кожного запиту:
    * Генерування **автоматичних помилок**, що повертаються клієнту, коли дані недійсні.
* **Документування** API за допомогою OpenAPI:
    * який потім використовується для автоматичної інтерактивної документації користувальницьких інтерфейсів.

Все це може здатися абстрактним. Не хвилюйтеся. Ви побачите все це в дії в [Навчальний посібник - Посібник користувача](tutorial/index.md){.internal-link target=_blank}.

Важливо те, що за допомогою стандартних типів Python в одному місці (замість того, щоб додавати більше класів, декораторів тощо), **FastAPI** зробить багато роботи за вас.

/// info | Інформація

Якщо ви вже пройшли весь навчальний посібник і повернулися, щоб дізнатися більше про типи, ось хороший ресурс: <a href="https://mypy.readthedocs.io/en/latest/cheat_sheet_py3.html" class="external-link" target="_blank">«шпаргалка» від `mypy`</a>.

///
