# Кукі у відповіді { #response-cookies }

## Використовуйте параметр `Response` { #use-a-response-parameter }

Ви можете оголосити параметр типу `Response` у вашій *функції операції шляху*.

Потім ви можете встановити кукі в цьому *тимчасовому* об'єкті відповіді.

{* ../../docs_src/response_cookies/tutorial002_py310.py hl[1, 8:9] *}

Після цього ви можете повернути будь-який потрібний об'єкт, як зазвичай (наприклад, `dict`, модель бази даних тощо).

І якщо ви оголосили `response_model`, він усе одно буде використаний для фільтрації та перетворення об'єкта, який ви повернули.

**FastAPI** використає цю *тимчасову* відповідь, щоб витягнути кукі (а також заголовки та код статусу) і помістить їх у фінальну відповідь, що містить значення, яке ви повернули, відфільтроване будь-якою `response_model`.

Ви також можете оголосити параметр `Response` у залежностях і встановлювати в них кукі (і заголовки).

## Повертайте `Response` безпосередньо { #return-a-response-directly }

Ви також можете створювати кукі, повертаючи `Response` безпосередньо у вашому коді.

Для цього ви можете створити відповідь, як описано в [Повернути відповідь безпосередньо](response-directly.md){.internal-link target=_blank}.

Потім встановіть у ньому кукі і поверніть його:

{* ../../docs_src/response_cookies/tutorial001_py310.py hl[10:12] *}

/// tip | Порада

Майте на увазі, що якщо ви повертаєте відповідь безпосередньо замість використання параметра `Response`, FastAPI поверне її напряму.

Тому вам потрібно переконатися, що ваші дані мають коректний тип. Наприклад, сумісні з JSON, якщо ви повертаєте `JSONResponse`.

А також що ви не надсилаєте дані, які мали б бути відфільтровані за допомогою `response_model`.

///

### Більше інформації { #more-info }

/// note | Технічні деталі

Ви також можете використати `from starlette.responses import Response` або `from starlette.responses import JSONResponse`.

**FastAPI** надає ті самі `starlette.responses` як `fastapi.responses` лише для зручності для вас, розробника. Але більшість доступних відповідей надходять безпосередньо зі Starlette.

І оскільки `Response` часто використовується для встановлення заголовків і кукі, **FastAPI** також надає його як `fastapi.Response`.

///

Щоб побачити всі доступні параметри та опції, перегляньте <a href="https://www.starlette.dev/responses/#set-cookie" class="external-link" target="_blank">документацію в Starlette</a>.
